/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import ca.pfv.spmf.algorithms.graph_mining.aerminer.AttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.ParametersSettingAERMiner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ReadGraph {
    private static boolean ALLASDOUBLE = true;
    private static int TOTAL_NUM_ATTR = ParametersSettingAERMiner.TOTAL_NUM_ATTR;
    private static String ATTR_FILE_PATH = ParametersSettingAERMiner.ATTR_FILE_PATH;
    private static String EDGE_FILE_PATH = ParametersSettingAERMiner.EDGE_FILE_PATH;

    public static void main(String[] args) throws IOException {
        ReadGraph.statGraph();
    }

    public static void statGraph() throws IOException {
        Map<Integer, AttributedGraph> dyAG = ReadGraph.readGraph();
        System.out.println(dyAG.get(0).getAllVerticeId());
        int numTimestamps = dyAG.size();
        int numVertices = dyAG.get(0).getVerNum();
        int totalCount4E = 0;
        for (Map.Entry<Integer, AttributedGraph> entry : dyAG.entrySet()) {
            Integer i = entry.getKey();
            AttributedGraph aG = dyAG.get(i);
            for (Map.Entry<Integer, Set<Integer>> edgeLinkEntry : aG.getEdgesMap().entrySet()) {
                totalCount4E += edgeLinkEntry.getValue().size();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("total timestamps: ").append(numTimestamps);
        sb.append("\ntotal vertices: ").append(numVertices);
        sb.append("\naverage edges for each vertex each timestamp: ").append(1.0 * (double)totalCount4E / (double)(numTimestamps * numVertices));
        System.out.println(sb.toString());
    }

    public static Map<Integer, AttributedGraph> readGraph() throws IOException {
        System.out.println("@@@ start to read original graph ...");
        HashMap<Integer, AttributedGraph> DyAG = new HashMap<Integer, AttributedGraph>();
        ReadGraph.readAttributes(DyAG);
        ReadGraph.readEdges(DyAG);
        System.out.println("reading graph finish !");
        return DyAG;
    }

    private static void readEdges(Map<Integer, AttributedGraph> DyAG) throws IOException {
        TOTAL_NUM_ATTR = ParametersSettingAERMiner.TOTAL_NUM_ATTR;
        ATTR_FILE_PATH = ParametersSettingAERMiner.ATTR_FILE_PATH;
        EDGE_FILE_PATH = ParametersSettingAERMiner.EDGE_FILE_PATH;
        BufferedReader brEdges = new BufferedReader(new FileReader(EDGE_FILE_PATH));
        String line2 = brEdges.readLine();
        while (line2 != null) {
            if (!line2.startsWith("T")) continue;
            int aGId = Integer.parseInt(line2.split("T")[1]);
            AttributedGraph aG = DyAG.get(aGId);
            while ((line2 = brEdges.readLine()) != null && !line2.startsWith("T")) {
                ReadGraph.edgeLineProcess(aG, line2);
            }
        }
        brEdges.close();
    }

    private static void readAttributes(Map<Integer, AttributedGraph> DyAG) throws IOException {
        ATTR_FILE_PATH = ParametersSettingAERMiner.ATTR_FILE_PATH;
        BufferedReader brAttr = new BufferedReader(new FileReader(ATTR_FILE_PATH));
        String line1 = brAttr.readLine();
        int count = 0;
        while (line1 != null) {
            if (line1.startsWith("T")) {
                AttributedGraph aG = new AttributedGraph(count);
                while ((line1 = brAttr.readLine()) != null && !line1.startsWith("T")) {
                    ReadGraph.attrLineProcess(aG, line1);
                }
                DyAG.put(count, aG);
            }
            ++count;
        }
        brAttr.close();
    }

    private static void edgeLineProcess(AttributedGraph aG, String line) {
        String[] items = line.split(" ");
        Integer vId = Integer.parseInt(items[0]);
        LinkedList<Integer> neighbors = new LinkedList<Integer>();
        int i = 1;
        while (i < items.length) {
            neighbors.add(Integer.parseInt(items[i]));
            ++i;
        }
        aG.addEdges(vId, neighbors);
    }

    private static void attrLineProcess(AttributedGraph aG, String line) {
        String[] items = line.split(" ");
        Integer vId = Integer.parseInt(items[0]);
        aG.addVertex(vId);
        if (ALLASDOUBLE) {
            LinkedList<Integer> attrTypes = new LinkedList<Integer>();
            LinkedList<Double> attrVals = new LinkedList<Double>();
            int i = 1;
            while (i < TOTAL_NUM_ATTR + 1) {
                Double val = Double.parseDouble(items[i]);
                attrTypes.add(i);
                attrVals.add(val);
                ++i;
            }
            aG.addAttrValForV(vId, attrTypes, attrVals);
        }
    }
}

