/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.DFSCode;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Edge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.ExtendedEdge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.FrequentSubgraph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Graph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Vertex;
import ca.pfv.spmf.algorithms.graph_mining.tkg.VizGraph;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class AlgoTKG {
    private int k;
    private int minSup;
    PriorityQueue<FrequentSubgraph> kSubgraphs;
    PriorityQueue<FrequentSubgraph> candidates;
    private long runtime = 0L;
    private double maxmemory = 0.0;
    private int patternCount = 0;
    private int graphCount = 0;
    List<Integer> frequentVertexLabels;
    private static final boolean DEBUG_MODE = false;
    private static final boolean ELIMINATE_INFREQUENT_VERTICES = false;
    private static final boolean ELIMINATE_INFREQUENT_VERTEX_PAIRS = false;
    private static final boolean ELIMINATE_INFREQUENT_EDGE_LABELS = false;
    private static final boolean EDGE_COUNT_PRUNING = false;
    private static final boolean DYNAMIC_SEARCH = true;
    private static final boolean THREADED_DYNAMIC_SEARCH = true;
    private int THREAD_COUNT = 1;
    int infrequentVertexPairsRemoved;
    int infrequentVerticesRemovedCount;
    int edgeRemovedByLabel;
    int eliminatedWithMaxSize;
    int emptyGraphsRemoved;
    int pruneByEdgeCountCount;
    int skipStrategyCount;
    int maxNumberOfEdges = Integer.MAX_VALUE;
    boolean outputGraphIds = true;

    public void runAlgorithm(String inPath, String outPath, int k, boolean outputSingleVertices, boolean outputDotFile, int maxNumberOfEdges, boolean outputGraphIds) throws IOException, ClassNotFoundException {
        this.k = k;
        if (maxNumberOfEdges <= 0) {
            return;
        }
        this.maxNumberOfEdges = maxNumberOfEdges;
        this.outputGraphIds = outputGraphIds;
        this.infrequentVertexPairsRemoved = 0;
        this.infrequentVerticesRemovedCount = 0;
        this.edgeRemovedByLabel = 0;
        this.eliminatedWithMaxSize = 0;
        this.emptyGraphsRemoved = 0;
        this.pruneByEdgeCountCount = 0;
        this.kSubgraphs = new PriorityQueue();
        this.candidates = new PriorityQueue<FrequentSubgraph>(new Comparator<FrequentSubgraph>(){

            @Override
            public int compare(FrequentSubgraph o1, FrequentSubgraph o2) {
                return -o1.compareTo(o2);
            }
        });
        MemoryLogger.getInstance().reset();
        this.patternCount = 0;
        Long t1 = System.currentTimeMillis();
        List<Graph> graphDB = this.readGraphs(inPath);
        this.minSup = 1;
        this.gSpan(graphDB, outputSingleVertices);
        MemoryLogger.getInstance().checkMemory();
        this.writeResultToFile(outPath);
        Long t2 = System.currentTimeMillis();
        this.runtime = (t2 - t1) / 1000L;
        this.maxmemory = MemoryLogger.getInstance().getMaxMemory();
        this.patternCount = this.kSubgraphs.size();
        if (outputDotFile) {
            AlgoTKG.outputDotFile(outPath);
        }
    }

    private void savePattern(FrequentSubgraph graph) {
        int previousMinSup = this.minSup;
        this.kSubgraphs.add(graph);
        if (this.kSubgraphs.size() > this.k && graph.support > this.minSup) {
            do {
                FrequentSubgraph lower = this.kSubgraphs.peek();
                if (lower.support > this.minSup || lower == null) {
                    System.out.println("YES");
                    break;
                }
                this.kSubgraphs.remove(lower);
            } while (this.kSubgraphs.size() > this.k);
            this.minSup = this.kSubgraphs.peek().support;
        }
    }

    private static void outputDotFile(String outputPath) throws IOException {
        String dirName = String.valueOf(outputPath) + "_dotfile";
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdir();
        }
        VizGraph.visulizeFromFile(outputPath, dirName);
    }

    private void writeResultToFile(String outputPath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputPath)));
        int i = 0;
        for (FrequentSubgraph subgraph : this.kSubgraphs) {
            StringBuilder sb = new StringBuilder();
            DFSCode dfsCode = subgraph.dfsCode;
            sb.append("t # ").append(i).append(" * ").append(subgraph.support).append(System.lineSeparator());
            if (dfsCode.size() == 1) {
                ExtendedEdge ee = dfsCode.getEeL().get(0);
                if (ee.getEdgeLabel() == -1) {
                    sb.append("v 0 ").append(ee.getvLabel1()).append(System.lineSeparator());
                } else {
                    sb.append("v 0 ").append(ee.getvLabel1()).append(System.lineSeparator());
                    sb.append("v 1 ").append(ee.getvLabel2()).append(System.lineSeparator());
                    sb.append("e 0 1 ").append(ee.getEdgeLabel()).append(System.lineSeparator());
                }
            } else {
                List<Integer> vLabels = dfsCode.getAllVLabels();
                int j = 0;
                while (j < vLabels.size()) {
                    sb.append("v ").append(j).append(" ").append(vLabels.get(j)).append(System.lineSeparator());
                    ++j;
                }
                for (ExtendedEdge ee : dfsCode.getEeL()) {
                    int startV = ee.getV1();
                    int endV = ee.getV2();
                    int eL = ee.edgeLabel;
                    sb.append("e ").append(startV).append(" ").append(endV).append(" ").append(eL).append(System.lineSeparator());
                }
            }
            if (this.outputGraphIds) {
                sb.append("x");
                for (int id : subgraph.setOfGraphsIDs) {
                    sb.append(" ").append(id);
                }
            }
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            bw.write(sb.toString());
            ++i;
        }
        bw.close();
    }

    private List<Graph> readGraphs(String path) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(new File(path)));
        ArrayList<Graph> graphDatabase = new ArrayList<Graph>();
        String line = br.readLine();
        Boolean hasNextGraph = line != null && line.startsWith("t");
        while (hasNextGraph.booleanValue()) {
            hasNextGraph = false;
            int gId = Integer.parseInt(line.split(" ")[2]);
            HashMap<Integer, Vertex> vMap = new HashMap<Integer, Vertex>();
            while ((line = br.readLine()) != null && !line.startsWith("t")) {
                String[] items = line.split(" ");
                if (line.startsWith("v")) {
                    int vId = Integer.parseInt(items[1]);
                    int vLabel = Integer.parseInt(items[2]);
                    vMap.put(vId, new Vertex(vId, vLabel));
                    continue;
                }
                if (!line.startsWith("e")) continue;
                int v1 = Integer.parseInt(items[1]);
                int v2 = Integer.parseInt(items[2]);
                int eLabel = Integer.parseInt(items[3]);
                Edge e = new Edge(v1, v2, eLabel);
                ((Vertex)vMap.get(v1)).addEdge(e);
                ((Vertex)vMap.get(v2)).addEdge(e);
            }
            graphDatabase.add(new Graph(gId, vMap));
            if (line == null) continue;
            hasNextGraph = true;
        }
        br.close();
        this.graphCount = graphDatabase.size();
        return graphDatabase;
    }

    private List<Map<Integer, Integer>> subgraphIsomorphisms(DFSCode c, Graph g) {
        ArrayList<Map<Integer, Integer>> isoms = new ArrayList<Map<Integer, Integer>>();
        int startLabel = c.getEeL().get(0).getvLabel1();
        int[] nArray = g.findAllWithLabel(startLabel);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int vID = nArray[n2];
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            map.put(0, vID);
            isoms.add(map);
            ++n2;
        }
        for (ExtendedEdge ee : c.getEeL()) {
            int v1 = ee.getV1();
            int v2 = ee.getV2();
            int v2Label = ee.getvLabel2();
            int eLabel = ee.getEdgeLabel();
            ArrayList<Map> updateIsoms = new ArrayList<Map>();
            for (Map map : isoms) {
                int mappedV1 = (Integer)map.get(v1);
                if (v1 < v2) {
                    Collection mappedVertices = map.values();
                    Vertex[] vertexArray = g.getAllNeighbors(mappedV1);
                    int n3 = vertexArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Vertex mappedV2 = vertexArray[n4];
                        if (v2Label == mappedV2.getLabel() && !mappedVertices.contains(mappedV2.getId()) && eLabel == g.getEdgeLabel(mappedV1, mappedV2.getId())) {
                            HashMap<Integer, Integer> tempM = new HashMap<Integer, Integer>(map.size() + 1);
                            tempM.putAll(map);
                            tempM.put(v2, mappedV2.getId());
                            updateIsoms.add(tempM);
                        }
                        ++n4;
                    }
                    continue;
                }
                int mappedV2 = (Integer)map.get(v2);
                if (!g.isNeighboring(mappedV1, mappedV2) || eLabel != g.getEdgeLabel(mappedV1, mappedV2)) continue;
                updateIsoms.add(map);
            }
            isoms = updateIsoms;
        }
        return isoms;
    }

    private Map<ExtendedEdge, Set<Integer>> rightMostPathExtensionsFromSingle(DFSCode c, Graph g) {
        int gid = g.getId();
        HashMap<ExtendedEdge, Set<Integer>> extensions = new HashMap<ExtendedEdge, Set<Integer>>();
        if (c.isEmpty()) {
            Vertex[] vertexArray = g.vertices;
            int n = g.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                for (Edge e : vertex.getEdgeList()) {
                    int v2L;
                    int v1L = g.getVLabel(e.v1);
                    ExtendedEdge ee1 = v1L < (v2L = g.getVLabel(e.v2)) ? new ExtendedEdge(0, 1, v1L, v2L, e.getEdgeLabel()) : new ExtendedEdge(0, 1, v2L, v1L, e.getEdgeLabel());
                    HashSet<Integer> setOfGraphIDs = (HashSet<Integer>)extensions.get(ee1);
                    if (setOfGraphIDs == null) {
                        setOfGraphIDs = new HashSet<Integer>();
                        extensions.put(ee1, setOfGraphIDs);
                    }
                    setOfGraphIDs.add(gid);
                }
                ++n2;
            }
        } else {
            int rightMost = c.getRightMost();
            List<Map<Integer, Integer>> isoms = this.subgraphIsomorphisms(c, g);
            for (Map<Integer, Integer> isom : isoms) {
                HashMap<Integer, Integer> invertedISOM = new HashMap<Integer, Integer>();
                for (Map.Entry<Integer, Integer> entry : isom.entrySet()) {
                    invertedISOM.put(entry.getValue(), entry.getKey());
                }
                int mappedRM = isom.get(rightMost);
                int mappedRMlabel = g.getVLabel(mappedRM);
                Vertex[] vertexArray = g.getAllNeighbors(mappedRM);
                int n = vertexArray.length;
                int ee1 = 0;
                while (ee1 < n) {
                    Vertex x = vertexArray[ee1];
                    Integer invertedX = (Integer)invertedISOM.get(x.getId());
                    if (invertedX != null && c.onRightMostPath(invertedX) && c.notPreOfRM(invertedX) && !c.containEdge(rightMost, invertedX)) {
                        ExtendedEdge ee = new ExtendedEdge(rightMost, invertedX, mappedRMlabel, x.getLabel(), g.getEdgeLabel(mappedRM, x.getId()));
                        if (extensions.get(ee) == null) {
                            extensions.put(ee, new HashSet());
                        }
                        ((Set)extensions.get(ee)).add(g.getId());
                    }
                    ++ee1;
                }
                Collection<Integer> mappedVertices = isom.values();
                for (int v : c.getRightMostPath()) {
                    int mappedV = isom.get(v);
                    int mappedVlabel = g.getVLabel(mappedV);
                    Vertex[] vertexArray2 = g.getAllNeighbors(mappedV);
                    int n3 = vertexArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Vertex x = vertexArray2[n4];
                        if (!mappedVertices.contains(x.getId())) {
                            ExtendedEdge ee = new ExtendedEdge(v, rightMost + 1, mappedVlabel, x.getLabel(), g.getEdgeLabel(mappedV, x.getId()));
                            if (extensions.get(ee) == null) {
                                extensions.put(ee, new HashSet());
                            }
                            ((Set)extensions.get(ee)).add(g.getId());
                        }
                        ++n4;
                    }
                }
            }
        }
        return extensions;
    }

    private Map<ExtendedEdge, Set<Integer>> rightMostPathExtensions(DFSCode c, List<Graph> graphDatabase, Set<Integer> graphIds) {
        HashMap<ExtendedEdge, Set<Integer>> extensions = new HashMap<ExtendedEdge, Set<Integer>>();
        if (c.isEmpty()) {
            for (Integer graphId : graphIds) {
                Graph g = graphDatabase.get(graphId);
                Vertex[] vertexArray = g.vertices;
                int n = g.vertices.length;
                int n2 = 0;
                while (n2 < n) {
                    Vertex vertex = vertexArray[n2];
                    for (Edge e : vertex.getEdgeList()) {
                        int v2L;
                        int v1L = g.getVLabel(e.v1);
                        ExtendedEdge ee1 = v1L < (v2L = g.getVLabel(e.v2)) ? new ExtendedEdge(0, 1, v1L, v2L, e.getEdgeLabel()) : new ExtendedEdge(0, 1, v2L, v1L, e.getEdgeLabel());
                        HashSet<Integer> setOfGraphIDs = (HashSet<Integer>)extensions.get(ee1);
                        if (setOfGraphIDs == null) {
                            setOfGraphIDs = new HashSet<Integer>();
                            extensions.put(ee1, setOfGraphIDs);
                        }
                        setOfGraphIDs.add(graphId);
                    }
                    ++n2;
                }
            }
        } else {
            int rightMost = c.getRightMost();
            for (Integer graphId : graphIds) {
                Graph g = graphDatabase.get(graphId);
                List<Map<Integer, Integer>> isoms = this.subgraphIsomorphisms(c, g);
                for (Map<Integer, Integer> isom : isoms) {
                    HashMap<Integer, Integer> invertedISOM = new HashMap<Integer, Integer>();
                    for (Map.Entry<Integer, Integer> entry : isom.entrySet()) {
                        invertedISOM.put(entry.getValue(), entry.getKey());
                    }
                    int mappedRM = isom.get(rightMost);
                    int mappedRMlabel = g.getVLabel(mappedRM);
                    Vertex[] vertexArray = g.getAllNeighbors(mappedRM);
                    int n = vertexArray.length;
                    int ee1 = 0;
                    while (ee1 < n) {
                        Vertex x = vertexArray[ee1];
                        Integer invertedX = (Integer)invertedISOM.get(x.getId());
                        if (invertedX != null && c.onRightMostPath(invertedX) && c.notPreOfRM(invertedX) && !c.containEdge(rightMost, invertedX)) {
                            ExtendedEdge ee = new ExtendedEdge(rightMost, invertedX, mappedRMlabel, x.getLabel(), g.getEdgeLabel(mappedRM, x.getId()));
                            if (extensions.get(ee) == null) {
                                extensions.put(ee, new HashSet());
                            }
                            ((Set)extensions.get(ee)).add(g.getId());
                        }
                        ++ee1;
                    }
                    Collection<Integer> mappedVertices = isom.values();
                    for (int v : c.getRightMostPath()) {
                        int mappedV = isom.get(v);
                        int mappedVlabel = g.getVLabel(mappedV);
                        Vertex[] vertexArray2 = g.getAllNeighbors(mappedV);
                        int n3 = vertexArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Vertex x = vertexArray2[n4];
                            if (!mappedVertices.contains(x.getId())) {
                                ExtendedEdge ee = new ExtendedEdge(v, rightMost + 1, mappedVlabel, x.getLabel(), g.getEdgeLabel(mappedV, x.getId()));
                                if (extensions.get(ee) == null) {
                                    extensions.put(ee, new HashSet());
                                }
                                Set setOfGraphIDs = (Set)extensions.get(ee);
                                setOfGraphIDs.add(g.getId());
                            }
                            ++n4;
                        }
                    }
                }
            }
        }
        return extensions;
    }

    private void gSpan(List<Graph> graphDB, boolean outputFrequentVertices) throws IOException, ClassNotFoundException {
        if (outputFrequentVertices) {
            this.findAllOnlyOneVertex(graphDB, outputFrequentVertices);
        }
        for (Graph g : graphDB) {
            g.precalculateVertexList();
        }
        HashSet<Integer> graphIds = new HashSet<Integer>();
        int i = 0;
        while (i < graphDB.size()) {
            Graph g = graphDB.get(i);
            if (g.vertices == null || g.vertices.length != 0) {
                if (this.infrequentVerticesRemovedCount > 0) {
                    g.precalculateVertexList();
                }
                graphIds.add(i);
                g.precalculateVertexNeighbors();
                g.precalculateLabelsToVertices();
            } else {
                ++this.emptyGraphsRemoved;
            }
            ++i;
        }
        if (!outputFrequentVertices || this.frequentVertexLabels.size() != 0) {
            this.gSpanDynamicDFS(new DFSCode(), graphDB, graphIds);
            i = 0;
            while (i < this.THREAD_COUNT) {
                DFSThread thread = new DFSThread(graphDB);
                ((Thread)thread).start();
                ++i;
            }
        }
    }

    private void removeInfrequentVertexPairs(List<Graph> graphDB) {
        for (Graph g : graphDB) {
            Vertex[] vertices = g.getAllVertices();
            int i = 0;
            while (i < vertices.length) {
                Vertex v1 = vertices[i];
                int labelV1 = v1.getLabel();
                for (Edge edge : v1.getEdgeList()) {
                    int v2 = edge.another(v1.getId());
                    int n = g.getVLabel(v2);
                }
                ++i;
            }
        }
        Object alreadySeenPair = null;
    }

    private void gSpanDFS(DFSCode c, List<Graph> graphDB, Set<Integer> graphIds) throws IOException, ClassNotFoundException {
        if (c.size() == this.maxNumberOfEdges - 1) {
            return;
        }
        Map<ExtendedEdge, Set<Integer>> extensions = this.rightMostPathExtensions(c, graphDB, graphIds);
        if (extensions == null) {
            return;
        }
        for (Map.Entry<ExtendedEdge, Set<Integer>> entry : extensions.entrySet()) {
            Set<Integer> newGraphIDs = entry.getValue();
            int sup = newGraphIDs.size();
            if (sup < this.minSup) continue;
            DFSCode newC = c.copy();
            ExtendedEdge extension = entry.getKey();
            newC.add(extension);
            if (!this.isCanonical(newC)) continue;
            FrequentSubgraph subgraph = new FrequentSubgraph(newC, newGraphIDs, sup);
            this.savePattern(subgraph);
            this.gSpanDFS(newC, graphDB, newGraphIDs);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void gSpanDynamicDFS(DFSCode c, List<Graph> graphDB, Set<Integer> graphIds) throws IOException, ClassNotFoundException {
        if (c.size() == this.maxNumberOfEdges - 1) {
            return;
        }
        Map<ExtendedEdge, Set<Integer>> extensions = this.rightMostPathExtensions(c, graphDB, graphIds);
        for (Map.Entry<ExtendedEdge, Set<Integer>> entry : extensions.entrySet()) {
            Set<Integer> newGraphIDs = entry.getValue();
            int sup = newGraphIDs.size();
            if (sup < this.minSup) continue;
            DFSCode newC = c.copy();
            ExtendedEdge extension = entry.getKey();
            newC.add(extension);
            if (!this.isCanonical(newC)) continue;
            FrequentSubgraph subgraph = new FrequentSubgraph(newC, newGraphIDs, sup);
            this.savePattern(subgraph);
            this.registerAsCandidate(subgraph);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void registerAsCandidate(FrequentSubgraph subgraph) {
        this.candidates.add(subgraph);
    }

    private boolean isCanonical(DFSCode c) {
        DFSCode canC = new DFSCode();
        int i = 0;
        while (i < c.size()) {
            Map<ExtendedEdge, Set<Integer>> extensions = this.rightMostPathExtensionsFromSingle(canC, new Graph(c));
            ExtendedEdge minEE = null;
            for (ExtendedEdge ee : extensions.keySet()) {
                if (!ee.smallerThan(minEE)) continue;
                minEE = ee;
            }
            if (minEE.smallerThan(c.getAt(i))) {
                return false;
            }
            canC.add(minEE);
            ++i;
        }
        return true;
    }

    private void findAllOnlyOneVertex(List<Graph> graphDB, boolean outputFrequentVertices) {
        this.frequentVertexLabels = new ArrayList<Integer>();
        HashMap<Integer, HashSet<Integer>> labelM = new HashMap<Integer, HashSet<Integer>>();
        for (Graph graph : graphDB) {
            for (Vertex v : graph.getNonPrecalculatedAllVertices()) {
                if (v.getEdgeList().isEmpty()) continue;
                Integer vLabel = v.getLabel();
                HashSet<Integer> set = (HashSet<Integer>)labelM.get(vLabel);
                if (set == null) {
                    set = new HashSet<Integer>();
                    labelM.put(vLabel, set);
                }
                set.add(graph.getId());
            }
        }
        for (Map.Entry entry : labelM.entrySet()) {
            int label = (Integer)entry.getKey();
            Set tempSupG = (Set)entry.getValue();
            int sup = tempSupG.size();
            if (sup < this.minSup) continue;
            this.frequentVertexLabels.add(label);
            if (!outputFrequentVertices) continue;
            DFSCode tempD = new DFSCode();
            tempD.add(new ExtendedEdge(0, 0, label, label, -1));
            this.savePattern(new FrequentSubgraph(tempD, tempSupG, sup));
        }
    }

    public void printStats() {
        System.out.println("=============  TopKGSPAN v2.40 - STATS =============");
        System.out.println(" Number of graph in the input database: " + this.graphCount);
        System.out.println(" Top-k subgraph count : " + this.patternCount);
        System.out.println(" Minsup: " + (double)this.minSup / (double)this.graphCount + " (i.e. " + this.minSup + " graphs)");
        System.out.println(" Total time ~ " + this.runtime + " s");
        System.out.println(" Maximum memory usage : " + this.maxmemory + " mb");
        System.out.println("===================================================");
    }

    class DFSThread
    extends Thread {
        List<Graph> graphDB;

        public DFSThread(List<Graph> graphDB) {
            this.graphDB = graphDB;
        }

        @Override
        public void start() {
            while (AlgoTKG.this.candidates.size() > 0) {
                FrequentSubgraph candidate = AlgoTKG.this.candidates.poll();
                if (candidate.setOfGraphsIDs.size() < AlgoTKG.this.minSup) break;
                try {
                    AlgoTKG.this.gSpanDynamicDFS(candidate.dfsCode, this.graphDB, candidate.setOfGraphsIDs);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class Pair {
        int x;
        int y;

        Pair(int x, int y) {
            if (x < y) {
                this.x = x;
                this.y = y;
            } else {
                this.x = y;
                this.y = x;
            }
        }

        public boolean equals(Object obj) {
            Pair other = (Pair)obj;
            return other.x == this.x && other.y == this.y;
        }

        public int hashCode() {
            return this.x + 100 * this.y;
        }
    }
}

