/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.DFSCode;
import ca.pfv.spmf.algorithms.graph_mining.tkg.EdgeEnumeration;
import ca.pfv.spmf.algorithms.graph_mining.tkg.FrequentSubgraph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Projected;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClosedSubgraph
extends FrequentSubgraph {
    private Projected projected;
    private Map<Integer, List<List<EdgeEnumeration>>> projectionsInDatabaseGraph;
    private Integer exampleGid;

    public ClosedSubgraph(DFSCode dfsCode, Set<Integer> setOfGraphsIDs, int support, Projected projected) {
        super(dfsCode, setOfGraphsIDs, support);
        this.projected = projected;
        this.projectionsInDatabaseGraph = projected.buildProjectionsInDatabaseGraph();
        this.exampleGid = null;
        Integer numOccurrences = null;
        for (int gid : this.projectionsInDatabaseGraph.keySet()) {
            if (this.exampleGid == null) {
                this.exampleGid = gid;
                numOccurrences = this.projectionsInDatabaseGraph.get(gid).size();
                continue;
            }
            if (this.projectionsInDatabaseGraph.get(gid).size() >= numOccurrences) continue;
            this.exampleGid = gid;
            numOccurrences = this.projectionsInDatabaseGraph.get(gid).size();
        }
    }

    public List<Set<EdgeEnumeration>> getKeys() {
        return this.projected.buildKeys();
    }

    public Map<Integer, Integer> checkEquivalentOccurrence(Set<Integer> otherSetOfGraphsIDs, int otherSupport, Projected otherProjected) {
        if (otherSupport > this.support) {
            return null;
        }
        if (!this.setOfGraphsIDs.equals(otherSetOfGraphsIDs)) {
            return null;
        }
        if (otherProjected.getProjected().size() > this.projected.getProjected().size()) {
            return null;
        }
        Map<Integer, List<List<EdgeEnumeration>>> otherProjectionsInDatabaseGraph = otherProjected.buildProjectionsInDatabaseGraph();
        List<Map<Integer, Integer>> possibleIsomorphisms = this.findPossibleIsomorphisms(otherProjectionsInDatabaseGraph.get(this.exampleGid));
        Map<Integer, Integer> isomorphism = null;
        boolean isomorphismFound = false;
        for (Map<Integer, Integer> possibleIsomorphism : possibleIsomorphisms) {
            for (int gid : otherProjectionsInDatabaseGraph.keySet()) {
                for (List<EdgeEnumeration> otherProjectedEdges : otherProjectionsInDatabaseGraph.get(gid)) {
                    isomorphismFound = true;
                    for (List<EdgeEnumeration> myProjectedEdges : this.projectionsInDatabaseGraph.get(gid)) {
                        isomorphismFound = true;
                        for (int otherIndex : possibleIsomorphism.keySet()) {
                            int myIndex = possibleIsomorphism.get(otherIndex);
                            if (otherProjectedEdges.get(otherIndex) == myProjectedEdges.get(myIndex)) continue;
                            isomorphismFound = false;
                            break;
                        }
                        if (isomorphismFound) break;
                    }
                    if (!isomorphismFound) break;
                }
                if (!isomorphismFound) break;
            }
            if (!isomorphismFound) continue;
            isomorphism = possibleIsomorphism;
            break;
        }
        return isomorphism;
    }

    private List<Map<Integer, Integer>> findPossibleIsomorphisms(List<List<EdgeEnumeration>> edgesProjectionList) {
        LinkedList<Map<Integer, Integer>> isomorphisms = new LinkedList<Map<Integer, Integer>>();
        List<EdgeEnumeration> otherProjectedEdges = edgesProjectionList.get(0);
        for (List<EdgeEnumeration> myProjectedEdges : this.projectionsInDatabaseGraph.get(this.exampleGid)) {
            HashMap<Integer, Integer> isomorphism = new HashMap<Integer, Integer>();
            int i = 0;
            while (i < otherProjectedEdges.size()) {
                EdgeEnumeration otherEdge = otherProjectedEdges.get(i);
                int j = 0;
                while (j < myProjectedEdges.size()) {
                    EdgeEnumeration myEdge = myProjectedEdges.get(j);
                    if (otherEdge == myEdge) {
                        isomorphism.put(i, j);
                        break;
                    }
                    ++j;
                }
                if (isomorphism.size() == otherProjectedEdges.size()) {
                    isomorphisms.add(isomorphism);
                }
                ++i;
            }
        }
        return isomorphisms;
    }

    public Projected getProjected() {
        return this.projected;
    }
}

