/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.DFSCode;
import ca.pfv.spmf.algorithms.graph_mining.tkg.DatabaseGraph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Edge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.ExtendedEdge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.PDFS;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Projected;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EarlyTerminationFailureHandler {
    private List<DatabaseGraph> graphDB;
    private int minSup;
    private Trie trie;

    public EarlyTerminationFailureHandler(List<DatabaseGraph> graphDB, int minSup) {
        this.graphDB = graphDB;
        this.minSup = minSup;
        this.trie = new Trie();
    }

    public void analyze(DFSCode dfsCode, Projected projected, Map<ExtendedEdge, Projected> extensions) {
        Map<ExtendedEdge, Projected> forwardExtensions;
        List<Integer> rightMostPathEdges = this.rightMostPathEdges(dfsCode);
        if (this.analyzeCase1(dfsCode, projected, rightMostPathEdges, forwardExtensions = this.extractForwardExtensions(dfsCode, extensions))) {
            return;
        }
        if (this.analyzeCase2(dfsCode, projected, rightMostPathEdges, forwardExtensions)) {
            return;
        }
        if (this.analyzeCase3(dfsCode, projected, rightMostPathEdges, forwardExtensions)) {
            return;
        }
        if (this.analyzeCase4(dfsCode, projected, rightMostPathEdges)) {
            return;
        }
        if (this.analyzeCase5(dfsCode, projected)) {
            return;
        }
    }

    private boolean analyzeCase1(DFSCode dfsCode, Projected projected, List<Integer> rightMostPathEdges, Map<ExtendedEdge, Projected> forwardExtensions) {
        int length = projected.getProjected().get(0).getLength();
        if (dfsCode.getAt((int)(length - 1)).v2 > dfsCode.getAt((int)(length - 1)).v1) {
            HashMap elbVlbGids = new HashMap();
            for (PDFS pdfs : projected.getProjected()) {
                int edgeIndex = rightMostPathEdges.get(0);
                int fromVertexId = pdfs.getDFSedgeAtToVertex(edgeIndex);
                DatabaseGraph g = this.graphDB.get(pdfs.getEdgeEnumeration().getGid());
                Vertex fromVertex = (Vertex)g.vMap.get(fromVertexId);
                for (Edge edge : fromVertex.getEdgeList()) {
                    int toVertexId;
                    if (pdfs.hasEdge(edge)) continue;
                    int n = toVertexId = edge.v1 == fromVertexId ? edge.v2 : edge.v1;
                    if (pdfs.hasVertex(toVertexId, rightMostPathEdges) || !pdfs.hasVertex(toVertexId)) continue;
                    ElbVlbKey elbVlbKey = new ElbVlbKey(edge.getEdgeLabel(), g.getVLabel(toVertexId));
                    if (!elbVlbGids.containsKey(elbVlbKey)) {
                        elbVlbGids.put(elbVlbKey, new HashSet());
                    }
                    ((Set)elbVlbGids.get(elbVlbKey)).add(g.getId());
                    if (((Set)elbVlbGids.get(elbVlbKey)).size() < this.minSup) continue;
                    this.trie.insert(dfsCode.getEeL());
                    return true;
                }
            }
            for (ElbVlbKey elbVlbKey : elbVlbGids.keySet()) {
                for (ExtendedEdge extendedEdge : forwardExtensions.keySet()) {
                    if (extendedEdge.v1 != dfsCode.getRightMost() || extendedEdge.edgeLabel != elbVlbKey.elb || extendedEdge.vLabel2 != elbVlbKey.vlb) continue;
                    for (PDFS pdfs : forwardExtensions.get(extendedEdge).getProjected()) {
                        ((Set)elbVlbGids.get(elbVlbKey)).add(pdfs.getEdgeEnumeration().getGid());
                    }
                    if (((Set)elbVlbGids.get(elbVlbKey)).size() < this.minSup) continue;
                    this.trie.insert(dfsCode.getEeL());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean analyzeCase2(DFSCode dfsCode, Projected projected, List<Integer> rightMostPathEdges, Map<ExtendedEdge, Projected> forwardExtensions) {
        int length = projected.getProjected().get(0).getLength();
        if (dfsCode.getAt((int)(length - 1)).v2 > dfsCode.getAt((int)(length - 1)).v1) {
            HashMap vertexElbVlbGids = new HashMap();
            int i = 0;
            while (i < rightMostPathEdges.size()) {
                ExtendedEdge extendedEdge = dfsCode.getAt(rightMostPathEdges.get(i));
                int vertexEnd = extendedEdge.v2;
                int vertexStart = extendedEdge.v1;
                if (vertexEnd != vertexStart + 1) {
                    int j = i + 1;
                    while (j < rightMostPathEdges.size()) {
                        int vertexFrom = dfsCode.getAt((int)rightMostPathEdges.get((int)j).intValue()).v1;
                        for (PDFS pdfs : projected.getProjected()) {
                            DatabaseGraph g = this.graphDB.get(pdfs.getEdgeEnumeration().getGid());
                            Map<Integer, Integer> dfs2g = pdfs.subgraphIsomorphism(dfsCode);
                            Map<Integer, Integer> g2dfs = dfs2g.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                            HashSet<Integer> gNotRmpathVertices = new HashSet<Integer>();
                            int v = vertexStart + 1;
                            while (v < vertexEnd) {
                                gNotRmpathVertices.add(dfs2g.get(v));
                                ++v;
                            }
                            for (Edge edge : ((Vertex)g.vMap.get(dfs2g.get(vertexFrom))).getEdgeList()) {
                                int vertexTo;
                                if (pdfs.hasEdge(edge)) continue;
                                int n = vertexTo = edge.v1 == dfs2g.get(vertexFrom) ? edge.v2 : edge.v1;
                                if (!gNotRmpathVertices.contains(vertexTo)) continue;
                                VertexElbVlbKey vertexElbVlbKey = new VertexElbVlbKey(vertexFrom, edge.getEdgeLabel(), ((Vertex)g.vMap.get(vertexTo)).getLabel());
                                if (!vertexElbVlbGids.containsKey(vertexElbVlbKey)) {
                                    vertexElbVlbGids.put(vertexElbVlbKey, new HashSet());
                                }
                                ((Set)vertexElbVlbGids.get(vertexElbVlbKey)).add(g.getId());
                                if (((Set)vertexElbVlbGids.get(vertexElbVlbKey)).size() < this.minSup) continue;
                                this.trie.insert(dfsCode.getEeL());
                                return true;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            for (VertexElbVlbKey vertexElbVlbKey : vertexElbVlbGids.keySet()) {
                for (ExtendedEdge extendedEdge : forwardExtensions.keySet()) {
                    if (extendedEdge.v1 != vertexElbVlbKey.getVertex() || extendedEdge.edgeLabel != vertexElbVlbKey.elb || extendedEdge.vLabel2 != vertexElbVlbKey.vlb) continue;
                    for (PDFS pdfs : forwardExtensions.get(extendedEdge).getProjected()) {
                        ((Set)vertexElbVlbGids.get(vertexElbVlbKey)).add(pdfs.getEdgeEnumeration().getGid());
                    }
                    if (((Set)vertexElbVlbGids.get(vertexElbVlbKey)).size() < this.minSup) continue;
                    this.trie.insert(dfsCode.getEeL());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean analyzeCase3(DFSCode dfsCode, Projected projected, List<Integer> rightMostPathEdges, Map<ExtendedEdge, Projected> forwardExtensions) {
        int length = projected.getProjected().get(0).getLength();
        if (dfsCode.getAt((int)(length - 1)).v2 > dfsCode.getAt((int)(length - 1)).v1 && rightMostPathEdges.size() > 2 && dfsCode.getAt((int)rightMostPathEdges.get((int)(rightMostPathEdges.size() - 1)).intValue()).edgeLabel == dfsCode.getAt((int)rightMostPathEdges.get((int)(rightMostPathEdges.size() - 2)).intValue()).edgeLabel && dfsCode.getAt((int)rightMostPathEdges.get((int)(rightMostPathEdges.size() - 1)).intValue()).vLabel2 == dfsCode.getAt((int)rightMostPathEdges.get((int)(rightMostPathEdges.size() - 2)).intValue()).vLabel2) {
            HashMap elbVlbGids = new HashMap();
            for (PDFS pdfs : projected.getProjected()) {
                DatabaseGraph g = this.graphDB.get(pdfs.getEdgeEnumeration().getGid());
                int firstRmpathEdgeIndex = rightMostPathEdges.get(rightMostPathEdges.size() - 1);
                int gRmpathFirstVertex = pdfs.getDFSedgeAtFromVertex(firstRmpathEdgeIndex);
                int edgeIndex = rightMostPathEdges.get(0);
                int fromVertexId = pdfs.getDFSedgeAtToVertex(edgeIndex);
                Vertex fromVertex = (Vertex)g.vMap.get(fromVertexId);
                for (Edge edge : fromVertex.getEdgeList()) {
                    int vertexTo;
                    if (pdfs.hasEdge(edge)) continue;
                    int n = vertexTo = edge.v1 == fromVertexId ? edge.v2 : edge.v1;
                    if (vertexTo != gRmpathFirstVertex) continue;
                    ElbVlbKey elbVlbKey = new ElbVlbKey(edge.getEdgeLabel(), g.getVLabel(vertexTo));
                    if (!elbVlbGids.containsKey(elbVlbKey)) {
                        elbVlbGids.put(elbVlbKey, new HashSet());
                    }
                    ((Set)elbVlbGids.get(elbVlbKey)).add(g.getId());
                    if (((Set)elbVlbGids.get(elbVlbKey)).size() < this.minSup) continue;
                    this.trie.insert(dfsCode.getEeL());
                    return true;
                }
            }
            for (ElbVlbKey elbVlbKey : elbVlbGids.keySet()) {
                for (ExtendedEdge extendedEdge : forwardExtensions.keySet()) {
                    if (extendedEdge.v1 != dfsCode.getRightMost() || extendedEdge.edgeLabel != elbVlbKey.elb || extendedEdge.vLabel2 != elbVlbKey.vlb) continue;
                    for (PDFS pdfs : forwardExtensions.get(extendedEdge).getProjected()) {
                        ((Set)elbVlbGids.get(elbVlbKey)).add(pdfs.getEdgeEnumeration().getGid());
                    }
                    if (((Set)elbVlbGids.get(elbVlbKey)).size() < this.minSup) continue;
                    this.trie.insert(dfsCode.getEeL());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean analyzeCase4(DFSCode dfsCode, Projected projected, List<Integer> rightMostPathEdges) {
        int length = projected.getProjected().get(0).getLength();
        if (dfsCode.getAt((int)(length - 1)).v2 < dfsCode.getAt((int)(length - 1)).v1) {
            Integer rmpathLoop = null;
            ExtendedEdge lastDfsEdge = dfsCode.getAt(dfsCode.size() - 1);
            int i = 0;
            while (i < rightMostPathEdges.size()) {
                ExtendedEdge rightMostPathEdge = dfsCode.getAt(rightMostPathEdges.get(i));
                if (rightMostPathEdge.v1 == lastDfsEdge.v2) {
                    rmpathLoop = rightMostPathEdges.get(i);
                    break;
                }
                ++i;
            }
            for (int rmpathEdgeIndex : rightMostPathEdges) {
                if (rmpathEdgeIndex < rmpathLoop) break;
                int elb = dfsCode.getAt(rmpathEdgeIndex).getEdgeLabel();
                int vlb = dfsCode.getAt(rmpathEdgeIndex).getvLabel1();
                for (PDFS pdfs : projected.getProjected()) {
                    DatabaseGraph g = this.graphDB.get(pdfs.getEdgeEnumeration().getGid());
                    int vertexId = pdfs.getDFSedgeAtToVertex(rmpathEdgeIndex);
                    Vertex vertex = (Vertex)g.vMap.get(vertexId);
                    for (Edge edge : vertex.getEdgeList()) {
                        int vertexTo;
                        if (edge.getEdgeLabel() != elb) continue;
                        int n = vertexTo = edge.v1 == vertexId ? edge.v2 : edge.v1;
                        if (((Vertex)g.vMap.get(vertexTo)).getLabel() != vlb || pdfs.hasEdge(edge) || pdfs.hasVertex(vertexTo)) continue;
                        this.trie.insert(dfsCode.getEeL());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean analyzeCase5(DFSCode dfsCode, Projected projected) {
        List<DFSCode> dfsCodes = this.buildDFSCodesPrefixes(dfsCode);
        int i = 1;
        while (i < dfsCodes.size()) {
            block9: {
                Integer rmpathLoop;
                List<Integer> testedRightMostPathEdges;
                DFSCode testedDfsCode;
                block10: {
                    testedDfsCode = dfsCodes.get(i);
                    if (testedDfsCode.getAt((int)(testedDfsCode.size() - 1)).v2 >= testedDfsCode.getAt((int)(testedDfsCode.size() - 1)).v1) break block9;
                    testedRightMostPathEdges = this.rightMostPathEdges(testedDfsCode);
                    rmpathLoop = null;
                    Integer rmpathLoopIndex = null;
                    int j = 0;
                    while (j < testedRightMostPathEdges.size()) {
                        if (testedDfsCode.getAt((int)testedRightMostPathEdges.get((int)j).intValue()).v1 == testedDfsCode.getAt((int)(testedDfsCode.size() - 1)).v2) {
                            rmpathLoop = testedRightMostPathEdges.get(j);
                            rmpathLoopIndex = j;
                            break;
                        }
                        ++j;
                    }
                    Integer rmpathBeforeLoopIndex = rmpathLoopIndex + 1;
                    if (rmpathBeforeLoopIndex >= testedRightMostPathEdges.size()) break block10;
                    int rmpathBeforeLoopIndexVlb = testedDfsCode.getAt((int)testedRightMostPathEdges.get((int)rmpathBeforeLoopIndex.intValue()).intValue()).vLabel1;
                    int rmpath0Vlb = testedDfsCode.getAt((int)testedRightMostPathEdges.get((int)(testedRightMostPathEdges.size() - 1)).intValue()).vLabel1;
                    if (rmpath0Vlb != testedDfsCode.getAt((int)testedRightMostPathEdges.get((int)rmpathBeforeLoopIndex.intValue()).intValue()).vLabel2 || testedDfsCode.getAt((int)testedRightMostPathEdges.get((int)(testedRightMostPathEdges.size() - 1)).intValue()).edgeLabel != testedDfsCode.getAt((int)testedRightMostPathEdges.get((int)rmpathBeforeLoopIndex.intValue()).intValue()).edgeLabel || testedDfsCode.getAt((int)testedRightMostPathEdges.get((int)(testedRightMostPathEdges.size() - 1)).intValue()).vLabel2 != rmpathBeforeLoopIndexVlb) break block9;
                }
                List<PDFS> dfsCodeProjected = this.prefixProjections(projected, dfsCode.size() - testedDfsCode.size());
                for (int rmpathEdgeIndex : testedRightMostPathEdges) {
                    if (rmpathEdgeIndex < rmpathLoop) break;
                    int elb = testedDfsCode.getAt(rmpathEdgeIndex).getEdgeLabel();
                    int vlb = testedDfsCode.getAt((int)rmpathEdgeIndex).vLabel1;
                    for (PDFS pdfs : dfsCodeProjected) {
                        DatabaseGraph g = this.graphDB.get(pdfs.getEdgeEnumeration().getGid());
                        int vertexId = pdfs.getDFSedgeAtToVertex(rmpathEdgeIndex);
                        Vertex vertex = (Vertex)g.vMap.get(vertexId);
                        for (Edge edge : vertex.getEdgeList()) {
                            int vertexTo;
                            if (edge.getEdgeLabel() != elb) continue;
                            int n = vertexTo = edge.v1 == vertexId ? edge.v2 : edge.v1;
                            if (((Vertex)g.vMap.get(vertexTo)).getLabel() != vlb || pdfs.hasEdge(edge) || pdfs.hasVertex(vertexTo)) continue;
                            this.trie.insert(dfsCode.getEeL());
                            return true;
                        }
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private Map<ExtendedEdge, Projected> extractForwardExtensions(DFSCode dfsCode, Map<ExtendedEdge, Projected> extensions) {
        HashMap<ExtendedEdge, Projected> forwardExtensions = new HashMap<ExtendedEdge, Projected>();
        int minVlb = dfsCode.getEeL().get((int)0).vLabel1;
        int maxVertex = -1;
        for (ExtendedEdge extendedEdge : dfsCode.getEeL()) {
            if (extendedEdge.v1 > maxVertex) {
                maxVertex = extendedEdge.v1;
            }
            if (extendedEdge.v2 <= maxVertex) continue;
            maxVertex = extendedEdge.v2;
        }
        for (ExtendedEdge extendedEdge : extensions.keySet()) {
            if (extendedEdge.v1 > extendedEdge.v2) continue;
            if (extendedEdge.v1 == maxVertex && extendedEdge.v2 > maxVertex) {
                if (extendedEdge.vLabel2 < minVlb) continue;
                forwardExtensions.put(extendedEdge, extensions.get(extendedEdge));
                continue;
            }
            boolean add = true;
            for (ExtendedEdge dfsEdge : dfsCode.getEeL()) {
                if (dfsEdge.v1 > dfsEdge.v2 || dfsEdge.v1 != extendedEdge.v1) continue;
                if (extendedEdge.vLabel2 < minVlb) {
                    add = false;
                    break;
                }
                if (extendedEdge.edgeLabel < dfsEdge.edgeLabel) {
                    add = false;
                    break;
                }
                if (extendedEdge.edgeLabel != dfsEdge.edgeLabel || extendedEdge.vLabel2 >= dfsEdge.vLabel2) continue;
                add = false;
                break;
            }
            if (!add) continue;
            forwardExtensions.put(extendedEdge, extensions.get(extendedEdge));
        }
        return forwardExtensions;
    }

    private List<PDFS> prefixProjections(Projected projected, int index) {
        LinkedList<PDFS> pdfsTails = new LinkedList<PDFS>();
        for (PDFS pdfs : projected.getProjected()) {
            int i = 0;
            while (i < index) {
                pdfs = pdfs.getPrevious();
                ++i;
            }
            boolean alreadyExist = false;
            for (PDFS pdfsTail : pdfsTails) {
                PDFS pdfsi = pdfs;
                PDFS pdfsj = pdfsTail;
                if (!pdfsi.getEdgeEnumeration().equals(pdfsj.getEdgeEnumeration())) break;
                pdfsi = pdfsi.getPrevious();
                pdfsj = pdfsj.getPrevious();
                if (pdfsi != null) continue;
                alreadyExist = true;
                break;
            }
            if (alreadyExist) continue;
            pdfsTails.add(pdfs);
        }
        return pdfsTails;
    }

    private List<Integer> rightMostPathEdges(DFSCode dfsCode) {
        ArrayList<Integer> rightMostPathEdges = new ArrayList<Integer>();
        List<ExtendedEdge> eel = dfsCode.getEeL();
        dfsCode.getRightMostPath();
        Iterable<Integer> rightMostPathVertices = dfsCode.getRightMostPath();
        Iterator<Integer> rightMostPathVerticesIterator = rightMostPathVertices.iterator();
        int from = rightMostPathVerticesIterator.next();
        int to = rightMostPathVerticesIterator.next();
        int i = 0;
        for (ExtendedEdge extendedEdge : eel) {
            if (extendedEdge.v1 == from && extendedEdge.v2 == to) {
                rightMostPathEdges.add(i);
                from = to;
                to = rightMostPathVerticesIterator.hasNext() ? rightMostPathVerticesIterator.next() : -1;
            }
            ++i;
        }
        Collections.reverse(rightMostPathEdges);
        return rightMostPathEdges;
    }

    private List<DFSCode> buildDFSCodesPrefixes(DFSCode dfsCode) {
        LinkedList<DFSCode> dfsCodes = new LinkedList<DFSCode>();
        dfsCodes.add(dfsCode);
        List<ExtendedEdge> extendedEdges = dfsCode.getEeL();
        Integer oldFrom = null;
        int i = extendedEdges.size() - 1;
        while (i >= 0) {
            ExtendedEdge extendedEdge = extendedEdges.get(i);
            int from = extendedEdge.v1;
            int to = extendedEdge.v2;
            if (from < to && (oldFrom == null || to == oldFrom)) {
                oldFrom = from;
            } else if (from <= to || oldFrom != null && from != oldFrom) {
                oldFrom = from;
                DFSCode dfsCodeNew = new DFSCode();
                int j = 0;
                while (j <= i) {
                    dfsCodeNew.add(extendedEdges.get(j));
                    ++j;
                }
                dfsCodes.add(dfsCodeNew);
            }
            --i;
        }
        return dfsCodes;
    }

    public boolean detect(List<ExtendedEdge> extendedEdges) {
        boolean detected = this.trie.search(extendedEdges);
        return detected;
    }

    private class ElbVlbKey {
        private int elb;
        private int vlb;

        public ElbVlbKey(int elb, int vlb) {
            this.elb = elb;
            this.vlb = vlb;
        }

        public int getElb() {
            return this.elb;
        }

        public void setElb(int elb) {
            this.elb = elb;
        }

        public int getVlb() {
            return this.vlb;
        }

        public void setVlb(int vlb) {
            this.vlb = vlb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElbVlbKey elbVlbKey = (ElbVlbKey)o;
            return this.elb == elbVlbKey.elb && this.vlb == elbVlbKey.vlb;
        }

        public int hashCode() {
            return Objects.hash(this.elb, this.vlb);
        }
    }

    class Trie {
        private TrieNode root;

        public Trie() {
            this.root = new TrieNode();
        }

        public void insert(List<ExtendedEdge> extendedEdges) {
            TrieNode node = this.root;
            for (ExtendedEdge extendedEdge : extendedEdges) {
                if (node.children.containsKey(extendedEdge)) {
                    node = (TrieNode)node.children.get(extendedEdge);
                    continue;
                }
                TrieNode child = new TrieNode();
                node.children.put(extendedEdge, child);
                node = child;
            }
        }

        public boolean search(List<ExtendedEdge> extendedEdges) {
            TrieNode node = this.root;
            for (ExtendedEdge extendedEdge : extendedEdges) {
                if (node.children.containsKey(extendedEdge)) {
                    node = (TrieNode)node.children.get(extendedEdge);
                    continue;
                }
                return false;
            }
            return true;
        }
    }

    private class TrieNode {
        private Map<ExtendedEdge, TrieNode> children = new HashMap<ExtendedEdge, TrieNode>();
    }

    private class VertexElbVlbKey {
        private int vertex;
        private int elb;
        private int vlb;

        public VertexElbVlbKey(int vertex, int elb, int vlb) {
            this.vertex = vertex;
            this.elb = elb;
            this.vlb = vlb;
        }

        public int getElb() {
            return this.elb;
        }

        public void setElb(int elb) {
            this.elb = elb;
        }

        public int getVlb() {
            return this.vlb;
        }

        public void setVlb(int vlb) {
            this.vlb = vlb;
        }

        public int getVertex() {
            return this.vertex;
        }

        public void setVertex(int vertex) {
            this.vertex = vertex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VertexElbVlbKey that = (VertexElbVlbKey)o;
            return this.vertex == that.vertex && this.elb == that.elb && this.vlb == that.vlb;
        }

        public int hashCode() {
            return Objects.hash(this.vertex, this.elb, this.vlb);
        }
    }
}

