/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.DFSCode;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Edge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.ExtendedEdge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Graph {
    private int id;
    public Map<Integer, Vertex> vMap;
    private Map<Integer, Vertex[]> neighborCache;
    Vertex[] vertices;
    Map<Integer, int[]> mapLabelToVertexIDs;
    private int edgeCount = 0;
    private static final Vertex[] EMPTY_VERTEX_LIST = new Vertex[0];
    private static final int[] EMPTY_INTEGER_ARRAY = new int[0];

    public void removeInfrequentLabel(int label) {
        Iterator<Map.Entry<Integer, Vertex>> iter = this.vMap.entrySet().iterator();
        while (iter.hasNext()) {
            Vertex vertex = iter.next().getValue();
            if (vertex.getLabel() != label) continue;
            iter.remove();
        }
        for (Vertex vertex : this.vMap.values()) {
            Iterator<Edge> it = vertex.getEdgeList().iterator();
            while (it.hasNext()) {
                Edge edge = it.next();
                if (this.vMap.get(edge.v1) != null && this.vMap.get(edge.v2) != null) continue;
                it.remove();
            }
        }
    }

    public Graph(int id, Map<Integer, Vertex> vMap) {
        this.id = id;
        this.vMap = vMap;
    }

    public Graph(DFSCode c) {
        this.vMap = new HashMap<Integer, Vertex>();
        for (ExtendedEdge ee : c.getEeL()) {
            int v1 = ee.getV1();
            int v2 = ee.getV2();
            int v1L = ee.getvLabel1();
            int v2L = ee.getvLabel2();
            int eL = ee.getEdgeLabel();
            Edge e = new Edge(v1, v2, eL);
            if (this.vMap.get(v1) == null) {
                this.vMap.put(v1, new Vertex(v1, v1L));
            }
            if (this.vMap.get(v2) == null) {
                this.vMap.put(v2, new Vertex(v2, v2L));
            }
            this.vMap.get(v1).addEdge(e);
            this.vMap.get(v2).addEdge(e);
        }
        this.id = -1;
        this.precalculateVertexList();
        this.precalculateVertexNeighbors();
        this.precalculateLabelsToVertices();
    }

    public void precalculateVertexNeighbors() {
        this.neighborCache = new HashMap<Integer, Vertex[]>();
        ArrayList<Vertex> neighbors = new ArrayList<Vertex>();
        for (Map.Entry<Integer, Vertex> entry : this.vMap.entrySet()) {
            int vertexID = entry.getKey();
            Vertex vertex = entry.getValue();
            List<Edge> vertexEdgeList = vertex.getEdgeList();
            for (Edge e : vertexEdgeList) {
                Vertex vertexNeighboor = this.vMap.get(e.another(vertexID));
                neighbors.add(vertexNeighboor);
            }
            Object[] arrayNeighbors = new Vertex[neighbors.size()];
            int i = 0;
            while (i < neighbors.size()) {
                arrayNeighbors[i] = (Vertex)neighbors.get(i);
                ++i;
            }
            Arrays.sort(arrayNeighbors);
            this.neighborCache.put(vertexID, (Vertex[])arrayNeighbors);
            this.edgeCount += neighbors.size();
            neighbors.clear();
        }
        this.edgeCount /= 2;
    }

    public void precalculateVertexList() {
        this.vertices = new Vertex[this.vMap.size()];
        int j = 0;
        for (Map.Entry<Integer, Vertex> entry : this.vMap.entrySet()) {
            Vertex vertex;
            this.vertices[j] = vertex = entry.getValue();
            ++j;
        }
    }

    public void precalculateLabelsToVertices() {
        this.mapLabelToVertexIDs = new HashMap<Integer, int[]>();
        ArrayList<Integer> sameIDs = new ArrayList<Integer>();
        int i = 0;
        while (i < this.vertices.length) {
            int label = this.vertices[i].getLabel();
            if (!this.mapLabelToVertexIDs.containsKey(label)) {
                int j = i + 1;
                while (j < this.vertices.length) {
                    if (this.vertices[j].getLabel() == label) {
                        sameIDs.add(this.vertices[j].getId());
                    }
                    ++j;
                }
                int[] verticeIDs = new int[sameIDs.size() + 1];
                verticeIDs[0] = this.vertices[i].getId();
                int k = 0;
                while (k < sameIDs.size()) {
                    verticeIDs[k + 1] = (Integer)sameIDs.get(k);
                    ++k;
                }
                this.mapLabelToVertexIDs.put(label, verticeIDs);
                sameIDs.clear();
            }
            ++i;
        }
    }

    public int[] findAllWithLabel(int targetLabel) {
        int[] vertexIds = this.mapLabelToVertexIDs.get(targetLabel);
        if (vertexIds == null) {
            return EMPTY_INTEGER_ARRAY;
        }
        return vertexIds;
    }

    public Vertex[] getAllVertices() {
        return this.vertices;
    }

    public List<Vertex> getNonPrecalculatedAllVertices() {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.vMap.size());
        for (Map.Entry<Integer, Vertex> entry : this.vMap.entrySet()) {
            Vertex vertex = entry.getValue();
            vertices.add(vertex);
        }
        return vertices;
    }

    public Set<Edge> getAllEdges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        Vertex[] vertexArray = this.getAllVertices();
        int n = vertexArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vertex v = vertexArray[n2];
            edges.addAll(v.getEdgeList());
            ++n2;
        }
        return edges;
    }

    public int getVLabel(int v) {
        return this.vMap.get(v).getLabel();
    }

    public int getEdgeLabel(int v1, int v2) {
        for (Edge e : this.vMap.get(v1).getEdgeList()) {
            if (e.v1 == v1 && e.v2 == v2) {
                return e.getEdgeLabel();
            }
            if (e.v2 != v1 || e.v1 != v2) continue;
            return e.getEdgeLabel();
        }
        return -1;
    }

    public Edge getEdge(int v1, int v2) {
        for (Edge e : this.vMap.get(v1).getEdgeList()) {
            if (e.v1 == v1 && e.v2 == v2) {
                return e;
            }
            if (e.v2 != v1 || e.v1 != v2) continue;
            return e;
        }
        return null;
    }

    public Vertex[] getAllNeighbors(int v) {
        Vertex[] neighboors = this.neighborCache.get(v);
        if (neighboors == null) {
            return EMPTY_VERTEX_LIST;
        }
        return neighboors;
    }

    public boolean isNeighboring(int v1, int v2) {
        Vertex[] neighborsOfV1 = this.neighborCache.get(v1);
        int low = 0;
        int high = neighborsOfV1.length - 1;
        while (high >= low) {
            int middle = (low + high) / 2;
            int val = neighborsOfV1[middle].getId();
            if (val == v2) {
                return true;
            }
            if (val < v2) {
                low = middle + 1;
            }
            if (val <= v2) continue;
            high = middle - 1;
        }
        return false;
    }

    public int getVertexCount() {
        return this.vertices.length;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public int getId() {
        return this.id;
    }
}

