/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.DFSCode;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Edge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.EdgeEnumeration;
import ca.pfv.spmf.algorithms.graph_mining.tkg.ExtendedEdge;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFS {
    private EdgeEnumeration edgeEnumeration;
    private boolean isReversed;
    private PDFS previous;
    private int length;
    private Map<Edge, Boolean> edgesCache = new HashMap<Edge, Boolean>();

    public PDFS(EdgeEnumeration edgeEnumeration, boolean isReversed, PDFS previous) {
        this.edgeEnumeration = edgeEnumeration;
        this.isReversed = isReversed;
        this.previous = previous;
        this.length = previous == null ? 1 : previous.getLength() + 1;
    }

    public EdgeEnumeration getEdgeEnumeration() {
        return this.edgeEnumeration;
    }

    public void setEdgeEnumeration(EdgeEnumeration edgeEnumeration) {
        this.edgeEnumeration = edgeEnumeration;
    }

    public PDFS getPrevious() {
        return this.previous;
    }

    public void setPrevious(PDFS previous) {
        this.previous = previous;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public void setReversed(boolean reversed) {
        this.isReversed = reversed;
    }

    public Map<Integer, Integer> subgraphIsomorphism(DFSCode c) {
        HashMap<Integer, Integer> isomorphism = new HashMap<Integer, Integer>();
        List<ExtendedEdge> dfsEdges = c.getEeL();
        PDFS current = this;
        int i = dfsEdges.size() - 1;
        while (i >= 0) {
            ExtendedEdge dfsEdge = dfsEdges.get(i);
            Edge projectedEdge = current.getEdgeEnumeration().getEdge();
            if (current.isReversed()) {
                isomorphism.put(dfsEdge.v1, projectedEdge.v2);
                isomorphism.put(dfsEdge.v2, projectedEdge.v1);
            } else {
                isomorphism.put(dfsEdge.v1, projectedEdge.v1);
                isomorphism.put(dfsEdge.v2, projectedEdge.v2);
            }
            current = current.getPrevious();
            --i;
        }
        return isomorphism;
    }

    public int getDFSedgeAtToVertex(int index) {
        int pdfsIndex = this.length - 1 - index;
        PDFS pdfsAt = this;
        int i = 0;
        while (i < pdfsIndex) {
            pdfsAt = pdfsAt.getPrevious();
            ++i;
        }
        return pdfsAt.isReversed() ? pdfsAt.getEdgeEnumeration().getEdge().v1 : pdfsAt.getEdgeEnumeration().getEdge().v2;
    }

    public int getDFSedgeAtFromVertex(int index) {
        int pdfsIndex = this.length - 1 - index;
        PDFS pdfsAt = this;
        int i = 0;
        while (i < pdfsIndex) {
            pdfsAt = pdfsAt.getPrevious();
            ++i;
        }
        return pdfsAt.isReversed() ? pdfsAt.getEdgeEnumeration().getEdge().v2 : pdfsAt.getEdgeEnumeration().getEdge().v1;
    }

    public boolean hasEdge(Edge edge) {
        PDFS pdfsAt = this;
        while (pdfsAt != null) {
            if (pdfsAt.edgesCache.containsKey(edge)) {
                this.edgesCache.put(edge, pdfsAt.edgesCache.get(edge));
                return pdfsAt.edgesCache.get(edge);
            }
            if (pdfsAt.getEdgeEnumeration().getEdge().equals(edge)) {
                this.edgesCache.put(edge, true);
                return true;
            }
            pdfsAt = pdfsAt.getPrevious();
        }
        this.edgesCache.put(edge, false);
        return false;
    }

    public boolean hasVertex(int vertexId, List<Integer> edgesIndexes) {
        PDFS pdfsAt = this;
        int index = this.length - 1;
        int edgesIndexesIndex = 0;
        while (pdfsAt != null) {
            if (index != edgesIndexes.get(edgesIndexesIndex)) {
                --index;
                pdfsAt = pdfsAt.getPrevious();
                continue;
            }
            if (pdfsAt.getEdgeEnumeration().getEdge().v1 == vertexId || pdfsAt.getEdgeEnumeration().getEdge().v2 == vertexId) {
                return true;
            }
            --index;
            if (++edgesIndexesIndex == edgesIndexes.size()) {
                return false;
            }
            pdfsAt = pdfsAt.getPrevious();
        }
        return false;
    }

    public boolean hasVertex(int vertexId) {
        PDFS pdfsAt = this;
        while (pdfsAt != null) {
            if (pdfsAt.getEdgeEnumeration().getEdge().v1 == vertexId || pdfsAt.getEdgeEnumeration().getEdge().v2 == vertexId) {
                return true;
            }
            pdfsAt = pdfsAt.getPrevious();
        }
        return false;
    }
}

