/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tseqminer;

import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ItemAttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.Itemset;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ParametersSetting;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.Preprocess;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.STPSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EclatAlgo {
    private static boolean writeToFile = false;
    static double minSup = ParametersSetting.MINSUP;
    static int minSupRelative = Integer.MAX_VALUE;
    private static BufferedWriter bw;
    private static int count;
    public static STPSet wholeSpace;
    private static String FRE_ITEMSET_PATH;

    static {
        count = 0;
        FRE_ITEMSET_PATH = ParametersSetting.FRE_ITEMSET_PATH;
    }

    private static Map<Integer, STPSet> findAllFrequentItems() throws IOException {
        HashMap<Integer, STPSet> supSTPMapping = new HashMap<Integer, STPSet>();
        wholeSpace = new STPSet();
        Map<Integer, ItemAttributedGraph> itemDyAG = Preprocess.convertToItDyAGCase();
        minSupRelative = (int)((double)(itemDyAG.size() * itemDyAG.get(0).getTotalSize()) * minSup);
        for (int timestamp : itemDyAG.keySet()) {
            ItemAttributedGraph itAG = itemDyAG.get(timestamp);
            for (int vId : itAG.getAllVId()) {
                wholeSpace.addSTP(timestamp, vId);
                for (int eventType : itAG.getAllItems4V(vId)) {
                    STPSet stpSet = (STPSet)supSTPMapping.get(eventType);
                    if (stpSet == null) {
                        stpSet = new STPSet();
                        supSTPMapping.put(eventType, stpSet);
                    }
                    stpSet.addSTP(timestamp, vId);
                }
            }
        }
        Iterator iter = supSTPMapping.keySet().iterator();
        while (iter.hasNext()) {
            int it = (Integer)iter.next();
            int sup = ((STPSet)supSTPMapping.get(it)).getSize();
            if (sup >= minSupRelative) continue;
            iter.remove();
        }
        System.out.println("find total " + supSTPMapping.size() + " frequent items");
        return supSTPMapping;
    }

    public static Map<Itemset, STPSet> extendFreItems() throws IOException {
        final Map<Integer, STPSet> supSTPMapping = EclatAlgo.findAllFrequentItems();
        LinkedHashMap<Itemset, STPSet> itemsetSTPSetMap = new LinkedHashMap<Itemset, STPSet>();
        if (writeToFile) {
            bw = new BufferedWriter(new FileWriter(FRE_ITEMSET_PATH));
        }
        ArrayList<Integer> frequentEvents = new ArrayList<Integer>(supSTPMapping.size());
        ArrayList<STPSet> supPoints = new ArrayList<STPSet>(supSTPMapping.size());
        ArrayList<Map.Entry<Integer, STPSet>> list = new ArrayList<Map.Entry<Integer, STPSet>>(supSTPMapping.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, STPSet>>(){

            @Override
            public int compare(Map.Entry<Integer, STPSet> o1, Map.Entry<Integer, STPSet> o2) {
                return ((STPSet)supSTPMapping.get(o1.getKey())).getSize() - ((STPSet)supSTPMapping.get(o2.getKey())).getSize();
            }
        });
        for (Map.Entry entry : list) {
            frequentEvents.add((Integer)entry.getKey());
            supPoints.add((STPSet)entry.getValue());
        }
        EclatAlgo.processProjectedPart(new LinkedList<Integer>(), frequentEvents, supPoints, itemsetSTPSetMap);
        if (bw != null) {
            bw.close();
        }
        return itemsetSTPSetMap;
    }

    private static void processProjectedPart(List<Integer> prefix, List<Integer> projectedFreItems, List<STPSet> projectedSupPoints, Map<Itemset, STPSet> itemsetSTPSetMap) throws IOException {
        int i = 0;
        while (i < projectedFreItems.size()) {
            LinkedList<Integer> newPrefix = new LinkedList<Integer>();
            newPrefix.addAll(prefix);
            Integer itemI = projectedFreItems.get(i);
            STPSet stpSetI = projectedSupPoints.get(i);
            if (writeToFile) {
                EclatAlgo.savePattern(newPrefix, itemI, stpSetI);
            } else {
                itemsetSTPSetMap.put(new Itemset(newPrefix, itemI), stpSetI);
            }
            LinkedList<Integer> itemsBasedOnI = new LinkedList<Integer>();
            LinkedList<STPSet> supPointsBasedOnI = new LinkedList<STPSet>();
            int j = i + 1;
            while (j < projectedFreItems.size()) {
                Integer itemJ = projectedFreItems.get(j);
                STPSet stpSetJ = projectedSupPoints.get(j);
                STPSet stpSetIJ = stpSetI.intersect(stpSetJ);
                if (stpSetIJ.getSize() > minSupRelative) {
                    itemsBasedOnI.add(itemJ);
                    supPointsBasedOnI.add(stpSetIJ);
                }
                ++j;
            }
            if (itemsBasedOnI.size() > 0) {
                newPrefix.add(itemI);
                EclatAlgo.processProjectedPart(newPrefix, itemsBasedOnI, supPointsBasedOnI, itemsetSTPSetMap);
            }
            ++i;
        }
    }

    private static void savePattern(List<Integer> prefix, Integer newItem, STPSet stpSet) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(++count).append("\n");
        sb.append("(");
        for (int item : prefix) {
            sb.append(item).append(",");
        }
        sb.append(newItem);
        sb.append(")\n");
        sb.append(stpSet);
        sb.append("\n");
        bw.write(sb.toString());
    }

    public static void main(String[] args) throws IOException {
        EclatAlgo.extendFreItems();
    }
}

