/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tseqminer;

import ca.pfv.spmf.algorithms.graph_mining.tseqminer.AttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ParametersSetting;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ReadGraph {
    private static boolean ALLASDOUBLE = true;
    private static int TOTAL_NUM_ATTR = ParametersSetting.TOTAL_NUM_ATTR;
    private static String ATTR_FILE_PATH = ParametersSetting.ATTR_FILE_PATH;
    private static String EDGE_FILE_PATH = ParametersSetting.EDGE_FILE_PATH;

    public static void main(String[] args) throws IOException {
        ReadGraph.readGraph();
        ReadGraph.statGraph();
    }

    public static void statGraph() throws IOException {
        Map<Integer, AttributedGraph> dyAG = ReadGraph.readGraph();
        int numTimestamps = dyAG.size();
        int numVertices = dyAG.get(0).getVerNum();
        int totalCount4E = 0;
        for (int i : dyAG.keySet()) {
            AttributedGraph aG = dyAG.get(i);
            for (Map.Entry<Integer, Set<Integer>> edgeLinkEntry : aG.getEdgesMap().entrySet()) {
                totalCount4E += edgeLinkEntry.getValue().size();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("total timestamps: ").append(numTimestamps);
        sb.append("\ntotal vertices: ").append(numVertices);
        sb.append("\naverage edges for each vertex each timestamp: ").append(1.0 * (double)totalCount4E / (double)(numTimestamps * numVertices));
    }

    public static Map<Integer, AttributedGraph> readGraph() throws IOException {
        HashMap<Integer, AttributedGraph> DyAG = new HashMap<Integer, AttributedGraph>();
        BufferedReader brAttr = new BufferedReader(new FileReader(ATTR_FILE_PATH));
        String line1 = brAttr.readLine();
        int count = 0;
        while (line1 != null) {
            if (line1.startsWith("T")) {
                AttributedGraph aG = new AttributedGraph(count);
                while ((line1 = brAttr.readLine()) != null && !line1.startsWith("T")) {
                    ReadGraph.attrLineProcess(aG, line1);
                }
                DyAG.put(count, aG);
            }
            ++count;
        }
        BufferedReader brEdges = new BufferedReader(new FileReader(EDGE_FILE_PATH));
        String line2 = brEdges.readLine();
        while (line2 != null) {
            if (!(line2.startsWith("T") | line2.startsWith("-1"))) continue;
            int aGId = Integer.parseInt(line2.split("T")[1]);
            AttributedGraph aG = (AttributedGraph)DyAG.get(aGId);
            while ((line2 = brEdges.readLine()) != null && !line2.startsWith("T")) {
                ReadGraph.edgeLineProcess(aG, line2);
            }
        }
        int numTimestamps = DyAG.size();
        int numVertices = ((AttributedGraph)DyAG.get(0)).getVerNum();
        int totalCount4E = 0;
        Iterator iterator = DyAG.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            AttributedGraph aG = (AttributedGraph)DyAG.get(i);
            for (Map.Entry<Integer, Set<Integer>> edgeLinkEntry : aG.getEdgesMap().entrySet()) {
                totalCount4E += edgeLinkEntry.getValue().size();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("total timestamps: ").append(numTimestamps);
        sb.append("\ntotal vertices: ").append(numVertices);
        sb.append("\naverage edges for each vertex each timestamp: ").append(1.0 * (double)totalCount4E / (double)(numTimestamps * numVertices));
        return DyAG;
    }

    private static void edgeLineProcess(AttributedGraph aG, String line) {
        String[] items = line.split(" ");
        Integer vId = Integer.parseInt(items[0]);
        LinkedList<Integer> neighbors = new LinkedList<Integer>();
        int i = 1;
        while (i < items.length) {
            neighbors.add(Integer.parseInt(items[i]));
            ++i;
        }
        aG.addEdges(vId, neighbors);
    }

    private static void attrLineProcess(AttributedGraph aG, String line) {
        String[] items = line.split(" ");
        Integer vId = Integer.parseInt(items[0]);
        aG.addVertex(vId);
        if (ALLASDOUBLE) {
            LinkedList<Integer> attrTypes = new LinkedList<Integer>();
            LinkedList<Double> attrVals = new LinkedList<Double>();
            int max_attr_num = items.length;
            if (TOTAL_NUM_ATTR != -1) {
                max_attr_num = TOTAL_NUM_ATTR;
            }
            int i = 1;
            while (i < max_attr_num) {
                Double val = Double.parseDouble(items[i]);
                attrTypes.add(i);
                attrVals.add(val);
                ++i;
            }
            aG.addAttrValForV(vId, attrTypes, attrVals);
        }
    }
}

