/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers.Result;
import java.util.ArrayList;
import java.util.List;

public class Algo {
    public String name;
    private boolean useSteps;
    public List<Result> steps;
    public int currentStep;
    public Result result;

    public Algo(String name, boolean useSteps) {
        this.useSteps = useSteps;
        this.name = name;
        if (useSteps) {
            this.steps = new ArrayList<Result>();
            this.currentStep = -1;
        } else {
            this.result = new Result();
        }
    }

    public boolean useSteps() {
        return this.useSteps;
    }

    public void addStep() {
        if (this.useSteps()) {
            ++this.currentStep;
            if (this.steps.size() - 1 < this.currentStep) {
                this.steps.add(new Result());
            }
        }
    }

    public void set(String stat, Double value) {
        if (this.useSteps()) {
            this.steps.get(this.currentStep).set(stat, value);
        } else {
            this.result.set(stat, value);
        }
    }

    public double get(String stat) {
        if (this.useSteps()) {
            return this.steps.get(this.currentStep).get(stat);
        }
        return this.result.get(stat);
    }

    public double get(int step, String stat) {
        if (this.useSteps()) {
            return this.steps.get(step).get(stat);
        }
        return this.result.get(stat);
    }
}

