/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.Bitvector;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.CPTPlusPredictor;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.Encoder;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.PredictionTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CPTHelper
implements Serializable {
    public CPTPlusPredictor predictor;
    private Encoder encoder;

    public CPTHelper(CPTPlusPredictor predictor) {
        this.predictor = predictor;
    }

    public void setEncoded(Encoder encoder) {
        this.encoder = encoder;
    }

    public Item[] getSequenceFromId(Integer id) {
        if (this.encoder == null) {
            System.err.println("Encoded needs to be set in CPTHelperEncoded");
        }
        ArrayList<Item> items = new ArrayList<Item>();
        PredictionTree curNode = this.predictor.LT.get(id);
        items.add(curNode.Item);
        while (curNode.Parent != null && curNode.Parent != this.predictor.Root) {
            curNode = curNode.Parent;
            items.add(curNode.Item);
        }
        Collections.reverse(items);
        Sequence sequence = this.encoder.decode(new Sequence(id, items));
        return sequence.getItems().toArray(new Item[0]);
    }

    public List<Item> getCommonPrefix(List<Item> A, List<Item> B) {
        if (A.size() < 1 || B.size() < 1) {
            return null;
        }
        ArrayList<Item> prefix = new ArrayList<Item>();
        int i = 0;
        while (i < A.size() && i < B.size()) {
            if (!A.get(i).equals(B.get(i))) {
                return prefix;
            }
            prefix.add(A.get(i));
            ++i;
        }
        return prefix;
    }

    public Sequence keepLastItems(Sequence sequence, int length) {
        if (sequence.size() <= length) {
            return sequence;
        }
        Sequence result = new Sequence(sequence.getId(), sequence.getItems().subList(sequence.size() - length, sequence.size()));
        return result;
    }

    public Sequence removeUnseenItems(Sequence seq) {
        Sequence target = new Sequence(seq);
        int treshold = 0;
        ArrayList<Item> selectedItems = new ArrayList<Item>();
        for (Item item : target.getItems()) {
            if (this.predictor.II.get(item.val) == null || this.predictor.II.get(item.val).cardinality() < treshold) continue;
            selectedItems.add(item);
        }
        target.getItems().clear();
        target.getItems().addAll(selectedItems);
        return target;
    }

    public Bitvector getSimilarSequencesIds(Item[] sequence) {
        if (sequence.length == 0) {
            return new Bitvector();
        }
        Bitvector intersection = null;
        int i = 0;
        while (i < sequence.length) {
            if (intersection == null) {
                intersection = (Bitvector)this.predictor.II.get(sequence[i].val).clone();
            } else {
                Bitvector other = this.predictor.II.get(sequence[i].val);
                if (other != null) {
                    intersection.and(this.predictor.II.get(sequence[i].val));
                }
            }
            ++i;
        }
        return intersection;
    }
}

