/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.DG;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.DG.DGArc;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.DG.DGNode;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Paramable;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DGPredictor
extends Predictor {
    private HashMap<Integer, DGNode> mDictionary;
    public Paramable parameters;
    private final int lookahead = 4;

    public DGPredictor() {
        this.TAG = "DG";
        this.parameters = new Paramable();
    }

    public DGPredictor(String tag) {
        this.TAG = tag;
        this.parameters = new Paramable();
    }

    public DGPredictor(String tag, String params) {
        this(tag);
        this.parameters.setParameter(params);
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        int w = this.parameters.paramIntOrDefault("lookahead", 4);
        this.mDictionary = new HashMap();
        for (Sequence seq : trainingSequences) {
            List<Item> items = seq.getItems();
            int i = 0;
            while (i < items.size() - 1) {
                DGNode node = this.mDictionary.get(items.get((int)i).val);
                if (node == null) {
                    node = new DGNode(items.get((int)i).val);
                }
                ++node.totalSupport;
                int k = i + 1;
                while (k < i + 1 + w && k < items.size()) {
                    node.UpdOrAddArc(items.get((int)k).val);
                    ++k;
                }
                this.mDictionary.put(items.get((int)i).val, node);
                ++i;
            }
        }
        return null;
    }

    @Override
    public Sequence Predict(Sequence target) {
        double threshold = 0.12;
        DGNode node = null;
        int offset = 0;
        while (node == null && offset < target.size()) {
            Item lastItem = target.get(target.size() - (1 + offset));
            node = this.mDictionary.get(lastItem.val);
            ++offset;
        }
        if (node == null) {
            return new Sequence(-1);
        }
        double max = 0.0;
        int best = 0;
        for (DGArc arc : node.arcs) {
            double score = (double)arc.support / (double)node.totalSupport;
            if (!(score >= threshold) || !(score > max)) continue;
            max = score;
            best = arc.dest;
        }
        if (best == 0) {
            return new Sequence(-1);
        }
        Sequence predicted = new Sequence(-1);
        predicted.addItem(new Item(best));
        return predicted;
    }

    @Override
    public long size() {
        long nodeCount = 0L;
        for (DGNode node : this.mDictionary.values()) {
            nodeCount += (long)(1 + node.getArcCount());
        }
        return nodeCount;
    }

    @Override
    public float memoryUsage() {
        float size = 0.0f;
        for (DGNode node : this.mDictionary.values()) {
            size += (float)(4 + 8 * node.getArcCount());
        }
        return size;
    }

    public static void main(String[] args) {
        DGPredictor predictor = new DGPredictor();
        ArrayList<Sequence> training = new ArrayList<Sequence>();
        Sequence seq1 = new Sequence(-1);
        seq1.addItem(new Item(1));
        seq1.addItem(new Item(2));
        seq1.addItem(new Item(3));
        seq1.addItem(new Item(4));
        training.add(seq1);
        Sequence seq2 = new Sequence(-1);
        seq2.addItem(new Item(1));
        seq2.addItem(new Item(2));
        seq2.addItem(new Item(5));
        seq2.addItem(new Item(4));
        training.add(seq2);
        predictor.Train(training);
        Sequence seqT = new Sequence(-1);
        seqT.addItem(new Item(2));
        seqT.addItem(new Item(3));
        Sequence result = predictor.Predict(seqT);
        System.out.println(result.toString());
    }
}

