/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.DatabaseHelper;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceStatsGenerator;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers.MemoryLogger;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers.StatsLogger;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.profile.Profile;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.profile.ProfileManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Evaluator {
    private List<Predictor> predictors = new ArrayList<Predictor>();
    public static final int HOLDOUT = 0;
    public static final int KFOLD = 1;
    public static final int RANDOMSAMPLING = 2;
    private long startTime;
    private long endTime;
    private DatabaseHelper database;
    public StatsLogger stats;
    public List<StatsLogger> experiments;
    public List<String> datasets = new ArrayList<String>();
    public List<Integer> datasetsMaxCount = new ArrayList<Integer>();

    public Evaluator(String pathToDatasets) {
        this.database = new DatabaseHelper(pathToDatasets);
    }

    public void addPredictor(Predictor predictor) {
        this.predictors.add(predictor);
    }

    public void addDataset(String datasetName, int maxCount) {
        this.datasets.add(datasetName);
        this.datasetsMaxCount.add(maxCount);
    }

    public StatsLogger Start(int samplingType, float param, boolean showResults, boolean showDatasetStats, boolean showExecutionStats) throws IOException {
        ArrayList<String> statsColumns = new ArrayList<String>();
        statsColumns.add("Success");
        statsColumns.add("Failure");
        statsColumns.add("No Match");
        statsColumns.add("Too Small");
        statsColumns.add("Overall");
        statsColumns.add("Size (MB)");
        statsColumns.add("Train Time");
        statsColumns.add("Test Time");
        ArrayList<String> predictorNames = new ArrayList<String>();
        for (Predictor predictor : this.predictors) {
            predictorNames.add(predictor.getTAG());
        }
        int i = 0;
        while (i < this.datasets.size()) {
            int maxCount = this.datasetsMaxCount.get(i);
            String format = this.datasets.get(i);
            ProfileManager.loadProfileByName(format);
            this.database.loadDataset(format, maxCount);
            if (showDatasetStats) {
                System.out.println();
                SequenceStatsGenerator.prinStats(this.database.getDatabase(), format);
            }
            this.stats = new StatsLogger(statsColumns, predictorNames, false);
            this.startTime = System.currentTimeMillis();
            int id = 0;
            while (id < this.predictors.size()) {
                switch (samplingType) {
                    case 0: {
                        this.Holdout(param, id);
                        break;
                    }
                    case 1: {
                        this.KFold((int)param, id);
                        break;
                    }
                    case 2: {
                        this.RandomSubSampling(param, id);
                        break;
                    }
                    default: {
                        System.out.println("Unknown sampling type.");
                    }
                }
                ++id;
            }
            this.endTime = System.currentTimeMillis();
            this.finalizeStats(showExecutionStats);
            if (showResults) {
                System.out.println(this.stats.toString());
            }
            ++i;
        }
        return this.stats;
    }

    public void Holdout(double ratio, int classifierId) {
        List<Sequence> trainingSequences = this.getDatabaseCopy();
        List<Sequence> testSequences = this.splitList(trainingSequences, ratio);
        this.PrepareClassifier(trainingSequences, classifierId);
        this.StartClassifier(testSequences, classifierId);
    }

    public void RandomSubSampling(double ratio, int classifierId) {
        int k = 10;
        int i = 0;
        while (i < k) {
            this.Holdout(ratio, classifierId);
            MemoryLogger.addUpdate();
            ++i;
        }
    }

    public void KFold(int k, int classifierId) {
        if (k < 2) {
            throw new RuntimeException("K needs to be 2 or more");
        }
        List<Sequence> dataSet = this.getDatabaseCopy();
        double relativeRatio = 1.0 / (double)k;
        int absoluteRatio = (int)((double)dataSet.size() * relativeRatio);
        int i = 0;
        while (i < k) {
            int posStart = i * absoluteRatio;
            int posEnd = posStart + absoluteRatio;
            if (i == k - 1) {
                posEnd = dataSet.size();
            }
            LinkedList<Sequence> trainingSequences = new LinkedList<Sequence>();
            LinkedList<Sequence> testSequences = new LinkedList<Sequence>();
            int j = 0;
            while (j < dataSet.size()) {
                Sequence toAdd = dataSet.get(j);
                if (j >= posStart && j < posEnd) {
                    testSequences.add(toAdd);
                } else {
                    trainingSequences.add(toAdd);
                }
                ++j;
            }
            this.PrepareClassifier(trainingSequences, classifierId);
            this.StartClassifier(testSequences, classifierId);
            MemoryLogger.addUpdate();
            ++i;
        }
    }

    public void finalizeStats(boolean showExecutionStats) {
        for (Predictor predictor : this.predictors) {
            int success = (int)this.stats.get("Success", predictor.getTAG());
            int failure = (int)this.stats.get("Failure", predictor.getTAG());
            int noMatch = (int)this.stats.get("No Match", predictor.getTAG());
            int tooSmall = (int)this.stats.get("Too Small", predictor.getTAG());
            long matchingSize = success + failure;
            long testingSize = matchingSize + (long)noMatch + (long)tooSmall;
            this.stats.divide("Success", predictor.getTAG(), matchingSize);
            this.stats.divide("Failure", predictor.getTAG(), matchingSize);
            this.stats.divide("No Match", predictor.getTAG(), testingSize);
            this.stats.divide("Too Small", predictor.getTAG(), testingSize);
            this.stats.divide("Train Time", predictor.getTAG(), 100L);
            this.stats.divide("Test Time", predictor.getTAG(), 100L);
            this.stats.set("Overall", predictor.getTAG(), success);
            this.stats.divide("Overall", predictor.getTAG(), testingSize);
            this.stats.set("Size (MB)", predictor.getTAG(), predictor.memoryUsage());
            this.stats.divide("Size (MB)", predictor.getTAG(), 100000000L);
        }
        if (showExecutionStats) {
            MemoryLogger.addUpdate();
            MemoryLogger.displayUsage();
            System.out.println("Execution time: " + (this.endTime - this.startTime) / 1000L + " seconds");
        }
    }

    public static Boolean isGoodPrediction(Sequence consequent, Sequence predicted) {
        Boolean hasError = false;
        for (Item it : predicted.getItems()) {
            Boolean isFound = false;
            for (Item re : consequent.getItems()) {
                if (!re.val.equals(it.val)) continue;
                isFound = true;
            }
            if (isFound.booleanValue()) continue;
            hasError = true;
        }
        if (hasError.booleanValue()) {
            return false;
        }
        return true;
    }

    private void PrepareClassifier(List<Sequence> trainingSequences, int classifierId) {
        long start = System.currentTimeMillis();
        this.predictors.get(classifierId).Train(trainingSequences);
        long end = System.currentTimeMillis();
        double duration = (double)(end - start) / 1000.0;
        this.stats.set("Train Time", this.predictors.get(classifierId).getTAG(), duration);
    }

    private void StartClassifier(List<Sequence> testSequences, int classifierId) {
        long start = System.currentTimeMillis();
        for (Sequence target : testSequences) {
            if (target.size() > Profile.paramInt("consequentSize")) {
                Sequence consequent = target.getLastItems(Profile.paramInt("consequentSize"), 0);
                Sequence finalTarget = target.getLastItems(Profile.paramInt("windowSize"), Profile.paramInt("consequentSize"));
                Sequence predicted = this.predictors.get(classifierId).Predict(finalTarget);
                if (predicted.size() == 0) {
                    this.stats.inc("No Match", this.predictors.get(classifierId).getTAG());
                    continue;
                }
                if (Evaluator.isGoodPrediction(consequent, predicted).booleanValue()) {
                    this.stats.inc("Success", this.predictors.get(classifierId).getTAG());
                    continue;
                }
                this.stats.inc("Failure", this.predictors.get(classifierId).getTAG());
                continue;
            }
            this.stats.inc("Too Small", this.predictors.get(classifierId).getTAG());
        }
        long end = System.currentTimeMillis();
        double duration = (double)(end - start) / 1000.0;
        this.stats.set("Test Time", this.predictors.get(classifierId).getTAG(), duration);
    }

    private List<Sequence> splitList(List<Sequence> toSplit, double absoluteRatio) {
        int relativeRatio = (int)((double)toSplit.size() * absoluteRatio);
        List<Sequence> sub = toSplit.subList(relativeRatio, toSplit.size());
        ArrayList<Sequence> two = new ArrayList<Sequence>(sub);
        sub.clear();
        return two;
    }

    private List<Sequence> getDatabaseCopy() {
        return new ArrayList<Sequence>(this.database.getDatabase().getSequences().subList(0, this.database.getDatabase().size()));
    }
}

