/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.LZ78;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.LZ78.LZNode;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ALZ
extends Predictor {
    private int count;
    private HashMap<List<Integer>, LZNode> mDictionary;

    public ALZ() {
        this.TAG = "ALZ";
    }

    public ALZ(String tag) {
        this.TAG = tag;
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        this.mDictionary = new HashMap();
        LinkedList<Integer> window = new LinkedList<Integer>();
        int maxWindowLength = 0;
        for (Sequence seq : trainingSequences) {
            List<Item> items = seq.getItems();
            ArrayList<Integer> prefix = new ArrayList<Integer>();
            ArrayList<Integer> lzPhrase = new ArrayList<Integer>();
            int offset = 0;
            while (offset < items.size()) {
                Integer cur = items.get((int)offset).val;
                lzPhrase = new ArrayList(prefix);
                lzPhrase.add(cur);
                LZNode node = this.mDictionary.get(lzPhrase);
                if (node != null) {
                    node.inc();
                    this.mDictionary.put(lzPhrase, node);
                    if (prefix.size() > 0 && this.mDictionary.get(prefix) != null) {
                        this.mDictionary.get(prefix).incChildSupport();
                    }
                    prefix.add(cur);
                } else {
                    if (prefix.size() > 0 && this.mDictionary.get(prefix) != null) {
                        this.mDictionary.get(prefix).addChild(cur);
                    }
                    maxWindowLength = lzPhrase.size() > maxWindowLength ? lzPhrase.size() : maxWindowLength;
                    this.mDictionary.put(lzPhrase, new LZNode(cur));
                    prefix.clear();
                    ++this.count;
                }
                window.add(cur);
                if (window.size() > maxWindowLength) {
                    window.remove(0);
                }
                this.updateFromWindow(window);
                System.out.println(window);
                ++offset;
            }
        }
        return null;
    }

    private void updateFromWindow(List<Integer> window) {
        int size = window.size();
        while (size > 0) {
            this.addToDictionnary(window);
            window = window.subList(1, window.size());
        }
    }

    private void addToDictionnary(List<Integer> lzPhrase) {
        Integer lastItem = lzPhrase.get(lzPhrase.size() - 1);
        List<Integer> prefix = new LinkedList<Integer>();
        if (lzPhrase.size() > 1) {
            prefix = lzPhrase.subList(0, lzPhrase.size() - 1);
        }
        this.addToDictionnary(lzPhrase, prefix, lastItem);
    }

    private void addToDictionnary(List<Integer> lzPhrase, List<Integer> prefix, Integer lastItem) {
        if (prefix.size() > 0) {
            if (this.mDictionary.get(prefix) == null) {
                this.mDictionary.put(prefix, new LZNode(prefix.subList(prefix.size() - 1, prefix.size()).get(0)));
                ++this.count;
            }
            LZNode prefixNode = this.mDictionary.get(prefix);
            prefixNode.addChild(lastItem);
        }
        this.mDictionary.put(lzPhrase, new LZNode(lastItem));
        ++this.count;
    }

    @Override
    public Sequence Predict(Sequence target) {
        return null;
    }

    @Override
    public long size() {
        return 0L;
    }

    public static void main(String ... args) {
        Sequence s1 = new Sequence(1);
        s1.addItem(new Item(1));
        s1.addItem(new Item(2));
        s1.addItem(new Item(1));
        s1.addItem(new Item(2));
        s1.addItem(new Item(1));
        s1.addItem(new Item(2));
        s1.addItem(new Item(3));
        s1.addItem(new Item(4));
        s1.addItem(new Item(3));
        s1.addItem(new Item(2));
        s1.addItem(new Item(4));
        s1.addItem(new Item(1));
        s1.addItem(new Item(2));
        LinkedList<Sequence> training = new LinkedList<Sequence>();
        training.add(s1);
        ALZ alz = new ALZ();
        alz.Train(training);
    }

    @Override
    public float memoryUsage() {
        return 0.0f;
    }
}

