/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Markov;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Markov.MarkovState;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Paramable;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class MarkovFirstOrderPredictor
extends Predictor
implements Serializable {
    private HashMap<Integer, MarkovState> mDictionary;
    public Paramable parameters;

    public MarkovFirstOrderPredictor() {
        this.TAG = "Mark1";
        this.parameters = new Paramable();
    }

    public MarkovFirstOrderPredictor(String tag) {
        this.TAG = tag;
        this.parameters = new Paramable();
    }

    public MarkovFirstOrderPredictor(String tag, String params) {
        this(tag);
        this.parameters.setParameter(params);
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        this.mDictionary = new HashMap();
        for (Sequence seq : trainingSequences) {
            List<Item> items = seq.getItems();
            int i = 0;
            while (i < items.size() - 1) {
                MarkovState state = this.mDictionary.get(items.get((int)i).val);
                if (state == null) {
                    state = new MarkovState();
                }
                state.addTransition(items.get((int)(i + 1)).val);
                this.mDictionary.put(items.get((int)i).val, state);
                ++i;
            }
        }
        return true;
    }

    @Override
    public Sequence Predict(Sequence target) {
        Item lastItem = target.get(target.size() - 1);
        MarkovState state = this.mDictionary.get(lastItem.val);
        if (state == null) {
            return new Sequence(-1);
        }
        Integer nextState = state.getBestNextState();
        Sequence predicted = new Sequence(-1);
        predicted.addItem(new Item(nextState));
        return predicted;
    }

    @Override
    public long size() {
        long nodeCount = 0L;
        for (MarkovState state : this.mDictionary.values()) {
            nodeCount += (long)(1 + state.getTransitionCount());
        }
        return nodeCount;
    }

    @Override
    public float memoryUsage() {
        float size = 0.0f;
        for (MarkovState state : this.mDictionary.values()) {
            size += (float)(4 + 8 * state.getTransitionCount());
        }
        return size;
    }
}

