/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.cmdeogun;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;

public class Rule {
    private Itemset itemset1;
    private Itemset itemset2;
    private int transactioncount;

    public Rule(Itemset itemset1, Itemset itemset2) {
        this.itemset1 = itemset1;
        this.itemset2 = itemset2;
    }

    public Itemset getItemset1() {
        return this.itemset1;
    }

    public Itemset getItemset2() {
        return this.itemset2;
    }

    public double getAbsoluteSupport(int sequencecount) {
        return (double)this.transactioncount / (double)sequencecount;
    }

    public int getRelativeSupport() {
        return this.transactioncount;
    }

    public double getConfidence() {
        return (double)this.transactioncount / (double)this.itemset1.getAbsoluteSupport();
    }

    public double getLift(int sequencecount) {
        double firstTerm = (double)this.transactioncount / (double)sequencecount;
        double secondTerm = (double)this.itemset2.getAbsoluteSupport() / (double)sequencecount;
        double thirdTerm = (double)this.itemset1.getAbsoluteSupport() / (double)sequencecount;
        double lift = firstTerm / (secondTerm * thirdTerm);
        return lift;
    }

    public String getLiftAsString(int sequencecount) {
        double firstTerm = (double)this.transactioncount / (double)sequencecount;
        double secondTerm = (double)this.itemset2.getAbsoluteSupport() / (double)sequencecount;
        double thirdTerm = (double)this.itemset1.getAbsoluteSupport() / (double)sequencecount;
        double lift = firstTerm / (secondTerm * thirdTerm);
        return Double.toString(lift);
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return String.valueOf(this.itemset1.toString()) + " ==> " + this.itemset2.toString();
    }

    void incrementTransactionCount() {
        ++this.transactioncount;
    }

    void setTransactioncount(int transactioncount) {
        this.transactioncount = transactioncount;
    }
}

