/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.cmrules;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;

public class Rule {
    private Itemset itemset1;
    private Itemset itemset2;
    private int transactionCount;
    int sequentialTransactionCount;
    private double confidence;

    public Rule(Itemset itemset1, Itemset itemset2, int transactionCount, double confidence) {
        this.itemset1 = itemset1;
        this.itemset2 = itemset2;
        this.transactionCount = transactionCount;
        this.confidence = confidence;
    }

    public Rule(Rule rule) {
        this.itemset1 = rule.getItemset1();
        this.itemset2 = rule.getItemset2();
        this.confidence = rule.getConfidence();
        this.transactionCount = rule.getAbsoluteSupport();
    }

    public Itemset getItemset1() {
        return this.itemset1;
    }

    public Itemset getItemset2() {
        return this.itemset2;
    }

    public double getRelativeSupport(int objectCount) {
        return (double)this.transactionCount / (double)objectCount;
    }

    public int getAbsoluteSupport() {
        return this.transactionCount;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return String.valueOf(this.itemset1.toString()) + " ==> " + this.itemset2.toString();
    }

    public int getSequentialAbsoluteSeqSupport() {
        return this.sequentialTransactionCount;
    }

    public double getSequentialSupport(int objectCount) {
        return (double)this.sequentialTransactionCount / (double)objectCount;
    }

    public double getSequentialConfidence() {
        return (double)this.sequentialTransactionCount / (double)this.itemset1.getAbsoluteSupport();
    }

    void incrementTransactionCount() {
        ++this.transactionCount;
    }
}

