/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.FastDataset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.ListNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.SparseIdList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.VerticalIdList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ClosedItemsetNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ClosedItemsetTree;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ClosedSequenceNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ClosedSequenceTree;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ItemsetNodeType;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.NodeType;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AlgoCloFast {
    private FastDataset ds;
    private ClosedSequenceTree outputTree;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int patternCount = 0;
    int closedPatternCount = 0;
    int prunedPatternCount = 0;

    private void run() {
        List<ClosedItemsetNode> closedNodes = this.generateClosedItemsets();
        MemoryLogger.getInstance().checkMemory();
        this.outputTree = this.generateClosedSequences(closedNodes);
    }

    private List<ClosedItemsetNode> generateClosedItemsets() {
        ClosedItemsetNode node;
        ClosedItemsetTree tree = new ClosedItemsetTree();
        HashMap<Integer, List<ClosedItemsetNode>> closedTable = new HashMap<Integer, List<ClosedItemsetNode>>();
        LinkedList<ClosedItemsetNode> queue = new LinkedList<ClosedItemsetNode>();
        int pos = 0;
        for (Map.Entry<String, SparseIdList> entry : this.ds.getFrequentItemsets().entrySet()) {
            node = tree.addChild(tree.getRoot(), new Itemset(entry.getKey()), entry.getValue(), pos++);
            queue.add(node);
        }
        while (!queue.isEmpty()) {
            node = (ClosedItemsetNode)queue.remove();
            this.closedItemsetExtension(tree, node, closedTable);
            queue.addAll(node.getChildren());
        }
        ArrayList<ClosedItemsetNode> result = new ArrayList<ClosedItemsetNode>();
        closedTable.values().stream().forEach(l -> {
            boolean bl = result.addAll((Collection<ClosedItemsetNode>)l);
        });
        Collections.sort(result);
        return result;
    }

    private void closedItemsetExtension(ClosedItemsetTree tree, ClosedItemsetNode node, Map<Integer, List<ClosedItemsetNode>> closedTable) {
        boolean sentinel = false;
        int pos = 0;
        List<ClosedItemsetNode> children = node.getParent().getChildren();
        int i = node.getPosition() + 1;
        while (i < children.size()) {
            ClosedItemsetNode rightBrother = children.get(i);
            SparseIdList sil = SparseIdList.IStep(node.getIdList(), rightBrother.getIdList());
            if (sil.getAbsoluteSupport() >= this.ds.getAbsMinSup()) {
                if (sil.getAbsoluteSupport() == node.getIdList().getAbsoluteSupport() & sil.equals(node.getIdList())) {
                    node.setType(ItemsetNodeType.intermediate);
                    sentinel = true;
                }
                Itemset itemset2 = node.getItemset().clone();
                itemset2.addItem(rightBrother.getItemset().getLast());
                tree.addChild(node, itemset2, sil, pos++);
            }
            ++i;
        }
        if (!sentinel && !this.leftcheck(node, closedTable)) {
            node.setType(ItemsetNodeType.closed);
            closedTable.putIfAbsent(node.getAbsoluteSupport(), new ArrayList());
            closedTable.get(node.getAbsoluteSupport()).add(node);
        }
    }

    private boolean leftcheck(ClosedItemsetNode nodeToCheck, Map<Integer, List<ClosedItemsetNode>> closedTable) {
        Integer nodeSupp = nodeToCheck.getIdList().getAbsoluteSupport();
        ArrayList<ClosedItemsetNode> toRemove = new ArrayList<ClosedItemsetNode>();
        List list = closedTable.getOrDefault(nodeSupp, new ArrayList());
        if (closedTable.containsKey(nodeSupp)) {
            for (ClosedItemsetNode candidateClosed : list) {
                if (candidateClosed.getItemset().contains(nodeToCheck.getItemset())) {
                    return true;
                }
                if (!nodeToCheck.getItemset().contains(candidateClosed.getItemset()) || !nodeToCheck.getIdList().equals(candidateClosed.getIdList())) continue;
                toRemove.add(candidateClosed);
                candidateClosed.setType(ItemsetNodeType.notClosed);
            }
        }
        list.removeAll(toRemove);
        return false;
    }

    private ClosedSequenceTree generateClosedSequences(List<ClosedItemsetNode> closedNodes) {
        ClosedSequenceTree tree = new ClosedSequenceTree(this.ds.getAbsMinSup());
        for (ClosedItemsetNode node : closedNodes) {
            tree.addChild(tree.getRoot(), new Sequence(node.getItemset()), node.getIdList().getStartingVIL(), node.getAbsoluteSupport());
        }
        for (ClosedSequenceNode csn : tree.getRoot().getChildren()) {
            this.closedSequenceExtension(tree, csn);
        }
        return tree;
    }

    private void closedSequenceExtension(ClosedSequenceTree tree, ClosedSequenceNode csn) {
        if (csn.getType() == NodeType.toCheck) {
            if (this.closedByBackwardExtension(tree, csn)) {
                if (csn.getType() != NodeType.pruned) {
                    csn.setType(NodeType.notClosed);
                }
            } else {
                csn.setType(NodeType.closed);
            }
        }
        if (csn.getType() == NodeType.pruned) {
            return;
        }
        ListNode[] csnListNode = csn.getVerticalIdList().getElements();
        int count = 0;
        List<ClosedSequenceNode> brothers = csn.getParent().getChildren();
        for (ClosedSequenceNode b : brothers) {
            ListNode[] newPosList = new ListNode[csnListNode.length];
            ListNode[] bListNode = b.getVerticalIdList().getElements();
            int i = 0;
            while (i < csnListNode.length) {
                ListNode listNode = csnListNode[i];
                ListNode listNodeBrother = bListNode[i];
                if (listNode != null && listNodeBrother != null) {
                    if (listNodeBrother.getColumn() > listNode.getColumn()) {
                        newPosList[i] = listNodeBrother;
                        ++count;
                    } else if (listNodeBrother.getColumn() <= listNode.getColumn()) {
                        while (listNodeBrother != null && listNodeBrother.getColumn() <= listNode.getColumn()) {
                            listNodeBrother = listNodeBrother.next();
                        }
                        if (listNodeBrother != null) {
                            newPosList[i] = listNodeBrother;
                            ++count;
                        }
                    }
                }
                ++i;
            }
            if (count >= this.ds.getAbsMinSup()) {
                Sequence sequence = csn.getSequence().clone();
                sequence.add(b.getSequence().getLastItemset());
                tree.addChild(csn, sequence, new VerticalIdList(newPosList, count), count);
                if (count == csn.getAbsoluteSupport()) {
                    csn.setType(NodeType.notClosed);
                }
            }
            count = 0;
        }
        List<ClosedSequenceNode> children = csn.getChildren();
        for (ClosedSequenceNode n : children) {
            this.closedSequenceExtension(tree, n);
        }
    }

    private boolean closedByBackwardExtension(ClosedSequenceTree tree, ClosedSequenceNode csn) {
        ArrayList<Integer> validRows = new ArrayList<Integer>();
        int i = 0;
        while (i < csn.getVerticalIdList().getElements().length) {
            if (csn.getVerticalIdList().getElements()[i] != null) {
                validRows.add(i);
            }
            ++i;
        }
        LinkedList<ClosedSequenceNode> succsNodes = new LinkedList<ClosedSequenceNode>();
        succsNodes.addFirst(csn);
        ClosedSequenceNode currentNode = csn;
        while (currentNode.getParent() != tree.getRoot()) {
            ClosedSequenceNode predNode = currentNode.getParent();
            List<ClosedSequenceNode> betweenNodes = predNode.getChildren();
            for (ClosedSequenceNode betweenNode : betweenNodes) {
                if (betweenNode.getType() == NodeType.pruned || betweenNode == csn) continue;
                if (betweenNode.containsLastItemset(succsNodes.getFirst()) && this.itemsetClosure(betweenNode, succsNodes, validRows, csn)) {
                    return true;
                }
                if (!this.sequenceClosure(predNode, betweenNode, succsNodes, validRows, csn)) continue;
                return true;
            }
            succsNodes.addFirst(predNode);
            currentNode = predNode;
        }
        List<ClosedSequenceNode> predNodes = currentNode.getParent().getChildren();
        for (ClosedSequenceNode pred : predNodes) {
            if (pred.containsLastItemset((ClosedSequenceNode)succsNodes.getFirst()) && this.itemsetClosure(pred, succsNodes, validRows, csn)) {
                return true;
            }
            if (!this.sequenceClosure(pred, succsNodes, validRows, csn)) continue;
            return true;
        }
        return false;
    }

    private boolean sequenceClosure(ClosedSequenceNode predNode, LinkedList<ClosedSequenceNode> succsNodes, List<Integer> validRows, ClosedSequenceNode csn) {
        ListNode[] predVil = predNode.getVerticalIdList().getElements();
        ListNode[] candidateClosureVil = new ListNode[predVil.length];
        for (Integer i : validRows) {
            if (predVil[i] == null) {
                return false;
            }
            ListNode closureNode = predVil[i].before(succsNodes, i);
            if (closureNode == null) {
                return false;
            }
            candidateClosureVil[i.intValue()] = closureNode;
        }
        if (this.sameVil(candidateClosureVil, csn.getVerticalIdList().getElements(), validRows)) {
            csn.setType(NodeType.pruned);
        }
        return true;
    }

    private boolean sequenceClosure(ClosedSequenceNode predNode, ClosedSequenceNode backwardNode, LinkedList<ClosedSequenceNode> succsNodes, List<Integer> validRows, ClosedSequenceNode csn) {
        ListNode[] predVil = predNode.getVerticalIdList().getElements();
        ListNode[] backwardVil = backwardNode.getVerticalIdList().getElements();
        ListNode[] candidateClosureVil = new ListNode[predVil.length];
        for (Integer i : validRows) {
            if (backwardVil[i] == null) {
                return false;
            }
            if (predVil[i].getColumn() > backwardVil[i].getColumn()) {
                return false;
            }
            ListNode closureNode = backwardVil[i].before(succsNodes, i);
            if (closureNode == null) {
                return false;
            }
            candidateClosureVil[i.intValue()] = closureNode;
        }
        if (this.sameVil(candidateClosureVil, csn.getVerticalIdList().getElements(), validRows)) {
            csn.setType(NodeType.pruned);
        }
        return true;
    }

    private boolean sameVil(ListNode[] candidateClosureVil, ListNode[] positionsList, List<Integer> validColumns) {
        for (Integer i : validColumns) {
            if (candidateClosureVil[i].getColumn() == positionsList[i].getColumn()) continue;
            return false;
        }
        return true;
    }

    private boolean itemsetClosure(ClosedSequenceNode backwardNode, LinkedList<ClosedSequenceNode> succsNodes, List<Integer> validRows, ClosedSequenceNode csn) {
        ListNode[] backwardVil = backwardNode.getVerticalIdList().getElements();
        ListNode[] candidateClosureVil = new ListNode[backwardVil.length];
        for (Integer i : validRows) {
            if (backwardVil[i] == null) {
                return false;
            }
            ListNode closureNode = this.equal(backwardVil[i], succsNodes, i);
            if (closureNode == null) {
                return false;
            }
            candidateClosureVil[i.intValue()] = closureNode;
        }
        if (this.sameVil(candidateClosureVil, csn.getVerticalIdList().getElements(), validRows)) {
            csn.setType(NodeType.pruned);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private ListNode equal(ListNode node, LinkedList<ClosedSequenceNode> succNodes, Integer i) {
        curr = node;
        it = succNodes.iterator();
        succ = ((ClosedSequenceNode)it.next()).getVerticalIdList().getElements()[i];
        if ((succ = curr.equal(succ)) != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            n = (ClosedSequenceNode)it.next();
            if ((succ = succ.before(n.getVerticalIdList().getElements()[i])) != null) continue;
            return null;
lbl9:
            // 2 sources

            ** while (it.hasNext())
        }
lbl10:
        // 1 sources

        return succ;
    }

    public List<ClosedSequenceNode> getClosedFrequentNodes() {
        return ClosedSequenceTree.visit(this.outputTree);
    }

    public void writePatterns(Path outputFile) throws IOException {
        BufferedWriter out = Files.newBufferedWriter(outputFile, new OpenOption[0]);
        List<ClosedSequenceNode> nodes = this.getClosedFrequentNodes();
        int countClosed = 0;
        int countPruned = 0;
        for (ClosedSequenceNode node : nodes) {
            switch (node.getType()) {
                case closed: {
                    out.write(String.valueOf(node.toString()) + System.lineSeparator());
                    ++countClosed;
                    break;
                }
                case pruned: {
                    ++countPruned;
                }
            }
        }
        out.flush();
        out.close();
        this.closedPatternCount = countClosed;
        this.prunedPatternCount = countPruned;
        this.patternCount = nodes.size();
    }

    public void runAlgorithm(String inputFile, String outputPath, float minsup) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.ds = FastDataset.fromPrefixspanSource(inputFile, minsup, Float.MAX_VALUE);
        this.run();
        this.writePatterns(Paths.get(outputPath, new String[0]));
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void runAlgorithm(FastDataset dataset, String outputPath, float minsup) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.ds = dataset;
        this.run();
        this.writePatterns(Paths.get(outputPath, new String[0]));
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  Algorithm CloFast v2.29 - STATISTICS =============\n");
        r.append("Number of closed Patterns found : ");
        r.append(this.closedPatternCount);
        r.append('\n');
        r.append("  Pattern count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append("  Pruned Pattern count : ");
        r.append(this.prunedPatternCount);
        r.append('\n');
        r.append("Total time: ");
        r.append((float)(this.endTimestamp - this.startTimestamp) / 1000.0f);
        r.append(" s \n");
        r.append("Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }
}

