/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.Itemset;
import java.util.Iterator;
import java.util.LinkedList;

public class Sequence
implements Iterable<Itemset>,
Cloneable {
    private LinkedList<Itemset> elements = new LinkedList();

    public Sequence(Itemset ... itemset2) {
        Itemset[] itemsetArray = itemset2;
        int n = itemset2.length;
        int n2 = 0;
        while (n2 < n) {
            Itemset i = itemsetArray[n2];
            this.elements.add(i);
            ++n2;
        }
    }

    public void add(Itemset element) {
        this.elements.add(element);
    }

    public String getLastItem() {
        return this.getLastItemset().getLast();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (Itemset itemset2 : this.elements) {
            buff.append(itemset2.concatenate());
            buff.append(" -1 ");
        }
        return String.valueOf(buff.toString()) + "-2";
    }

    public Itemset getLastItemset() {
        return this.elements.getLast();
    }

    public int length() {
        return this.elements.size();
    }

    public Sequence clone() {
        Sequence other = new Sequence(new Itemset[0]);
        for (Itemset itemset2 : this.elements) {
            other.add(itemset2.clone());
        }
        return other;
    }

    @Override
    public Iterator<Itemset> iterator() {
        return this.elements.iterator();
    }

    public LinkedList<Itemset> getElements() {
        return this.elements;
    }

    public boolean containsItemset(Itemset itemset2) {
        return this.elements.stream().anyMatch(i -> i.contains(itemset2));
    }

    public boolean contains(Sequence other) {
        if (this.elements.size() < other.elements.size()) {
            return false;
        }
        int matchIndex = 0;
        for (Itemset itemset2 : other) {
            int nextIndex = -1;
            int i = matchIndex;
            while (i < this.elements.size()) {
                if (this.elements.get(i).contains(itemset2)) {
                    nextIndex = i;
                    break;
                }
                ++i;
            }
            if (nextIndex == -1) {
                return false;
            }
            matchIndex = nextIndex + 1;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence sequence = (Sequence)o;
        return !(this.elements != null ? !this.elements.equals(sequence.elements) : sequence.elements != null);
    }

    public int hashCode() {
        return this.elements != null ? this.elements.hashCode() : 0;
    }
}

