/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.ListNode;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.VerticalIdList;
import java.util.Arrays;
import java.util.LinkedList;

public class SparseIdList {
    private TransactionIds[] vector;
    private int absoluteSupport;

    public SparseIdList(int rows) {
        this.vector = new TransactionIds[rows];
    }

    public int length() {
        return this.vector.length;
    }

    public void addElement(int row, int value) {
        if (this.vector[row] == null) {
            this.vector[row] = new TransactionIds();
            ++this.absoluteSupport;
        }
        this.vector[row].add(new ListNode(value));
    }

    public ListNode getElement(int row, int col) {
        if (this.vector[row] != null && col < this.vector[row].size()) {
            return (ListNode)this.vector[row].get(col);
        }
        return null;
    }

    public static SparseIdList IStep(SparseIdList a, SparseIdList b) {
        SparseIdList sparseIdList = new SparseIdList(a.length());
        int i = 0;
        while (i < a.length()) {
            ListNode aNode = a.getElement(i, 0);
            ListNode bNode = b.getElement(i, 0);
            while (aNode != null && bNode != null) {
                if (aNode.getColumn() == bNode.getColumn()) {
                    sparseIdList.addElement(i, bNode.getColumn());
                    aNode = aNode.next();
                    bNode = bNode.next();
                    continue;
                }
                if (aNode.getColumn() > bNode.getColumn()) {
                    bNode = bNode.next();
                    continue;
                }
                aNode = aNode.next();
            }
            ++i;
        }
        return sparseIdList;
    }

    public VerticalIdList getStartingVIL() {
        ListNode[] vilElements = new ListNode[this.length()];
        int i = 0;
        while (i < vilElements.length) {
            vilElements[i] = this.getElement(i, 0);
            ++i;
        }
        return new VerticalIdList(vilElements, this.absoluteSupport);
    }

    public int getAbsoluteSupport() {
        return this.absoluteSupport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SparseIdList)) {
            return false;
        }
        SparseIdList that = (SparseIdList)o;
        int i = 0;
        while (i < this.vector.length) {
            TransactionIds these = this.vector[i];
            TransactionIds those = that.vector[i];
            if (these != null || those != null) {
                if (these == null || those == null) {
                    return false;
                }
                if (these.size() != those.size()) {
                    return false;
                }
                int j = 0;
                while (j < these.size()) {
                    if (((ListNode)these.get(j)).getColumn() != ((ListNode)those.get(j)).getColumn()) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.vector != null ? Arrays.hashCode(this.vector) : 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.vector.length) {
            TransactionIds currList = this.vector[i];
            if (currList != null) {
                int j = 0;
                while (j < currList.size()) {
                    buf.append(String.valueOf(((ListNode)currList.get(j)).toString()) + " ");
                    ++j;
                }
                buf.append("\n");
            } else {
                buf.append("null \n");
            }
            ++i;
        }
        return buf.toString();
    }

    class TransactionIds
    extends LinkedList<ListNode> {
        private static final long serialVersionUID = 1L;

        TransactionIds() {
        }

        @Override
        public boolean add(ListNode e) {
            if (this.size() != 0) {
                ListNode last = (ListNode)this.getLast();
                last.setNext(e);
            }
            return super.add(e);
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.size()) {
                buf.append(((ListNode)this.get(i)).toString());
                ++i;
            }
            return buf.toString();
        }
    }
}

