/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns.PatternCreator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class Pattern
implements Comparable<Pattern> {
    private List<ItemAbstractionPair> elements;
    private BitSet appearingIn;
    private int support;
    private int sumIdSequences = -1;

    public Pattern() {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.appearingIn = new BitSet();
    }

    public Pattern(List<ItemAbstractionPair> elements) {
        this.elements = elements;
        this.appearingIn = new BitSet();
    }

    public Pattern(ItemAbstractionPair pair) {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.elements.add(pair);
        this.appearingIn = new BitSet();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            result.append(this.elements.get(i).toString());
            ++i;
        }
        result.append("\t(").append(this.appearingIn.size()).append(')');
        result.append("\t[");
        result.append(this.getSupport());
        result.append("]");
        return result.toString();
    }

    public String toStringToFile(boolean outputSequenceIdentifiers) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            if (i == this.elements.size() - 1) {
                if (i != 0) {
                    result.append(this.elements.get(i).toStringToFile());
                } else {
                    result.append(this.elements.get(i).getItem());
                }
                result.append(" -1");
            } else if (i == 0) {
                result.append(this.elements.get(i).getItem());
            } else {
                result.append(this.elements.get(i).toStringToFile());
            }
            ++i;
        }
        result.append(" #SUP: ");
        result.append(this.getSupport());
        if (outputSequenceIdentifiers) {
            result.append(" #SID: ");
            i = this.appearingIn.nextSetBit(0);
            while (i >= 0) {
                result.append(i - 1);
                result.append(" ");
                i = this.appearingIn.nextSetBit(i + 1);
            }
        }
        return result.toString();
    }

    public Pattern clonePatron() {
        PatternCreator patternCreator = PatternCreator.getInstance();
        ArrayList<ItemAbstractionPair> elementsCopy = new ArrayList<ItemAbstractionPair>(this.elements);
        Pattern clone = patternCreator.createPattern(elementsCopy);
        return clone;
    }

    public List<ItemAbstractionPair> getElements() {
        return this.elements;
    }

    public ItemAbstractionPair getIthElement(int i) {
        return this.elements.get(i);
    }

    public ItemAbstractionPair getLastElement() {
        if (this.size() > 0) {
            return this.getIthElement(this.size() - 1);
        }
        return null;
    }

    public void setElements(List<ItemAbstractionPair> elements) {
        this.elements = elements;
    }

    public void add(ItemAbstractionPair pair) {
        this.elements.add(pair);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public int compareTo(Pattern o) {
        List<ItemAbstractionPair> elementOfSmallerPattern;
        List<ItemAbstractionPair> elementsOfGreaterPattern;
        if (this.getElements().size() >= o.getElements().size()) {
            elementsOfGreaterPattern = this.getElements();
            elementOfSmallerPattern = o.getElements();
        } else {
            elementOfSmallerPattern = this.getElements();
            elementsOfGreaterPattern = o.getElements();
        }
        int i = 0;
        while (i < elementOfSmallerPattern.size()) {
            int comparison = elementOfSmallerPattern.get(i).compareTo(elementsOfGreaterPattern.get(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        if (elementsOfGreaterPattern.size() == elementOfSmallerPattern.size()) {
            return 0;
        }
        if (this.getElements().size() < o.getElements().size()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof Pattern) {
            Pattern p = (Pattern)o;
            return this.compareTo(p) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }

    public BitSet getAppearingIn() {
        return this.appearingIn;
    }

    public void setAppearingIn(BitSet ids) {
        this.appearingIn = ids;
        this.setSupport(this.appearingIn.cardinality());
    }

    public boolean isSubpattern(AbstractionCreator abstractionCreator, Pattern p) {
        ArrayList<Integer> positions = new ArrayList<Integer>(p.size());
        int i = 0;
        while (i < this.size()) {
            positions.add(0);
            ++i;
        }
        return abstractionCreator.isSubpattern(this, p, 0, positions);
    }

    public int getSupport() {
        return this.support;
    }

    public void setSupport(int support) {
        this.support = support;
    }

    public int getSumIdSequences() {
        if (this.sumIdSequences < 0) {
            this.sumIdSequences = this.calculateSumIdSequences();
        }
        return this.sumIdSequences;
    }

    public void setSumIdSequences(int sumIdSequences) {
        this.sumIdSequences = sumIdSequences;
    }

    private int calculateSumIdSequences() {
        int sum = 0;
        int i = this.appearingIn.nextSetBit(0);
        while (i >= 0) {
            sum += i;
            i = this.appearingIn.nextSetBit(i + 1);
        }
        return sum;
    }

    public Pattern concatenate(ItemAbstractionPair pair) {
        Pattern result = this.clonePatron();
        result.add(pair);
        return result;
    }

    public Pattern concatenate(Pattern pattern) {
        Pattern result = this.clonePatron();
        result.getElements().addAll(pattern.getElements());
        return result;
    }
}

