/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.cost;

import ca.pfv.spmf.algorithms.sequentialpatterns.cost.CostUtilityPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.Event;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.EventSet;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.SequentialPatterns;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AlgoCEPM {
    private static final String AVGCOST = " #AVGCOST: ";
    private static final String TRADE = " #TRADE: ";
    private static final String SUP = " #SUP: ";
    private static final String UTIL = " #UTIL: ";
    private static final String OCCUP = " #OCCUP: ";
    private long startTime;
    private long endTime;
    private SequenceDatabase sequenceDatabase;
    private AlgorithmType algorithmName = null;
    private int minimumSupport;
    private double maximumCost;
    private double minimumOccpuancy;
    private int patternCount;
    private int projectedDatabaseCount;
    private int consideredPatternCount;
    private int maximumPatternLength = 999;
    private SequentialPatterns patterns = null;
    private static final int BUFFERSSIZE = 2000;
    private final int[] patternBuffer = new int[2000];
    private static final boolean DEBUGMODE = false;
    private Map<Integer, Double> sequenceIdUtility = new HashMap<Integer, Double>();
    private ArrayList<CostUtilityPair> costUtilityPairs = new ArrayList();
    private boolean useLowerBound;
    private boolean sortByUtilityForCEPN = false;
    private boolean outputLowestTradeOffForCEPN = false;
    private boolean sortByCorrelationCORCEPB = false;

    public SequentialPatterns runAlgorithmCEPB(String inputFile, String outputFile, int minsup, double maxcost, double minoccupancy) throws IOException {
        this.algorithmName = AlgorithmType.CEPB;
        this.runAlgorithm(inputFile, outputFile, minsup, maxcost, minoccupancy);
        return this.patterns;
    }

    public SequentialPatterns runAlgorithmCEPN(String inputFile, String outputFile, int minsup, double maxcost, double minoccupancy, boolean sortByUtilityForCEPN, boolean outputLowestTradeOffForCEPN) throws IOException {
        this.outputLowestTradeOffForCEPN = outputLowestTradeOffForCEPN;
        this.sortByUtilityForCEPN = sortByUtilityForCEPN;
        this.algorithmName = AlgorithmType.CEPN;
        this.runAlgorithm(inputFile, outputFile, minsup, maxcost, minoccupancy);
        return this.patterns;
    }

    public SequentialPatterns runAlgorithmCorCEPB(String inputFile, String outputFile, int minsup, double maxcost, double minoccupancy, boolean sortByCorrelationCORCEPB) throws IOException {
        this.sortByCorrelationCORCEPB = sortByCorrelationCORCEPB;
        this.algorithmName = AlgorithmType.CORCEPB;
        this.runAlgorithm(inputFile, outputFile, minsup, maxcost, minoccupancy);
        return this.patterns;
    }

    public SequentialPatterns runAlgorithm(String inputFile, String outputFile, int minsup, double maxcost, double minoccupancy) throws IOException {
        this.minimumSupport = minsup;
        this.maximumCost = maxcost;
        this.minimumOccpuancy = minoccupancy;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.sequenceDatabase = new SequenceDatabase();
        this.sequenceDatabase.loadFile(inputFile);
        this.sequenceIdUtility = this.sequenceDatabase.sequenceIdUtility;
        this.patterns = new SequentialPatterns("SEQUENTIAL LOWER BOUND PATTERN MINING");
        Map<Integer, Map<Integer, Pair>> mapSequenceID = this.findSequencesContainingItems();
        this.prefixSpanWithSingleItem(mapSequenceID);
        this.sequenceDatabase = null;
        if (outputFile != null) {
            if (AlgorithmType.CEPB.equals((Object)this.algorithmName)) {
                this.writeResultsToFileCEPB(outputFile);
            } else if (AlgorithmType.CEPN.equals((Object)this.algorithmName)) {
                this.writeResultsToFileCEPN(outputFile);
            } else {
                this.writeResultsToFileCORCEPB(outputFile);
            }
        }
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private void writeResultsToFileCEPB(String outputFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            DecimalFormat df = new DecimalFormat("0.000");
            for (List<SequentialPattern> level : this.patterns.levels) {
                for (SequentialPattern pattern : level) {
                    writer.write(pattern.eventSetstoString());
                    writer.write(SUP + pattern.getAbsoluteSupport());
                    writer.write(AVGCOST + df.format(pattern.getAverageCost()));
                    writer.write(OCCUP + df.format(pattern.getOccupancy()));
                    writer.newLine();
                }
            }
            writer.close();
        }
    }

    private void writeResultsToFileCEPN(String outputFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            DecimalFormat df = new DecimalFormat("0.000");
            if (this.sortByUtilityForCEPN) {
                Map<Double, List<SequentialPattern>> list = AlgoCEPM.sortByUtility(this.patterns);
                for (Map.Entry<Double, List<SequentialPattern>> entry : list.entrySet()) {
                    for (SequentialPattern pattern : entry.getValue()) {
                        writer.write(pattern.eventSetstoString());
                        writer.write(UTIL + df.format(pattern.getUtility()));
                        writer.write(SUP + pattern.getAbsoluteSupport());
                        writer.write(TRADE + df.format(pattern.getTradeOff()));
                        writer.write(OCCUP + df.format(pattern.getOccupancy()));
                        writer.write(AVGCOST + df.format(pattern.getAverageCost()));
                        writer.newLine();
                    }
                }
            } else if (this.outputLowestTradeOffForCEPN) {
                Map<Integer, SequentialPattern> smallestTraPattern = AlgoCEPM.chooseSmallMapUtiTrade(this.patterns);
                for (Map.Entry<Integer, SequentialPattern> entry : smallestTraPattern.entrySet()) {
                    SequentialPattern pattern = entry.getValue();
                    writer.write(pattern.eventSetstoString());
                    writer.write(UTIL + df.format(pattern.getUtility()));
                    writer.write(SUP + pattern.getAbsoluteSupport());
                    writer.write(TRADE + df.format(pattern.getTradeOff()));
                    writer.write(AVGCOST + df.format(pattern.getAverageCost()));
                    writer.write(OCCUP + df.format(pattern.getOccupancy()));
                    writer.newLine();
                }
            } else {
                for (List<SequentialPattern> level : this.patterns.levels) {
                    for (SequentialPattern pattern : level) {
                        writer.write(pattern.eventSetstoString());
                        writer.write(UTIL + df.format(pattern.getUtility()));
                        writer.write(SUP + pattern.getAbsoluteSupport());
                        writer.write(TRADE + df.format(pattern.getTradeOff()));
                        writer.write(AVGCOST + df.format(pattern.getAverageCost()));
                        writer.write(OCCUP + df.format(pattern.getOccupancy()));
                        writer.newLine();
                    }
                }
            }
            writer.close();
        }
    }

    private void writeResultsToFileCORCEPB(String outputFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            DecimalFormat df = new DecimalFormat("0.000");
            if (this.sortByCorrelationCORCEPB) {
                Map<Double, List<SequentialPattern>> list = AlgoCEPM.sortByCorrelation(this.patterns);
                for (Map.Entry<Double, List<SequentialPattern>> entry : list.entrySet()) {
                    for (SequentialPattern pattern : entry.getValue()) {
                        writer.write(pattern.eventSetstoString());
                        writer.write(" #CORR: " + df.format(pattern.getCorrelation()));
                        writer.write(SUP + pattern.getAbsoluteSupport());
                        writer.write(AVGCOST + df.format(pattern.getAverageCost()));
                        writer.write(OCCUP + df.format(pattern.getOccupancy()));
                        writer.newLine();
                    }
                }
            } else {
                for (List<SequentialPattern> level : this.patterns.levels) {
                    for (SequentialPattern pattern : level) {
                        writer.write(pattern.eventSetstoString());
                        writer.write(" #CORR: " + df.format(pattern.getCorrelation()));
                        writer.write(SUP + pattern.getAbsoluteSupport());
                        writer.write(AVGCOST + df.format(pattern.getAverageCost()));
                        writer.write(OCCUP + df.format(pattern.getOccupancy()));
                        writer.newLine();
                    }
                }
            }
            writer.close();
        }
    }

    public static Map<Integer, List<SequentialPattern>> chooseMapUtilTrade(SequentialPatterns patterns) {
        HashMap<Integer, List<SequentialPattern>> utilityPatternTrade = new HashMap<Integer, List<SequentialPattern>>();
        for (List<SequentialPattern> level : patterns.levels) {
            for (SequentialPattern pattern : level) {
                int utility = (int)pattern.getUtility();
                if (utilityPatternTrade.get(utility) == null) {
                    ArrayList<SequentialPattern> patternList = new ArrayList<SequentialPattern>();
                    patternList.add(pattern);
                    utilityPatternTrade.put(utility, patternList);
                    continue;
                }
                ((List)utilityPatternTrade.get(utility)).add(pattern);
            }
        }
        return utilityPatternTrade;
    }

    public static Map<Integer, SequentialPattern> chooseSmallMapUtiTrade(SequentialPatterns patterns) {
        HashMap<Integer, SequentialPattern> smallestTraPattern = new HashMap<Integer, SequentialPattern>();
        for (List<SequentialPattern> level : patterns.levels) {
            for (SequentialPattern pattern : level) {
                int utility = (int)pattern.getUtility();
                if (smallestTraPattern.get(utility) == null) {
                    smallestTraPattern.put(utility, pattern);
                }
                if (!(pattern.getTradeOff() <= ((SequentialPattern)smallestTraPattern.get(utility)).getTradeOff())) continue;
                smallestTraPattern.put(utility, pattern);
            }
        }
        return smallestTraPattern;
    }

    public static Map<Double, List<SequentialPattern>> sortByCorrelation(SequentialPatterns patterns) {
        TreeMap<Double, List<SequentialPattern>> treeMap = new TreeMap<Double, List<SequentialPattern>>(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return o2.compareTo(o1);
            }
        });
        for (List<SequentialPattern> level : patterns.levels) {
            for (SequentialPattern token : level) {
                if (treeMap.get(token.getCorrelation()) == null) {
                    ArrayList list = new ArrayList();
                    treeMap.put(token.getCorrelation(), list);
                }
                ((List)treeMap.get(token.getCorrelation())).add(token);
            }
        }
        return treeMap;
    }

    public static Map<Double, List<SequentialPattern>> sortByUtility(SequentialPatterns patterns) {
        TreeMap<Double, List<SequentialPattern>> treeMap = new TreeMap<Double, List<SequentialPattern>>(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return o2.compareTo(o1);
            }
        });
        for (List<SequentialPattern> level : patterns.levels) {
            for (SequentialPattern token : level) {
                if (treeMap.get(token.getUtility()) == null) {
                    ArrayList list = new ArrayList();
                    treeMap.put(token.getUtility(), list);
                }
                ((List)treeMap.get(token.getUtility())).add(token);
            }
        }
        return treeMap;
    }

    private Map<Integer, Map<Integer, Pair>> findSequencesContainingItems() {
        HashMap<Integer, Map<Integer, Pair>> mapSequenceID = new HashMap<Integer, Map<Integer, Pair>>();
        int i = 0;
        while (i < this.sequenceDatabase.size()) {
            Event[] sequence;
            Event[] eventArray = sequence = this.sequenceDatabase.getSequences().get(i);
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                Event token = eventArray[n2];
                if (token.getId() >= 0) {
                    if (mapSequenceID.get(token.getId()) == null) {
                        HashMap<Integer, Pair> seqIdCost = new HashMap<Integer, Pair>();
                        seqIdCost.put(i, new Pair(token.getCost(), sequence.length, i + 1));
                        mapSequenceID.put(token.getId(), seqIdCost);
                    } else if (!((Map)mapSequenceID.get(token.getId())).keySet().contains(i)) {
                        ((Map)mapSequenceID.get(token.getId())).put(i, new Pair(token.getCost(), sequence.length, i + 1));
                    }
                }
                ++n2;
            }
            ++i;
        }
        return mapSequenceID;
    }

    private void prefixSpanWithSingleItem(Map<Integer, Map<Integer, Pair>> mapSequenceID) throws IOException {
        block15: {
            block14: {
                int i = 0;
                while (i < this.sequenceDatabase.size()) {
                    Event[] sequence = this.sequenceDatabase.getSequences().get(i);
                    int currentPosition = 0;
                    Event[] eventArray = sequence;
                    int n = sequence.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Event token = eventArray[n2];
                        if (token.getId() >= 0) {
                            boolean isFrequent;
                            boolean bl = isFrequent = mapSequenceID.get(token.getId()).size() >= this.minimumSupport;
                            if (isFrequent) {
                                sequence[currentPosition] = token;
                                ++currentPosition;
                            }
                        } else if (token.getId() == -2) {
                            if (currentPosition > 0) {
                                sequence[currentPosition] = new Event(-2, -99.0);
                            }
                            Event[] newSequence = new Event[currentPosition + 1];
                            System.arraycopy(sequence, 0, newSequence, 0, currentPosition + 1);
                            this.sequenceDatabase.getSequences().set(i, newSequence);
                        }
                        ++n2;
                    }
                    ++i;
                }
                if (!AlgorithmType.CEPB.equals((Object)this.algorithmName) && !AlgorithmType.CEPN.equals((Object)this.algorithmName)) break block14;
                for (Map.Entry<Integer, Map<Integer, Pair>> entry : mapSequenceID.entrySet()) {
                    ++this.consideredPatternCount;
                    int support = entry.getValue().size();
                    ArrayList<Integer> sequenceID = new ArrayList<Integer>(entry.getValue().keySet());
                    if (support < this.minimumSupport) continue;
                    int event = entry.getKey();
                    double averageCost = this.getAverageCostWithSingleEvent(entry.getValue());
                    double occupancy = this.getOccupancyWithSingleEvent(entry.getValue());
                    if (averageCost <= this.maximumCost && occupancy >= this.minimumOccpuancy) {
                        this.costUtilityPairs = this.getListOfCostUtility(entry.getValue());
                        this.savePattern(event, averageCost, occupancy, entry.getValue(), this.costUtilityPairs);
                    }
                    double lowerSupportCost = this.getLowerBound(this.minimumSupport, entry.getValue());
                    double lowerBoundOfCost = lowerSupportCost / (double)this.minimumSupport;
                    double upperBoundOfOccupancy = this.getUpperBoundOccupancyWithSingleEvnet(entry.getValue());
                    if (!(lowerBoundOfCost <= this.maximumCost && upperBoundOfOccupancy >= this.minimumOccpuancy) && this.useLowerBound) continue;
                    this.patternBuffer[0] = event;
                    if (this.maximumPatternLength <= 1) continue;
                    List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseSingleItems(event, sequenceID);
                    ++this.projectedDatabaseCount;
                    this.recursionSingleEvents(projectedDatabase, 2, 0);
                }
                break block15;
            }
            if (!AlgorithmType.CORCEPB.equals((Object)this.algorithmName)) break block15;
            for (Map.Entry<Integer, Map<Integer, Pair>> entry : mapSequenceID.entrySet()) {
                ++this.consideredPatternCount;
                boolean isEventAllInClass1 = false;
                int numberOfClass0 = 0;
                int numberOfClass1 = 0;
                Map<Integer, Pair> token = entry.getValue();
                for (Integer sequenceId : token.keySet()) {
                    if (this.sequenceIdUtility.get(sequenceId) == 0.0) {
                        ++numberOfClass0;
                        continue;
                    }
                    ++numberOfClass1;
                }
                if (numberOfClass1 == token.size()) {
                    isEventAllInClass1 = true;
                }
                int support = entry.getValue().size();
                ArrayList<Integer> sequenceID = new ArrayList<Integer>(entry.getValue().keySet());
                if (support < this.minimumSupport || numberOfClass0 == token.size()) continue;
                double lowerSupportCost = this.getLowerBound(this.minimumSupport, entry.getValue());
                double lowerBoundOfCost = lowerSupportCost / (double)this.minimumSupport;
                double upperBoundOfOccupancy = this.getUpperBoundOccupancyWithSingleEvnet(entry.getValue());
                int event = entry.getKey();
                double averageCost = this.getAverageCostWithSingleEvent(entry.getValue());
                double occupancy = this.getOccupancyWithSingleEvent(entry.getValue());
                if (averageCost <= this.maximumCost && occupancy >= this.minimumOccpuancy) {
                    this.costUtilityPairs = this.getListOfCostUtility(entry.getValue());
                    this.savePattern(event, averageCost, occupancy, entry.getValue(), isEventAllInClass1, this.costUtilityPairs);
                }
                if (!(lowerBoundOfCost <= this.maximumCost && upperBoundOfOccupancy >= this.minimumOccpuancy) && this.useLowerBound) continue;
                this.patternBuffer[0] = event;
                if (this.maximumPatternLength <= 1) continue;
                List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseSingleItems(event, sequenceID);
                ++this.projectedDatabaseCount;
                this.recursionSingleEvents(projectedDatabase, 2, 0);
            }
        }
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    private ArrayList<CostUtilityPair> getListOfCostUtility(Map<Integer, Pair> seqIdPair) {
        ArrayList<CostUtilityPair> newCostUtilityPairs = new ArrayList<CostUtilityPair>();
        for (Map.Entry<Integer, Pair> entry : seqIdPair.entrySet()) {
            newCostUtilityPairs.add(new CostUtilityPair(entry.getValue().getCost(), this.sequenceIdUtility.get(entry.getKey())));
        }
        return newCostUtilityPairs;
    }

    private void savePattern(int event, double averageCost, double occupancy, Map<Integer, Pair> sequcenIdCost, boolean isEventAllInPositive, ArrayList<CostUtilityPair> costUtilityPairs) {
        ++this.patternCount;
        SequentialPattern pattern = new SequentialPattern();
        pattern.addEventset(new EventSet(event));
        ArrayList<Integer> sequenceIDS = new ArrayList<Integer>(sequcenIdCost.keySet());
        if (isEventAllInPositive) {
            pattern.setCorrelation(1.0);
        } else {
            ArrayList<Double> patternCostListOfNegativeSeq = new ArrayList<Double>();
            ArrayList<Double> patternCostListOfPostitiveSeq = new ArrayList<Double>();
            ArrayList<Double> patternCostOfBothClass = new ArrayList<Double>();
            for (Map.Entry<Integer, Pair> entry : sequcenIdCost.entrySet()) {
                if (this.sequenceIdUtility.get(entry.getKey()) == 0.0) {
                    patternCostListOfNegativeSeq.add(entry.getValue().getCost());
                } else {
                    patternCostListOfPostitiveSeq.add(entry.getValue().getCost());
                }
                patternCostOfBothClass.add(entry.getValue().getCost());
            }
            double correlation = this.getCorrelationOfPattern(patternCostListOfNegativeSeq, patternCostListOfPostitiveSeq, patternCostOfBothClass, averageCost, pattern);
            pattern.setCorrelation(correlation);
            pattern.setOccupancy(occupancy);
            pattern.setNumInNegative(patternCostListOfNegativeSeq.size());
            pattern.setNumInPositive(patternCostListOfPostitiveSeq.size());
        }
        pattern.setCostUtilityPairs(costUtilityPairs);
        pattern.setAverageCost(averageCost);
        pattern.setSequencesIDs(sequenceIDS);
        this.patterns.addSequence(pattern, 1);
    }

    private void savePattern(int event, Double averageCost, double occupancy, Map<Integer, Pair> sequcenIdCost, ArrayList<CostUtilityPair> costUtilityPairs) {
        ++this.patternCount;
        SequentialPattern pattern = new SequentialPattern();
        pattern.addEventset(new EventSet(event));
        ArrayList<Integer> sequenceIDS = new ArrayList<Integer>(sequcenIdCost.keySet());
        if (this.algorithmName.equals((Object)AlgorithmType.CEPN)) {
            double patternUtility = 0.0;
            for (Map.Entry<Integer, Pair> entry : sequcenIdCost.entrySet()) {
                patternUtility += this.sequenceIdUtility.get(entry.getKey()).doubleValue();
            }
            double averageUtility = patternUtility / (double)sequcenIdCost.size() == 0.0 ? 1.0 : patternUtility / (double)sequcenIdCost.size();
            pattern.setUtility(averageUtility);
            pattern.setTradeOff(averageCost / averageUtility);
        }
        pattern.setCostUtilityPairs(costUtilityPairs);
        pattern.setAverageCost(averageCost);
        pattern.setSequencesIDs(sequenceIDS);
        pattern.setOccupancy(occupancy);
        this.patterns.addSequence(pattern, 1);
    }

    private double getAverageCostWithSingleEvent(Map<Integer, Pair> sequenceIdCost) {
        double costOfPattern = 0.0;
        for (Map.Entry<Integer, Pair> token : sequenceIdCost.entrySet()) {
            costOfPattern += token.getValue().getCost();
        }
        return costOfPattern / (double)sequenceIdCost.size();
    }

    private double getLowerBound(int minimumSupport, Map<Integer, Pair> sequenceIdCost) {
        ArrayList<Double> eventCostInEachSequence = new ArrayList<Double>();
        Collection<Pair> pairs = sequenceIdCost.values();
        for (Pair token : pairs) {
            eventCostInEachSequence.add(token.getCost());
        }
        Collections.sort(eventCostInEachSequence);
        double lowerBound = 0.0;
        int i = 0;
        while (i < minimumSupport) {
            lowerBound += ((Double)eventCostInEachSequence.get(i)).doubleValue();
            ++i;
        }
        return lowerBound;
    }

    private double getOccupancyWithSingleEvent(Map<Integer, Pair> sequenceIDLength) {
        double occupancy = 0.0;
        for (Map.Entry<Integer, Pair> entry : sequenceIDLength.entrySet()) {
            int lenthOfSeq = entry.getValue().getTotalLengthOfSeq() - 1;
            occupancy += 1.0 / (double)lenthOfSeq;
        }
        return occupancy / (double)sequenceIDLength.size();
    }

    private double getOccupancyWithMultipleEvents(List<PseudoSequence> pseudoSequenceList, float patternLength) {
        double occupancy = 0.0;
        for (PseudoSequence token : pseudoSequenceList) {
            int lengthOfSeq = token.getSequenceLength() - 1;
            occupancy += (double)(patternLength / (float)lengthOfSeq);
        }
        return occupancy / (double)pseudoSequenceList.size();
    }

    private double getUpperBoundOccupancyWithSingleEvnet(Map<Integer, Pair> sequenceIDLength) {
        double upperOccupancy = 0.0;
        ArrayList<Double> upperOccupList = new ArrayList<Double>();
        for (Map.Entry<Integer, Pair> entry : sequenceIDLength.entrySet()) {
            int lenOfSeq = entry.getValue().getTotalLengthOfSeq() - 1;
            upperOccupList.add((1.0 + (double)(lenOfSeq - entry.getValue().getIndexOfNextEvent())) / (double)lenOfSeq);
        }
        Collections.sort(upperOccupList, new Comparator<Double>(){

            @Override
            public int compare(Double a, Double b) {
                return b.compareTo(a);
            }
        });
        int i = 0;
        while (i < this.minimumSupport) {
            upperOccupancy += ((Double)upperOccupList.get(i)).doubleValue();
            ++i;
        }
        return upperOccupancy / (double)this.minimumSupport;
    }

    private double getUpperBoundOccupancyWithMultipeEvents(List<PseudoSequence> list, float patternLength) {
        double upperOccupancy = 0.0;
        ArrayList<Double> upperOccupList = new ArrayList<Double>();
        for (PseudoSequence token : list) {
            int len = token.getSequenceLength() - 1;
            upperOccupList.add(Double.valueOf((patternLength + (float)len - (float)token.indexFirstItem) / (float)len));
        }
        Collections.sort(upperOccupList, new Comparator<Double>(){

            @Override
            public int compare(Double a, Double b) {
                return b.compareTo(a);
            }
        });
        int i = 0;
        while (i < this.minimumSupport) {
            upperOccupancy += ((Double)upperOccupList.get(i)).doubleValue();
            ++i;
        }
        return upperOccupancy / (double)this.minimumSupport;
    }

    private List<PseudoSequence> buildProjectedDatabaseSingleItems(int event, List<Integer> sequenceIDs) {
        ArrayList<PseudoSequence> projectedDatabase = new ArrayList<PseudoSequence>();
        block0: for (int sequenceID : sequenceIDs) {
            Event[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int j = 0;
            while (sequence[j].getId() != -2) {
                int token = sequence[j].getId();
                if (token == event) {
                    if (sequence[j + 1].getId() == -2) continue block0;
                    PseudoSequence pseudoSequence = new PseudoSequence(sequenceID, j + 1, sequence.length);
                    projectedDatabase.add(pseudoSequence);
                    continue block0;
                }
                ++j;
            }
            MemoryLogger.getInstance().checkMemory();
        }
        return projectedDatabase;
    }

    private void recursionSingleEvents(List<PseudoSequence> database, int k, int lastBufferPositionOfPattern) throws IOException {
        Map<Integer, List<PseudoSequence>> eventsPseudoSequence = this.findAllFrequentPairsSingleEvents(database);
        database = null;
        if (this.algorithmName.equals((Object)AlgorithmType.CEPB) || this.algorithmName.equals((Object)AlgorithmType.CEPN)) {
            for (Map.Entry<Integer, List<PseudoSequence>> entry : eventsPseudoSequence.entrySet()) {
                ++this.consideredPatternCount;
                int support = entry.getValue().size();
                if (support >= this.minimumSupport) {
                    this.patternBuffer[lastBufferPositionOfPattern + 1] = -1;
                    this.patternBuffer[lastBufferPositionOfPattern + 2] = entry.getKey();
                    double lowerSupportCost = this.getLowerBound(lastBufferPositionOfPattern, entry.getKey(), entry.getValue());
                    double lowerboundOfCost = lowerSupportCost / (double)this.minimumSupport;
                    double averageCost = this.getAverageCostWithMulEvents(lastBufferPositionOfPattern, entry.getValue(), entry.getKey());
                    double occupancy = this.getOccupancyWithMultipleEvents(entry.getValue(), k);
                    double upperBoundOfOccupancy = this.getOccupancyWithMultipleEvents(entry.getValue(), k);
                    if (averageCost <= this.maximumCost && occupancy >= this.minimumOccpuancy) {
                        this.costUtilityPairs = this.setListOfCostUtility(lastBufferPositionOfPattern + 2, entry.getValue());
                        this.savePattern(lastBufferPositionOfPattern + 2, entry.getValue(), averageCost, occupancy, this.costUtilityPairs);
                    }
                    if ((lowerboundOfCost <= this.maximumCost && upperBoundOfOccupancy >= this.minimumOccpuancy || !this.useLowerBound) && k < this.maximumPatternLength) {
                        ++this.projectedDatabaseCount;
                        this.recursionSingleEvents(entry.getValue(), k + 1, lastBufferPositionOfPattern + 2);
                    }
                }
                MemoryLogger.getInstance().checkMemory();
            }
        }
        if (this.algorithmName.equals((Object)AlgorithmType.CORCEPB)) {
            for (Map.Entry<Integer, List<PseudoSequence>> entry : eventsPseudoSequence.entrySet()) {
                ++this.consideredPatternCount;
                int numberOfNegSeq = 0;
                int numberOfPosSeq = 0;
                for (PseudoSequence sequence : entry.getValue()) {
                    if (this.sequenceIdUtility.get(sequence.sequenceID) == 0.0) {
                        ++numberOfNegSeq;
                        continue;
                    }
                    ++numberOfPosSeq;
                }
                boolean isPatternAllInPosSeq = numberOfPosSeq == entry.getValue().size();
                int support = entry.getValue().size();
                if (support >= this.minimumSupport && numberOfNegSeq != entry.getValue().size()) {
                    double lowerSupportCost = this.getLowerBound(lastBufferPositionOfPattern, entry.getKey(), entry.getValue());
                    double lowerboundOfCost = lowerSupportCost / (double)this.minimumSupport;
                    double averageCost = this.getAverageCostWithMulEvents(lastBufferPositionOfPattern, entry.getValue(), entry.getKey());
                    double occupancy = this.getOccupancyWithMultipleEvents(entry.getValue(), k);
                    double upperBoundOfOccupancy = this.getUpperBoundOccupancyWithMultipeEvents(entry.getValue(), k);
                    this.patternBuffer[lastBufferPositionOfPattern + 1] = -1;
                    this.patternBuffer[lastBufferPositionOfPattern + 2] = entry.getKey();
                    if (averageCost <= this.maximumCost && occupancy >= this.minimumOccpuancy) {
                        this.costUtilityPairs = this.setListOfCostUtility(lastBufferPositionOfPattern + 2, entry.getValue());
                        this.savePattern(lastBufferPositionOfPattern + 2, eventsPseudoSequence.get(entry.getKey()), isPatternAllInPosSeq, averageCost, occupancy, this.costUtilityPairs);
                    }
                    if ((lowerboundOfCost <= this.maximumCost && upperBoundOfOccupancy >= this.minimumOccpuancy || !this.useLowerBound) && k < this.maximumPatternLength) {
                        ++this.projectedDatabaseCount;
                        this.recursionSingleEvents(entry.getValue(), k + 1, lastBufferPositionOfPattern + 2);
                    }
                }
                MemoryLogger.getInstance().checkMemory();
            }
        }
    }

    private ArrayList<CostUtilityPair> setListOfCostUtility(int lastBufferPosition, List<PseudoSequence> pseudoSequences) {
        ArrayList<CostUtilityPair> costUtilityPairs = new ArrayList<CostUtilityPair>();
        ArrayList<Integer> eventsIdBeforeCurrentEvent = new ArrayList<Integer>();
        SequentialPattern pattern = new SequentialPattern();
        EventSet currentEventset = new EventSet();
        int i = 0;
        while (i <= lastBufferPosition) {
            int token = this.patternBuffer[i];
            if (token >= 0) {
                currentEventset.addEvent(token);
                eventsIdBeforeCurrentEvent.add(token);
            } else if (token == -1) {
                pattern.addEventset(currentEventset);
                currentEventset = new EventSet();
            }
            ++i;
        }
        pattern.addEventset(currentEventset);
        for (PseudoSequence token : pseudoSequences) {
            int currentEventPosition = token.indexFirstItem - 1;
            int sequenceId = token.sequenceID;
            double costOfPattern = 0.0;
            Event[] events = this.sequenceDatabase.getSequences().get(sequenceId);
            int j = 0;
            int i2 = 0;
            while (i2 <= currentEventPosition) {
                if (events[i2].getId() == ((Integer)eventsIdBeforeCurrentEvent.get(j)).intValue()) {
                    costOfPattern += events[i2].getCost();
                    ++j;
                }
                ++i2;
            }
            costUtilityPairs.add(new CostUtilityPair(costOfPattern, this.sequenceIdUtility.get(sequenceId)));
        }
        return costUtilityPairs;
    }

    private Map<Integer, List<PseudoSequence>> findAllFrequentPairsSingleEvents(List<PseudoSequence> sequences) {
        HashMap<Integer, List<PseudoSequence>> mapEventsPseudoSequences = new HashMap<Integer, List<PseudoSequence>>();
        for (PseudoSequence pseudoSequence : sequences) {
            int sequenceID = pseudoSequence.getOriginalSequenceID();
            Event[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int i = pseudoSequence.indexFirstItem;
            while (sequence[i].getId() != -2) {
                int token = sequence[i].getId();
                if (token >= 0) {
                    ArrayList<PseudoSequence> listSequences = (ArrayList<PseudoSequence>)mapEventsPseudoSequences.get(token);
                    if (listSequences == null) {
                        listSequences = new ArrayList<PseudoSequence>();
                        mapEventsPseudoSequences.put(token, listSequences);
                    }
                    boolean ok = true;
                    if (listSequences.size() > 0) {
                        boolean bl = ok = ((PseudoSequence)listSequences.get((int)(listSequences.size() - 1))).sequenceID != sequenceID;
                    }
                    if (ok) {
                        listSequences.add(new PseudoSequence(sequenceID, i + 1, sequence.length));
                    }
                }
                MemoryLogger.getInstance().checkMemory();
                ++i;
            }
        }
        return mapEventsPseudoSequences;
    }

    private double getLowerBound(int lastBufferPosition, int currentEvent, List<PseudoSequence> pseudoSequences) {
        double lowerSupportCost = 0.0;
        ArrayList<Integer> eventsBeforeCurrentEvent = new ArrayList<Integer>();
        int i = 0;
        while (i <= lastBufferPosition) {
            int token = this.patternBuffer[i];
            if (token >= 0) {
                eventsBeforeCurrentEvent.add(token);
            }
            ++i;
        }
        eventsBeforeCurrentEvent.add(currentEvent);
        ArrayList<Double> listOfCost = new ArrayList<Double>();
        for (PseudoSequence token : pseudoSequences) {
            double costOfPattern = 0.0;
            int currentEventPosition = token.indexFirstItem - 1;
            int sequenceId = token.sequenceID;
            Event[] events = this.sequenceDatabase.getSequences().get(sequenceId);
            int j = 0;
            int i2 = 0;
            while (i2 <= currentEventPosition) {
                if (events[i2].getId() == ((Integer)eventsBeforeCurrentEvent.get(j)).intValue()) {
                    costOfPattern += events[i2].getCost();
                    ++j;
                }
                ++i2;
            }
            listOfCost.add(costOfPattern);
        }
        Collections.sort(listOfCost);
        int i3 = 0;
        while (i3 < this.minimumSupport) {
            lowerSupportCost += ((Double)listOfCost.get(i3)).doubleValue();
            ++i3;
        }
        return lowerSupportCost;
    }

    private void savePattern(int lastBufferPosition, List<PseudoSequence> pseudoSequences, double averageCost, double occupancy, ArrayList<CostUtilityPair> costUtilityPairs) {
        ++this.patternCount;
        ArrayList<Integer> eventsIdBeforeCurrentEvent = new ArrayList<Integer>();
        SequentialPattern pattern = new SequentialPattern();
        int eventsetCount = 0;
        EventSet currentEventset = new EventSet();
        int i = 0;
        while (i <= lastBufferPosition) {
            int token = this.patternBuffer[i];
            if (token >= 0) {
                currentEventset.addEvent(token);
                eventsIdBeforeCurrentEvent.add(token);
            } else if (token == -1) {
                pattern.addEventset(currentEventset);
                currentEventset = new EventSet();
                ++eventsetCount;
            }
            ++i;
        }
        pattern.addEventset(currentEventset);
        ++eventsetCount;
        ArrayList<Integer> sequencesIDs = new ArrayList<Integer>(pseudoSequences.size());
        int i2 = 0;
        while (i2 < pseudoSequences.size()) {
            sequencesIDs.add(pseudoSequences.get((int)i2).sequenceID);
            ++i2;
        }
        if (this.algorithmName.equals((Object)AlgorithmType.CEPN)) {
            double tradeOff = this.getPatternWithMultiEvenTradeoff(pseudoSequences, averageCost, pattern);
            pattern.setTradeOff(tradeOff);
        }
        pattern.setCostUtilityPairs(costUtilityPairs);
        pattern.setSequencesIDs(sequencesIDs);
        pattern.setAverageCost(averageCost);
        pattern.setOccupancy(occupancy);
        this.patterns.addSequence(pattern, eventsetCount);
    }

    private void savePattern(int lastBufferPosition, List<PseudoSequence> pseudoSequences, boolean isPatternAllInPositiveSeq, double averageCost, double occupancy, ArrayList<CostUtilityPair> costUtilityPairs) {
        ++this.patternCount;
        ArrayList<Integer> eventsIdBeforeCurrentEvent = new ArrayList<Integer>();
        SequentialPattern pattern = new SequentialPattern();
        int eventsetCount = 0;
        EventSet currentEventset = new EventSet();
        int i = 0;
        while (i <= lastBufferPosition) {
            int token = this.patternBuffer[i];
            if (token >= 0) {
                currentEventset.addEvent(token);
                eventsIdBeforeCurrentEvent.add(token);
            } else if (token == -1) {
                pattern.addEventset(currentEventset);
                currentEventset = new EventSet();
                ++eventsetCount;
            }
            ++i;
        }
        pattern.addEventset(currentEventset);
        ++eventsetCount;
        ArrayList<Integer> sequencesIDs = new ArrayList<Integer>(pseudoSequences.size());
        int i2 = 0;
        while (i2 < pseudoSequences.size()) {
            sequencesIDs.add(pseudoSequences.get((int)i2).sequenceID);
            ++i2;
        }
        double correlation = this.getPatternWithMultiEventCorrelation(eventsIdBeforeCurrentEvent, pseudoSequences, pattern, isPatternAllInPositiveSeq);
        pattern.setCostUtilityPairs(costUtilityPairs);
        pattern.setSequencesIDs(sequencesIDs);
        pattern.setAverageCost(averageCost);
        pattern.setOccupancy(occupancy);
        pattern.setCorrelation(correlation);
        this.patterns.addSequence(pattern, eventsetCount);
    }

    private double getAverageCostWithMulEvents(int lastBufferPosition, List<PseudoSequence> pseudoSequences, int currentEvent) {
        ArrayList<Integer> eventsIdBeforeCurrentEvent = new ArrayList<Integer>();
        double costOfPattern = 0.0;
        int i = 0;
        while (i <= lastBufferPosition) {
            int token = this.patternBuffer[i];
            if (token >= 0) {
                eventsIdBeforeCurrentEvent.add(token);
            }
            ++i;
        }
        eventsIdBeforeCurrentEvent.add(currentEvent);
        for (PseudoSequence token : pseudoSequences) {
            int currentEventPosition = token.indexFirstItem - 1;
            int sequenceId = token.sequenceID;
            Event[] events = this.sequenceDatabase.getSequences().get(sequenceId);
            int j = 0;
            int i2 = 0;
            while (i2 <= currentEventPosition) {
                if (events[i2].getId() == ((Integer)eventsIdBeforeCurrentEvent.get(j)).intValue()) {
                    costOfPattern += events[i2].getCost();
                    ++j;
                }
                ++i2;
            }
        }
        return costOfPattern / (double)pseudoSequences.size();
    }

    private double getPatternWithMultiEvenTradeoff(List<PseudoSequence> pseudoSequences, double averageCost, SequentialPattern pattern) {
        if (this.algorithmName.equals((Object)AlgorithmType.CEPN)) {
            double patternUtility = 0.0;
            for (PseudoSequence token : pseudoSequences) {
                patternUtility += this.sequenceIdUtility.get(token.sequenceID).doubleValue();
            }
            double averageUtility = patternUtility / (double)pseudoSequences.size() == 0.0 ? 1.0 : patternUtility / (double)pseudoSequences.size();
            pattern.setUtility(averageUtility);
            return averageCost / averageUtility;
        }
        return -999.0;
    }

    private double getPatternWithMultiEventCorrelation(List<Integer> eventsBeforeCurrentEvent, List<PseudoSequence> pseudoSequences, SequentialPattern pattern, boolean isPatternAllInPostiveSeq) {
        double costOfPattern = 0.0;
        double patternCostOfEachSeq = 0.0;
        if (this.algorithmName.equals((Object)AlgorithmType.CORCEPB)) {
            if (isPatternAllInPostiveSeq) {
                return 1.0;
            }
            ArrayList<Double> patternCostListOfclass0 = new ArrayList<Double>();
            ArrayList<Double> patternCostListOfclass1 = new ArrayList<Double>();
            ArrayList<Double> patternCostOfBothClass = new ArrayList<Double>();
            for (PseudoSequence token : pseudoSequences) {
                int currentEventPosition = token.indexFirstItem - 1;
                int sequenceId = token.sequenceID;
                Event[] events = this.sequenceDatabase.getSequences().get(sequenceId);
                patternCostOfEachSeq = 0.0;
                int j = 0;
                int i = 0;
                while (i <= currentEventPosition) {
                    if (events[i].getId() == eventsBeforeCurrentEvent.get(j).intValue()) {
                        costOfPattern += events[i].getCost();
                        patternCostOfEachSeq += events[i].getCost();
                        ++j;
                    }
                    ++i;
                }
                if (this.sequenceIdUtility.get(token.sequenceID) == 0.0) {
                    patternCostListOfclass0.add(patternCostOfEachSeq);
                    patternCostOfBothClass.add(patternCostOfEachSeq);
                    continue;
                }
                patternCostListOfclass1.add(patternCostOfEachSeq);
                patternCostOfBothClass.add(patternCostOfEachSeq);
            }
            double correlation = this.getCorrelationOfPattern(patternCostListOfclass0, patternCostListOfclass1, patternCostOfBothClass, costOfPattern / (double)patternCostOfBothClass.size(), pattern);
            pattern.setNumInNegative(patternCostListOfclass0.size());
            pattern.setNumInPositive(patternCostListOfclass1.size());
            return correlation;
        }
        return -99.0;
    }

    private double getCorrelationOfPattern(List<Double> patternCostListOfNegativeSeq, List<Double> patternCostListOfPositiveSeq, List<Double> patternCostOfBothClass, double averageCostOfEvent, SequentialPattern pattern) {
        double correlation = 0.0;
        double averageCostOfNegSeq = 0.0;
        double averageCostOfPosSeq = 0.0;
        double sizeOfNegSeq = patternCostListOfNegativeSeq.size();
        double sizeOfPosSeq = patternCostListOfPositiveSeq.size();
        double totalSizeOfevent = patternCostOfBothClass.size();
        double standDeviation = 0.0;
        for (Double eventCost : patternCostListOfNegativeSeq) {
            averageCostOfNegSeq += eventCost.doubleValue();
        }
        averageCostOfNegSeq /= sizeOfNegSeq;
        for (Double eventCost : patternCostListOfPositiveSeq) {
            averageCostOfPosSeq += eventCost.doubleValue();
        }
        averageCostOfPosSeq /= sizeOfPosSeq;
        for (Double eventCost : patternCostOfBothClass) {
            standDeviation += Math.pow(eventCost - averageCostOfEvent, 2.0);
        }
        if ((standDeviation = Math.sqrt(standDeviation / (double)patternCostOfBothClass.size())) == 0.0) {
            standDeviation += 1.0;
        }
        correlation = (averageCostOfPosSeq - averageCostOfNegSeq) / standDeviation * Math.sqrt(sizeOfNegSeq / totalSizeOfevent * (sizeOfPosSeq / totalSizeOfevent));
        pattern.setAverageCostInNeg(averageCostOfNegSeq);
        pattern.setAverageCostInPos(averageCostOfPosSeq);
        return correlation;
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  " + (Object)((Object)this.algorithmName) + " 2.42 STATISTICS =============");
        r.append(System.lineSeparator());
        r.append(" Pattern count : ");
        r.append(this.patternCount);
        r.append(System.lineSeparator());
        r.append(" Total time : ");
        r.append(this.endTime - this.startTime);
        r.append(" ms");
        r.append(System.lineSeparator());
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(System.lineSeparator());
        r.append("===================================================");
        r.append(System.lineSeparator());
        System.out.println(r.toString());
    }

    public void setUseLowerBound(boolean useLowerBound) {
        this.useLowerBound = useLowerBound;
    }

    static enum AlgorithmType {
        CEPB,
        CEPN,
        CORCEPB;

    }
}

