/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import java.util.ArrayList;
import java.util.List;

class PseudoSequence {
    private long timeShift;
    private Sequence sequence;
    private int firstItemset;
    private int firstItem;
    private int lastItemset;
    private int lastItem;

    public PseudoSequence(long timeShift, PseudoSequence sequence, int indexItemset, int indexItem) {
        this.timeShift = timeShift;
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
        this.lastItemset = sequence.lastItemset;
        this.lastItem = sequence.lastItem;
    }

    public PseudoSequence(long timeShift, PseudoSequence sequence, int indexItemset, int indexItem, int lastItemset, int lastItem) {
        this.timeShift = timeShift;
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
        this.lastItemset = lastItemset;
        this.lastItem = lastItem;
    }

    public PseudoSequence(long timeShift, Sequence sequence, int indexItemset, int indexItem) {
        this.timeShift = timeShift;
        this.sequence = sequence;
        this.firstItemset = indexItemset;
        this.firstItem = indexItem;
        this.lastItemset = sequence.size() - 1;
        this.lastItem = sequence.getItemsets().get(this.lastItemset).size() - 1;
    }

    public int size() {
        int size = this.sequence.size() - this.firstItemset - (this.sequence.size() - 1 - this.lastItemset);
        if (size == 1 && this.sequence.getItemsets().get(this.firstItemset).size() == 0) {
            return 0;
        }
        return size;
    }

    public int getSizeOfItemsetAt(int index) {
        int size = this.sequence.getItemsets().get(index + this.firstItemset).size();
        if (this.isLastItemset(index)) {
            size -= size - 1 - this.lastItem;
        }
        if (this.isFirstItemset(index)) {
            size -= this.firstItem;
        }
        return size;
    }

    boolean isCutAtRight(int index) {
        if (!this.isLastItemset(index)) {
            return false;
        }
        return this.sequence.getItemsets().get(index + this.firstItemset).size() - 1 != this.lastItem;
    }

    public boolean isCutAtLeft(int indexItemset) {
        return indexItemset == 0 && this.firstItem != 0;
    }

    public boolean isFirstItemset(int index) {
        return index == 0;
    }

    public boolean isLastItemset(int index) {
        return index + this.firstItemset == this.lastItemset;
    }

    public ItemSimple getItemAtInItemsetAt(int indexItem, int indexItemset) {
        if (this.isFirstItemset(indexItemset)) {
            return this.getItemset(indexItemset).get(indexItem + this.firstItem);
        }
        return this.getItemset(indexItemset).get(indexItem);
    }

    public long getTimeStamp(int indexItemset) {
        return this.getItemset(indexItemset).getTimestamp() - this.timeShift;
    }

    public long getAbsoluteTimeStamp(int indexItemset) {
        return this.getItemset(indexItemset).getTimestamp();
    }

    private Itemset getItemset(int index) {
        return this.sequence.get(index + this.firstItemset);
    }

    public int getId() {
        return this.sequence.getId();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            r.append("{t=");
            r.append(this.getTimeStamp(i));
            r.append(", ");
            int j = 0;
            while (j < this.getSizeOfItemsetAt(i)) {
                if (!this.isLastItemset(i) || j <= this.lastItem) {
                    r.append(this.getItemAtInItemsetAt(j, i).toString());
                    if (this.isCutAtLeft(i)) {
                        r.append('*');
                    }
                    r.append(' ');
                }
                ++j;
            }
            r.append("}");
            ++i;
        }
        r.append("  ");
        return r.toString();
    }

    public int indexOf(int indexItemset, int idItem) {
        int i = 0;
        while (i < this.getSizeOfItemsetAt(indexItemset)) {
            if (this.getItemAtInItemsetAt(i, indexItemset).getId() == idItem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    List<PseudoSequencePair> getAllInstancesOfPrefix(Sequence prefix, int i) {
        List<List<Position>> listInstances = this.getAllInstancesOfPrefixHelper(prefix, 0, new ArrayList<List<Position>>(), new ArrayList<Position>(), 0L, 0);
        ArrayList<PseudoSequencePair> allPairs = new ArrayList<PseudoSequencePair>();
        for (List<Position> listPositions : listInstances) {
            PseudoSequence newSequence = new PseudoSequence(0L, this, this.firstItemset, this.firstItem, listPositions.get((int)(i - 1)).itemset, listPositions.get((int)(i - 1)).item);
            allPairs.add(new PseudoSequencePair(newSequence, listPositions));
        }
        return allPairs;
    }

    List<List<Position>> getAllInstancesOfPrefixHelper(Sequence prefix, int indexItemset, List<List<Position>> allInstances, List<Position> listPositionsTotal, long itemsetShift, int decalageItemset) {
        int i = decalageItemset;
        while (i < this.size()) {
            boolean firstTime;
            boolean bl = firstTime = indexItemset == 0;
            if (firstTime || this.getTimeStamp(i) - itemsetShift == prefix.get(indexItemset).getTimestamp()) {
                int indexItem = 0;
                ArrayList<Position> listPositions = new ArrayList<Position>();
                int iDCourant = prefix.get(indexItemset).get(indexItem).getId();
                int j = 0;
                while (j < this.getSizeOfItemsetAt(i)) {
                    int id = this.getItemAtInItemsetAt(j, i).getId();
                    if (id == iDCourant) {
                        listPositions.add(new Position(i, j));
                        if (listPositions.size() + listPositionsTotal.size() == prefix.getItemOccurencesTotalCount()) {
                            ArrayList<Position> newList = new ArrayList<Position>(listPositionsTotal);
                            newList.addAll(listPositions);
                            allInstances.add(newList);
                        } else if (indexItem + 1 >= prefix.get(indexItemset).size()) {
                            long decalage = firstTime ? this.getTimeStamp(i) : itemsetShift;
                            ArrayList<Position> newList = new ArrayList<Position>(listPositionsTotal);
                            newList.addAll(listPositions);
                            if (indexItemset + 1 < prefix.size()) {
                                this.getAllInstancesOfPrefixHelper(prefix, indexItemset + 1, allInstances, newList, decalage, i + 1);
                            }
                        } else {
                            iDCourant = prefix.get(indexItemset).get(++indexItem).getId();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return allInstances;
    }

    PseudoSequencePair getLastInstanceOfPrefixSequence(Sequence prefix, int i) {
        List<PseudoSequencePair> list = this.getAllInstancesOfPrefix(prefix, i);
        PseudoSequencePair sequenceRetourPair = list.get(0);
        for (PseudoSequencePair sequencePair : list) {
            PseudoSequence sequence = sequencePair.pseudoSequence;
            PseudoSequence sequenceRetour = sequenceRetourPair.pseudoSequence;
            if (sequence.lastItemset <= sequenceRetour.lastItemset && (sequenceRetour.lastItemset != sequence.lastItemset || sequence.lastItem <= sequenceRetour.lastItem)) continue;
            sequenceRetourPair = sequencePair;
        }
        return sequenceRetourPair;
    }

    PseudoSequencePair getFirstInstanceOfPrefixSequence(Sequence prefix, int i) {
        List<PseudoSequencePair> list = this.getAllInstancesOfPrefix(prefix, i);
        PseudoSequencePair sequenceRetourPair = list.get(0);
        for (PseudoSequencePair sequencePair : list) {
            PseudoSequence sequence = sequencePair.pseudoSequence;
            PseudoSequence sequenceRetour = sequenceRetourPair.pseudoSequence;
            if (sequence.lastItemset >= sequenceRetour.lastItemset && (sequenceRetour.lastItemset != sequence.lastItemset || sequence.lastItem >= sequenceRetour.lastItem)) continue;
            sequenceRetourPair = sequencePair;
        }
        return sequenceRetourPair;
    }

    Position getIthLastInLastApearanceWithRespectToPrefix(Sequence prefix, int i, boolean withTimeStamps) {
        PseudoSequencePair lastInstancePair = this.getLastInstanceOfPrefixSequence(prefix, prefix.getItemOccurencesTotalCount());
        if (!withTimeStamps) {
            int iditem = prefix.getIthItem(i).getId();
            if (i == prefix.getItemOccurencesTotalCount() - 1) {
                int j = lastInstancePair.pseudoSequence.size() - 1;
                while (j >= 0) {
                    int k = lastInstancePair.pseudoSequence.getItemset(j).size() - 1;
                    while (k >= 0) {
                        if (lastInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).getId() == iditem) {
                            return new Position(j, k);
                        }
                        --k;
                    }
                    --j;
                }
            } else {
                Position LLiplus1 = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, i + 1, false);
                int j = LLiplus1.itemset;
                while (j >= 0) {
                    int k = lastInstancePair.pseudoSequence.getItemset(j).size() - 1;
                    while (k >= 0) {
                        if ((j != LLiplus1.itemset || k < LLiplus1.item) && lastInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).getId() == iditem) {
                            return new Position(j, k);
                        }
                        --k;
                    }
                    --j;
                }
            }
            return null;
        }
        return lastInstancePair.list.get(i);
    }

    PseudoSequence getIthMaximumPeriodOfAPrefix(Sequence prefix, int i, boolean withTimeStamps) {
        if (i == 0) {
            Position ithlastlast = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, 0, withTimeStamps);
            return this.trimBeginingAndEnd(null, ithlastlast);
        }
        PseudoSequencePair firstInstance = this.getFirstInstanceOfPrefixSequence(prefix, i);
        Position lastOfFirstInstance = firstInstance.list.get(i - 1);
        Position ithlastlast = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, i, withTimeStamps);
        return this.trimBeginingAndEnd(lastOfFirstInstance, ithlastlast);
    }

    List<PseudoSequence> getAllIthMaxPeriodOfAPrefix(Sequence prefix, int i, boolean b) {
        if (i == 0) {
            ArrayList<PseudoSequence> periods = new ArrayList<PseudoSequence>();
            for (PseudoSequencePair instance : this.getAllInstancesOfPrefix(prefix, prefix.getItemOccurencesTotalCount())) {
                PseudoSequence period = this.trimBeginingAndEnd(null, instance.list.get(0));
                periods.add(period);
            }
            return periods;
        }
        ArrayList<PseudoSequence> periods = new ArrayList<PseudoSequence>();
        for (PseudoSequencePair instance : this.getAllInstancesOfPrefix(prefix, i)) {
            PseudoSequence period = this.trimBeginingAndEnd(instance.list.get(i - 1), instance.list.get(i));
            periods.add(period);
        }
        return periods;
    }

    PseudoSequence trimBeginingAndEnd(Position positionStart, Position positionEnd) {
        int itemsetStart = 0;
        int itemStart = 0;
        int itemsetEnd = this.lastItemset;
        int itemEnd = this.lastItem;
        long newTimeStamp = 0L;
        if (positionStart != null) {
            itemStart = positionStart.item + 1;
            itemsetStart = positionStart.itemset;
            if (itemStart == this.getSizeOfItemsetAt(itemsetStart)) {
                ++itemsetStart;
                itemStart = 0;
            }
            if (itemsetStart == this.size()) {
                return null;
            }
            newTimeStamp = this.getTimeStamp(itemsetStart);
        }
        if (positionEnd != null) {
            itemsetEnd = positionEnd.itemset;
            itemEnd = positionEnd.item - 1;
            if (itemEnd < 0) {
                if (--itemsetEnd < itemsetStart) {
                    return null;
                }
                itemEnd = this.getSizeOfItemsetAt(itemsetEnd) - 1;
            }
        }
        if (itemsetEnd == itemsetStart && itemEnd < itemStart) {
            return null;
        }
        return new PseudoSequence(newTimeStamp, this, itemsetStart, itemStart, itemsetEnd, itemEnd);
    }

    long getTimeShift() {
        return this.timeShift;
    }

    long getTimeSucessor() {
        int positionLastElement = this.size() - 1;
        int absolutePositionLastElement = this.size() - 1 + this.firstItemset;
        if (this.isCutAtRight(positionLastElement)) {
            return this.getAbsoluteTimeStamp(positionLastElement);
        }
        if (absolutePositionLastElement < this.sequence.size() - 1) {
            return this.sequence.get(absolutePositionLastElement + 1).getTimestamp();
        }
        return 0L;
    }

    public long getTimePredecessor() {
        if (this.firstItemset == 0) {
            return 0L;
        }
        if (this.firstItem == 0) {
            return this.getAbsoluteTimeStamp(-1);
        }
        return this.getAbsoluteTimeStamp(0);
    }

    Position getIthLastInFirstApearanceWithRespectToPrefix(Sequence prefix, int i, boolean withTimestamps) {
        PseudoSequencePair firstInstancePair = this.getFirstInstanceOfPrefixSequence(prefix, prefix.getItemOccurencesTotalCount());
        if (!withTimestamps) {
            int iditem = prefix.getIthItem(i).getId();
            if (i == prefix.getItemOccurencesTotalCount() - 1) {
                int j = firstInstancePair.pseudoSequence.size() - 1;
                while (j >= 0) {
                    int k = firstInstancePair.pseudoSequence.getItemset(j).size() - 1;
                    while (k >= 0) {
                        if (firstInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).getId() == iditem) {
                            return new Position(j, k);
                        }
                        --k;
                    }
                    --j;
                }
            } else {
                Position LLiplus1 = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, i + 1, false);
                if (LLiplus1 == null) {
                    System.out.println("DEBUG");
                }
                int j = LLiplus1.itemset;
                while (j >= 0) {
                    int k = firstInstancePair.pseudoSequence.getItemset(j).size() - 1;
                    while (k >= 0) {
                        if ((j != LLiplus1.itemset || k < LLiplus1.item) && firstInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).getId() == iditem) {
                            return new Position(j, k);
                        }
                        --k;
                    }
                    --j;
                }
            }
            return null;
        }
        return firstInstancePair.list.get(i);
    }

    PseudoSequence getIthSemiMaximumPeriodOfAPrefix(Sequence prefix, int i, boolean withTimestamps) {
        if (i == 0) {
            Position ithlastfirst = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, 0, withTimestamps);
            return this.trimBeginingAndEnd(null, ithlastfirst);
        }
        PseudoSequencePair firstInstance = this.getFirstInstanceOfPrefixSequence(prefix, i);
        Position endOfFirstInstance = firstInstance.list.get(i - 1);
        Position ithlastfirst = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, i, withTimestamps);
        return this.trimBeginingAndEnd(endOfFirstInstance, ithlastfirst);
    }

    static class Position {
        final int itemset;
        final int item;

        public Position(int itemset2, int item) {
            this.itemset = itemset2;
            this.item = item;
        }
    }

    static class PseudoSequencePair {
        final PseudoSequence pseudoSequence;
        final List<Position> list;

        public PseudoSequencePair(PseudoSequence pseudoSequence, List<Position> list) {
            this.pseudoSequence = pseudoSequence;
            this.list = list;
        }
    }
}

