/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemValued;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08.AlgoKMeans_forFournier08;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08.Cluster;
import java.util.HashSet;
import java.util.List;

public class AlgoKMeansWithSupport {
    private int maxK;
    private int minsuppRelative;
    private final int numberOfTriesForEachK;
    private final AlgoKMeans_forFournier08 algoKMeans;

    public AlgoKMeansWithSupport(int maxK, int relativeMinsup, AlgoKMeans_forFournier08 algoKMeans, int numberOfTriesForEachK) {
        this.maxK = maxK;
        this.minsuppRelative = relativeMinsup;
        this.algoKMeans = algoKMeans;
        this.numberOfTriesForEachK = numberOfTriesForEachK;
        if (this.minsuppRelative <= 0) {
            this.minsuppRelative = 1;
        }
    }

    public AlgoKMeansWithSupport(int maxK, double minsup, int transactioncount, AlgoKMeans_forFournier08 algoKMeans, int numberOfTriesForEachK) {
        this.maxK = maxK;
        this.minsuppRelative = (int)Math.ceil(minsup * (double)transactioncount);
        this.algoKMeans = algoKMeans;
        this.numberOfTriesForEachK = numberOfTriesForEachK;
        if (this.minsuppRelative <= 0) {
            this.minsuppRelative = 1;
        }
    }

    public List<Cluster> runAlgorithm(List<ItemValued> items) {
        if (this.maxK > items.size()) {
            this.maxK = items.size();
        }
        int nbClustersFound = -1;
        List<Cluster> clustersFound = null;
        int k = 1;
        while (k <= this.maxK) {
            int j = 0;
            while (j < this.numberOfTriesForEachK) {
                this.algoKMeans.setK(k);
                List<Cluster> clusters = this.algoKMeans.runAlgorithm(items);
                int frequentClustersCount = 0;
                int i = 0;
                while (i < clusters.size()) {
                    if (this.isAFrequentCluster(clusters.get(i))) {
                        ++frequentClustersCount;
                        ++i;
                        continue;
                    }
                    clusters.remove(i);
                }
                if (frequentClustersCount > nbClustersFound) {
                    nbClustersFound = frequentClustersCount;
                    clustersFound = clusters;
                }
                ++j;
            }
            ++k;
        }
        for (ItemValued item : items) {
            for (Cluster cluster : clustersFound) {
                for (ItemValued item2 : cluster.getItems()) {
                    if (item != item2) continue;
                    item.setCluster(cluster);
                }
            }
        }
        return clustersFound;
    }

    private boolean isAFrequentCluster(Cluster cluster) {
        HashSet<Integer> sequenceIds = new HashSet<Integer>();
        for (ItemValued item : cluster.getItems()) {
            sequenceIds.add(item.getSequenceID());
        }
        return sequenceIds.size() >= this.minsuppRelative;
    }
}

