/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.qcsp;

import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.CountMap;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.FileStream;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.ListMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class QCSPData {
    private List<Integer> sequenceList;
    private List<String> labelsList;
    private CountMap<Integer> support;
    private List<Integer> itemsSortedOnAscendingSupport;
    private ListMap<Integer, Integer> itemPositions;
    private int NULL_ITEM = 0;
    private int SEPERATOR_ITEM = -1;
    private int END_ITEM = -2;

    public void loadData(File sequenceFile, File labelsFile, int minsup, double alpha, int maxsize, boolean debug) throws IOException {
        if (!sequenceFile.canRead()) {
            throw new IOException("QCSP could not read sequence file " + sequenceFile.getPath());
        }
        if (labelsFile != null && !labelsFile.canRead()) {
            throw new IOException("QCSP could not read labels file " + labelsFile.getPath());
        }
        try {
            this.labelsList = new ArrayList<String>();
            if (labelsFile != null) {
                FileStream fs2 = new FileStream(labelsFile, ' ', '\n');
                String label = fs2.nextToken();
                while (label != null) {
                    this.labelsList.add(label);
                    label = fs2.nextToken();
                }
            }
            FileStream fs = new FileStream(sequenceFile, ' ', '\n');
            String token = fs.nextToken();
            int sizeSequence = 0;
            while (token != null) {
                token = fs.nextToken();
                ++sizeSequence;
            }
            if (debug) {
                System.out.println("Sequence size: " + sizeSequence);
            }
            this.sequenceList = new ArrayList<Integer>(sizeSequence);
            fs = new FileStream(sequenceFile, ' ', '\n');
            token = fs.nextToken();
            while (token != null) {
                Integer item = Integer.parseInt(token);
                if (item == this.NULL_ITEM) {
                    this.sequenceList.add(null);
                    token = fs.nextToken();
                    continue;
                }
                if (item == this.SEPERATOR_ITEM) {
                    token = fs.nextToken();
                    continue;
                }
                if (item == this.END_ITEM) {
                    int i = 0;
                    while ((double)i < alpha * (double)maxsize) {
                        this.sequenceList.add(null);
                        ++i;
                    }
                    token = fs.nextToken();
                    continue;
                }
                this.sequenceList.add(item);
                token = fs.nextToken();
            }
            this.support = new CountMap();
            for (Integer item : this.sequenceList) {
                if (item == null) continue;
                this.support.add(item);
            }
            HashSet<Integer> infrequent = new HashSet<Integer>();
            for (Map.Entry<Integer, Integer> itemWithSupport : this.support.getMap().entrySet()) {
                if (itemWithSupport.getValue() >= minsup) continue;
                infrequent.add(itemWithSupport.getKey());
            }
            if (debug) {
                System.out.print("Removing infrequent items:");
            }
            for (Integer item : infrequent) {
                this.support.remove(item);
                if (!debug) continue;
                System.out.format("%d (%s), ", item, this.labelsList.size() > 0 ? this.labelsList.get(item - 1) : null);
            }
            if (debug) {
                System.out.println();
            }
            int i = 0;
            while (i < this.sequenceList.size()) {
                Integer next = this.sequenceList.get(i);
                if (infrequent.contains(next)) {
                    this.sequenceList.set(i, null);
                }
                ++i;
            }
            this.itemsSortedOnAscendingSupport = this.getItemsSorted(this.support, true);
            this.itemPositions = new ListMap();
            int idx = 0;
            while (idx < this.sequenceList.size()) {
                Integer item = this.sequenceList.get(idx);
                if (item != null) {
                    this.itemPositions.put(item, idx);
                }
                ++idx;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("QCSP error loading data", e);
        }
    }

    public List<Integer> getItemsSortedOnAscendingSupport() {
        return this.itemsSortedOnAscendingSupport;
    }

    public List<Integer> getSequence() {
        return this.sequenceList;
    }

    public int getSequenceSize() {
        return this.sequenceList.size();
    }

    public List<Integer> getPositions(Integer item) {
        return this.itemPositions.get(item);
    }

    public int support(Collection<Integer> items) {
        int support = 0;
        for (int item : items) {
            support += this.support.get(item);
        }
        return support;
    }

    public boolean hasLabels() {
        return !this.labelsList.isEmpty();
    }

    public List<Integer> getItemsSorted(CountMap<Integer> support, boolean ascending) {
        ArrayList<Map.Entry<Integer, Integer>> lst = new ArrayList<Map.Entry<Integer, Integer>>(support.getMap().entrySet());
        final int sign = ascending ? 1 : -1;
        Collections.sort(lst, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return sign * (o1.getValue() - o2.getValue());
            }
        });
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (Map.Entry entry : lst) {
            keys.add((Integer)entry.getKey());
        }
        return keys;
    }

    public String patternToString(List<Integer> X) {
        if (this.labelsList.isEmpty()) {
            throw new RuntimeException("No labels provided");
        }
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        int i = 0;
        while (i < X.size() - 1) {
            buff.append(this.labelsList.get(X.get(i) - 1));
            buff.append(",");
            ++i;
        }
        if (X.size() > 0) {
            Integer last = X.get(X.size() - 1);
            buff.append(this.labelsList.get(last - 1));
        }
        buff.append(")");
        return buff.toString();
    }
}

