/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static void printHead(File file, int max) throws IOException {
        System.out.println("====== HEAD " + file.getName() + "(#lines=" + Utils.countLines(file) + ") ========");
        List<String> lines = Utils.readFileUntil(file, max);
        for (String line : lines) {
            System.out.println(line);
        }
        long countL = Utils.countLines(file);
        if (countL > (long)max) {
            System.out.println("(" + (countL - (long)max) + " more ...");
        }
    }

    public static String milisToStringReadable(long milis) {
        if (milis < 1000L) {
            return String.format("%d ms", milis);
        }
        if (milis >= 1000L && milis < 60000L) {
            return String.format("%.1f sec", (double)milis / 1000.0);
        }
        if (milis >= 60000L && milis < 3600000L) {
            return String.format("%.1f min", (double)milis / 60000.0);
        }
        return String.format("%.2f h", (double)milis / 3600000.0);
    }

    public static void printHead(File file) throws IOException {
        System.out.println("====== HEAD " + file.getName() + "(#lines= " + Utils.countLines(file) + "0========");
        List<String> lines = Utils.readFileUntil(file, 10);
        for (String line : lines) {
            System.out.println(line);
        }
    }

    public static List<String> readFileUntil(File file, int lineNumber) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> lines = new ArrayList<String>();
        String current = reader.readLine();
        int line = 1;
        while (current != null) {
            lines.add(current);
            current = reader.readLine();
            if (++line >= lineNumber) break;
        }
        reader.close();
        return lines;
    }

    public static String getFilenameNoExtension(File file) {
        int idx = file.getName().lastIndexOf(".");
        if (idx == -1) {
            return file.getName();
        }
        return file.getName().substring(0, idx);
    }

    public static long countLines(File input) throws IOException {
        LineNumberReader lnr = new LineNumberReader(new FileReader(input));
        lnr.skip(Long.MAX_VALUE);
        long lines = lnr.getLineNumber();
        lnr.close();
        return lines;
    }
}

