/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.ItemsetRec;

public class BinPartition {
    private ItemsetRec irLeft;
    private ItemsetRec irRight;

    public BinPartition(ItemsetRec isParaLeft, ItemsetRec isParaRight) {
        if (this.lessThan(isParaLeft, isParaRight)) {
            this.irLeft = new ItemsetRec(isParaLeft);
            this.irRight = new ItemsetRec(isParaRight);
        } else {
            this.irLeft = new ItemsetRec(isParaRight);
            this.irRight = new ItemsetRec(isParaLeft);
        }
    }

    public ItemsetRec getLeft() {
        return this.irLeft;
    }

    public ItemsetRec getRight() {
        return this.irRight;
    }

    public boolean equals(Object obj) {
        return this.irLeft.equals(((BinPartition)obj).getLeft()) && this.irRight.equals(((BinPartition)obj).getRight());
    }

    public int hashCode() {
        return (String.valueOf(this.irLeft.hashCode()) + "|" + this.irRight.hashCode()).hashCode();
    }

    private boolean lessThan(ItemsetRec isParaLeft, ItemsetRec isParaRight) {
        assert (isParaLeft.size() > 0 && isParaRight.size() > 0);
        if (isParaLeft.size() < isParaRight.size()) {
            return true;
        }
        if (isParaLeft.size() == isParaRight.size()) {
            int i = 0;
            while (i < isParaLeft.size()) {
                int nr;
                int nl = (Integer)isParaLeft.get(i);
                if (nl < (nr = ((Integer)isParaRight.get(i)).intValue())) {
                    return true;
                }
                if (nl > nr) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

