/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.skopus;

import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.Combination;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.GlobalOper;
import java.util.ArrayList;

public class CombinTemplate
extends ArrayList<Byte[]> {
    private static final long serialVersionUID = -7394207193842094281L;
    private int nLeft = 0;
    private int nRight = 0;

    public CombinTemplate(int nLeftLength, int nRightLength) {
        super((int)Math.ceil(Math.exp(GlobalOper.log_combin(nLeftLength + nRightLength, nLeftLength))));
        if (nLeftLength <= nRightLength) {
            this.nLeft = nLeftLength;
            this.nRight = nRightLength;
        } else {
            this.nLeft = nRightLength;
            this.nRight = nLeftLength;
        }
        this.createAllTemplate();
    }

    private void createAllTemplate() {
        this.clear();
        Combination c = new Combination(this.nLeft + this.nRight, this.nLeft);
        while (c.hasNext()) {
            int[] a = c.next();
            Byte[] naTemplate = new Byte[this.nLeft + this.nRight];
            int i = 0;
            while (i < naTemplate.length) {
                naTemplate[i] = 1;
                ++i;
            }
            i = 0;
            while (i < a.length) {
                naTemplate[a[i]] = 0;
                ++i;
            }
            this.add(naTemplate);
        }
    }

    public int getLeftLength() {
        return this.nLeft;
    }

    public int getRightLength() {
        return this.nRight;
    }
}

