/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.EquivalenceClass;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.candidatePatternsGeneration.CandidateGenerator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.IDList;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.Saver;
import java.util.List;
import java.util.Map;

public class FrequentPatternEnumeration {
    private CandidateGenerator candidateGenerator;
    private double minSupportAbsolute;
    private static int frequentPatterns = 0;
    public static int INTERSECTION_COUNTER = 0;
    private Saver saver = null;

    public FrequentPatternEnumeration(CandidateGenerator candidateGenerator, double minSupportAbsolute, Saver saver) {
        INTERSECTION_COUNTER = 0;
        this.candidateGenerator = candidateGenerator;
        this.minSupportAbsolute = minSupportAbsolute;
        this.saver = saver;
    }

    public void execute(EquivalenceClass eq, boolean dfs, boolean keepPatterns, boolean verbose, Map<Integer, Map<Integer, Integer>> coocMapAfter, Map<Integer, Map<Integer, Integer>> coocMapEquals) {
        boolean anyPatternCreated = false;
        List<EquivalenceClass> eqMembers = eq.getClassMembers();
        int i = eqMembers.size() - 1;
        while (i >= 0) {
            EquivalenceClass child_X = eqMembers.get(i);
            Map<Integer, Integer> cmapX = null;
            Map<Integer, Integer> cmapX_equals = null;
            Integer itemX = null;
            if (coocMapAfter != null || coocMapEquals != null) {
                itemX = (Integer)child_X.getClassIdentifier().getLastElement().getItem().getId();
                cmapX = coocMapAfter == null ? null : coocMapAfter.get(itemX);
                cmapX_equals = coocMapEquals == null ? null : coocMapEquals.get(itemX);
            }
            int j = i;
            while (j >= 0) {
                Integer count2;
                Integer count1;
                Map<Integer, Integer> cmapY;
                Integer itemY;
                EquivalenceClass child_Y = eqMembers.get(j);
                boolean doNotExploreXY = false;
                boolean doNotExploreYX = false;
                boolean doNotExploreX_Y = false;
                boolean doNotExploreY_X = false;
                if (coocMapEquals != null) {
                    itemY = (Integer)child_Y.getClassIdentifier().getLastElement().getItem().getId();
                    cmapY = coocMapEquals.get(itemY);
                    count1 = cmapX_equals == null ? null : cmapX_equals.get(itemY);
                    count2 = cmapY == null ? null : cmapY.get(itemX);
                    doNotExploreYX = count2 == null || (double)count2.intValue() < this.minSupportAbsolute;
                    boolean bl = doNotExploreXY = count1 == null || (double)count1.intValue() < this.minSupportAbsolute;
                }
                if (coocMapAfter != null) {
                    itemY = (Integer)child_Y.getClassIdentifier().getLastElement().getItem().getId();
                    cmapY = coocMapAfter.get(itemY);
                    count1 = cmapX == null ? null : cmapX.get(itemY);
                    count2 = cmapY == null ? null : cmapY.get(itemX);
                    doNotExploreY_X = count2 == null || (double)count2.intValue() < this.minSupportAbsolute;
                    boolean bl = doNotExploreX_Y = count1 == null || (double)count1.intValue() < this.minSupportAbsolute;
                }
                if (!(doNotExploreXY && doNotExploreYX && doNotExploreX_Y && doNotExploreY_X)) {
                    List<Pattern> extensions = this.candidateGenerator.generateCandidates(child_X.getClassIdentifier(), child_Y.getClassIdentifier(), (int)this.minSupportAbsolute, doNotExploreXY, doNotExploreYX, doNotExploreX_Y, doNotExploreY_X);
                    for (Pattern extension : extensions) {
                        IDList newIdList = this.candidateGenerator.join(extension, child_X, child_Y, (int)this.minSupportAbsolute);
                        ++INTERSECTION_COUNTER;
                        if (newIdList == null || !((double)newIdList.getSupport() >= this.minSupportAbsolute)) continue;
                        anyPatternCreated = true;
                        newIdList.setAppearingSequences(extension);
                        if (keepPatterns) {
                            this.keepPattern(extension);
                        }
                        EquivalenceClass newEq = new EquivalenceClass(extension);
                        newEq.setIdList(newIdList);
                        FrequentPatternEnumeration.increaseFrequentPatterns();
                        this.insertClassByPrefix(newEq, child_X, child_Y);
                    }
                }
                --j;
            }
            if (dfs) {
                eqMembers.remove(i);
                if (anyPatternCreated) {
                    this.execute(child_X, dfs, keepPatterns, verbose, coocMapAfter, coocMapEquals);
                }
            }
            --i;
        }
        if (!dfs) {
            if (anyPatternCreated) {
                i = eqMembers.size() - 1;
                while (i >= 0) {
                    this.execute(eqMembers.get(i), dfs, keepPatterns, verbose, coocMapAfter, coocMapEquals);
                    eqMembers.remove(i);
                    --i;
                }
            }
            eqMembers = null;
        }
    }

    private void insertClassByPrefix(EquivalenceClass eq, EquivalenceClass eq_X, EquivalenceClass eq_Y) {
        if (eq_X.getClassIdentifier().isPrefix(eq.getClassIdentifier())) {
            eq_X.addClassMember(eq);
        } else {
            eq_Y.addClassMember(eq);
        }
    }

    public int getFrequentPatterns() {
        return frequentPatterns;
    }

    public void setFrequentPatterns(int patronesFrecuentes) {
        frequentPatterns = patronesFrecuentes;
    }

    private static synchronized void increaseFrequentPatterns() {
        ++frequentPatterns;
    }

    private synchronized void keepPattern(Pattern pattern) {
        this.saver.savePattern(pattern);
    }
}

