/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.IDList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class IDListFatBitmap
implements IDList {
    final int BIT_PER_SEQUENCE = 512;
    final int BIT_PER_ITEMSET = 64;
    private BitSet sequences;
    private List<BitSet> itemsetsOfSequences;
    private int support;

    public IDListFatBitmap() {
        this.sequences = new BitSet(512);
        this.itemsetsOfSequences = new ArrayList<BitSet>(512);
    }

    private IDListFatBitmap(BitSet sequences, List<BitSet> itemsets) {
        this.sequences = sequences;
        this.itemsetsOfSequences = (ArrayList)itemsets;
    }

    public void registerBit(int sid, int tid) {
        int bitIndex = tid;
        this.insertInSequence(sid);
        BitSet itemsetsFromSequence = this.itemsetsOfSequences.get(sid);
        if (itemsetsFromSequence == null) {
            itemsetsFromSequence = new BitSet(64);
            this.itemsetsOfSequences.set(sid, itemsetsFromSequence);
        }
        itemsetsFromSequence.set(bitIndex);
        this.support = this.sequences.cardinality();
    }

    public void registerNBits(int sid, List<Integer> tids) {
        this.insertInSequence(sid);
        this.support = this.sequences.cardinality();
        BitSet itemsetsFromSequence = this.itemsetsOfSequences.get(sid);
        if (itemsetsFromSequence == null) {
            itemsetsFromSequence = new BitSet(64);
            this.itemsetsOfSequences.set(sid, itemsetsFromSequence);
        }
        for (Integer tid : tids) {
            int bitIndex = tid;
            itemsetsFromSequence.set(bitIndex);
        }
    }

    @Override
    public int getSupport() {
        return this.support;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        return buffer.toString();
    }

    @Override
    public IDList join(IDList idList, boolean equals, int minSupport) {
        IDListFatBitmap result = new IDListFatBitmap();
        IDListFatBitmap idStandard = (IDListFatBitmap)idList;
        BitSet sequencesIdList = idStandard.sequences;
        List<BitSet> itemsetsIdList = idStandard.itemsetsOfSequences;
        if (equals) {
            this.equalLoop(result, sequencesIdList, itemsetsIdList, minSupport);
        } else {
            this.laterLoop(result, sequencesIdList, itemsetsIdList, minSupport);
        }
        return result;
    }

    @Override
    public void setAppearingSequences(Pattern pattern) {
        pattern.setAppearingIn(this.sequences);
    }

    @Override
    public void clear() {
    }

    public void addAppearancesInSequence(Integer sequence, List<Integer> itemsets) {
        this.registerNBits(sequence, itemsets);
    }

    private BitSet equalOperation(BitSet thisBitmap, BitSet otherBitmap) {
        if (thisBitmap != null) {
            BitSet result = (BitSet)thisBitmap.clone();
            result.and(otherBitmap);
            if (result.cardinality() > 0) {
                return result;
            }
        }
        return null;
    }

    private BitSet greaterThanOperation(BitSet thisBitmap, BitSet otherBitmap) {
        int index;
        BitSet result = (BitSet)otherBitmap.clone();
        if (thisBitmap != null && (index = thisBitmap.nextSetBit(0)) >= 0 && index < otherBitmap.length() - 1) {
            int newIndex = index + 1;
            result.clear(0, newIndex);
            if (result.nextSetBit(newIndex) > 0) {
                return result;
            }
        }
        return null;
    }

    private void equalLoop(IDListFatBitmap newIdList, BitSet sequencesFromIdList, List<BitSet> itemsetsFromIdList, int minSupport) {
        ArrayList itemsetIntersection = (ArrayList)newIdList.getItemsets();
        BitSet sequencesIntersection = (BitSet)this.sequences.clone();
        sequencesIntersection.and(sequencesFromIdList);
        this.setSize(itemsetIntersection, sequencesIntersection.length());
        newIdList.setSupport(sequencesIntersection.cardinality());
        if (newIdList.getSupport() >= minSupport) {
            newIdList.setSequences(sequencesIntersection);
            int i = sequencesIntersection.nextSetBit(0);
            while (i >= 0) {
                BitSet otherItemset = itemsetsFromIdList.get(i);
                BitSet thisItemset = this.itemsetsOfSequences.get(i);
                if (thisItemset != null) {
                    BitSet equalResult = null;
                    equalResult = this.equalOperation(thisItemset, otherItemset);
                    if (equalResult != null) {
                        itemsetIntersection.set(i, equalResult);
                    } else {
                        sequencesIntersection.clear(i);
                        newIdList.decreaseSupport();
                    }
                }
                i = sequencesIntersection.nextSetBit(i + 1);
            }
        }
    }

    private void laterLoop(IDListFatBitmap newIdList, BitSet sequencesFromIdList, List<BitSet> itemsetsFromIdList, int minSupport) {
        ArrayList itemsetIntersection = (ArrayList)newIdList.getItemsets();
        BitSet sequenceIntersection = (BitSet)this.sequences.clone();
        sequenceIntersection.and(sequencesFromIdList);
        this.setSize(itemsetIntersection, sequenceIntersection.length());
        newIdList.setSupport(sequenceIntersection.cardinality());
        if (newIdList.getSupport() >= minSupport) {
            newIdList.setSequences(sequenceIntersection);
            int i = sequenceIntersection.nextSetBit(0);
            while (i >= 0) {
                BitSet otherItemset = itemsetsFromIdList.get(i);
                BitSet thisItemset = this.itemsetsOfSequences.get(i);
                if (thisItemset != null) {
                    BitSet greaterThanResult = null;
                    greaterThanResult = this.greaterThanOperation(thisItemset, otherItemset);
                    if (greaterThanResult != null) {
                        itemsetIntersection.set(i, greaterThanResult);
                    } else {
                        sequenceIntersection.clear(i);
                        newIdList.decreaseSupport();
                    }
                }
                i = sequenceIntersection.nextSetBit(i + 1);
            }
        }
    }

    private List<BitSet> getItemsets() {
        return this.itemsetsOfSequences;
    }

    private void setSupport(int support) {
        this.support = support;
    }

    private void decreaseSupport() {
        --this.support;
    }

    private void increaseSupport() {
        ++this.support;
    }

    private void insertInSequence(int sid) {
        this.sequences.set(sid);
        int currentSize = this.itemsetsOfSequences.size();
        int last = sid + 1;
        if (currentSize < last) {
            while (currentSize < last) {
                this.itemsetsOfSequences.add(null);
                ++currentSize;
            }
        }
    }

    private void setSequences(BitSet sequences) {
        this.sequences = sequences;
    }

    private void setSize(List<BitSet> list, int length) {
        block3: {
            int dif;
            block2: {
                dif = list.size() - length;
                if (dif <= 0) break block2;
                int index = list.size() - 1;
                int i = 0;
                while (i < dif) {
                    list.remove(index);
                    --index;
                    ++i;
                }
                break block3;
            }
            if (dif >= 0) break block3;
            int amountOfNulls = -1 * dif;
            int i = 0;
            while (i < amountOfNulls) {
                list.add(null);
                ++i;
            }
        }
    }

    private BitSet equalOperation(BitSet thisItemset, BitSet otherItemset, int temporalDistance) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

