/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.IDList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IDListStandard_Map
implements IDList {
    Map<Integer, List<Integer>> itemsetSequenceEntries;
    BitSet sequences;

    public IDListStandard_Map() {
        this.itemsetSequenceEntries = new HashMap<Integer, List<Integer>>();
        this.sequences = new BitSet();
    }

    public IDListStandard_Map(Map<Integer, List<Integer>> itemsetSequenceEntries) {
        this.itemsetSequenceEntries = itemsetSequenceEntries;
        this.sequences = new BitSet(itemsetSequenceEntries.size());
    }

    @Override
    public IDList join(IDList idList, boolean equals, int minSupport) {
        HashMap<Integer, List<Integer>> intersection = new HashMap<Integer, List<Integer>>(((IDListStandard_Map)idList).getSequenceItemsetEntries().size());
        BitSet newSequences = new BitSet(idList.getSupport());
        IDListStandard_Map idStandard = (IDListStandard_Map)idList;
        Map<Integer, List<Integer>> idListMap = idStandard.getSequenceItemsetEntries();
        Set<Map.Entry<Integer, List<Integer>>> entries = idListMap.entrySet();
        for (Map.Entry<Integer, List<Integer>> entry : entries) {
            List<Integer> transactionAppearancesInSequence = entry.getValue();
            List<Integer> transactionAppearances = null;
            int sid = entry.getKey();
            transactionAppearances = equals ? this.equalOperation(sid, transactionAppearancesInSequence) : this.laterOperation(sid, transactionAppearancesInSequence);
            if (transactionAppearances == null) continue;
            intersection.put(sid, transactionAppearances);
            newSequences.set(sid);
        }
        IDListStandard_Map output = new IDListStandard_Map(intersection);
        output.sequences = newSequences;
        return output;
    }

    public Map<Integer, List<Integer>> getSequenceItemsetEntries() {
        return this.itemsetSequenceEntries;
    }

    private List<Integer> laterOperation(Integer sid, List<Integer> transactionAppearancesInSequence) {
        List<Integer> transactionAppearancesInSequenceOfMyIdList = this.itemsetSequenceEntries.get(sid);
        if (transactionAppearancesInSequenceOfMyIdList == null || transactionAppearancesInSequenceOfMyIdList.isEmpty()) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = -1;
        int i = 0;
        while (i < transactionAppearancesInSequence.size() && index < 0) {
            int eid = transactionAppearancesInSequence.get(i);
            if (transactionAppearancesInSequenceOfMyIdList.get(0) < eid) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            i = index;
            while (i < transactionAppearancesInSequence.size()) {
                result.add(transactionAppearancesInSequence.get(i));
                ++i;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private List<Integer> equalOperation(Integer sid, List<Integer> transactionAppearancesInSequence) {
        List<Integer> listToSearch;
        List<Integer> listToExplore;
        List<Integer> transactionAppearancesInSequenceOfMyIdList = this.itemsetSequenceEntries.get(sid);
        if (transactionAppearancesInSequenceOfMyIdList == null || transactionAppearancesInSequenceOfMyIdList.isEmpty()) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int beginningIndex = 0;
        if (transactionAppearancesInSequenceOfMyIdList.size() <= transactionAppearancesInSequence.size()) {
            listToExplore = transactionAppearancesInSequenceOfMyIdList;
            listToSearch = transactionAppearancesInSequence;
        } else {
            listToExplore = transactionAppearancesInSequence;
            listToSearch = transactionAppearancesInSequenceOfMyIdList;
        }
        block0: for (Integer eid : listToExplore) {
            int i = beginningIndex;
            while (i < listToSearch.size()) {
                int comparison = listToSearch.get(i).compareTo(eid);
                if (comparison >= 0) {
                    if (comparison != 0) continue block0;
                    result.add(eid);
                    beginningIndex = i + 1;
                    continue block0;
                }
                ++i;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public int getSupport() {
        return this.sequences.cardinality();
    }

    public void addAppearance(Integer sequence, Integer timestamp) {
        List<Integer> transactionAppearancesInSequenceOfMyIdList = this.itemsetSequenceEntries.get(sequence);
        if (transactionAppearancesInSequenceOfMyIdList == null) {
            transactionAppearancesInSequenceOfMyIdList = new ArrayList<Integer>();
        }
        if (!transactionAppearancesInSequenceOfMyIdList.contains(timestamp)) {
            transactionAppearancesInSequenceOfMyIdList.add(timestamp);
            this.itemsetSequenceEntries.put(sequence, transactionAppearancesInSequenceOfMyIdList);
            this.sequences.set(sequence);
        }
    }

    public void addAppearancesInSequence(Integer sid, List<Integer> itemsets) {
        List<Integer> transactionAppearancesInSequenceOfMyIdList = this.itemsetSequenceEntries.get(sid);
        if (transactionAppearancesInSequenceOfMyIdList == null) {
            transactionAppearancesInSequenceOfMyIdList = itemsets;
        }
        this.itemsetSequenceEntries.put(sid, transactionAppearancesInSequenceOfMyIdList);
        this.sequences.set(sid);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        Set<Map.Entry<Integer, List<Integer>>> entries = this.itemsetSequenceEntries.entrySet();
        for (Map.Entry<Integer, List<Integer>> entry : entries) {
            result.append("\t").append(entry.getKey()).append(" {");
            List<Integer> eids = entry.getValue();
            for (Integer i : eids) {
                result.append(i).append(",");
            }
            result.deleteCharAt(result.length() - 1);
            result.append("}\n");
        }
        return result.toString();
    }

    @Override
    public void setAppearingSequences(Pattern pattern) {
        pattern.setAppearingIn(this.sequences);
    }

    @Override
    public void clear() {
        this.itemsetSequenceEntries.clear();
        this.sequences.clear();
    }
}

