/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.PatternVMSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.PrefixVMSP;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class AlgoVMSP {
    public long startTime;
    public long endTime;
    public int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    private int maximumPatternLength = 1000;
    Map<Integer, Map<Integer, Integer>> coocMapAfter = null;
    Map<Integer, Map<Integer, Integer>> coocMapEquals = null;
    Map<Integer, Short> lastItemPositionMap;
    boolean useCMAPPruning = true;
    boolean useLastPositionPruning = false;
    List<TreeSet<PatternVMSP>> maxPatterns = null;
    private boolean useStrategyForwardExtensionChecking = true;
    private int maxGap = Integer.MAX_VALUE;
    private boolean outputSequenceIdentifiers;
    private boolean DEBUG = false;

    public List<TreeSet<PatternVMSP>> runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        Bitmap.INTERSECTION_COUNT = 0L;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.vmsp(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writeResultTofile(outputFilePath);
        this.writer.close();
        return this.maxPatterns;
    }

    private void vmsp(String input, double minsupRel) throws IOException {
        int item;
        int i;
        BufferedReader reader;
        FileInputStream fin;
        this.maxPatterns = new ArrayList<TreeSet<PatternVMSP>>(20);
        this.maxPatterns.add(null);
        this.maxPatterns.add(new TreeSet());
        this.verticalDB = new HashMap<Integer, Bitmap>();
        ArrayList<int[]> inMemoryDB = new ArrayList<int[]>();
        if (this.DEBUG) {
            System.out.println(" == HORIZONTAL DATABASE ==");
        }
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            String string;
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int bitIndex = 0;
            while ((string = reader.readLine()) != null) {
                if (string.isEmpty() || string.charAt(0) == '#' || string.charAt(0) == '%' || string.charAt(0) == '@') continue;
                this.sequencesSize.add(bitIndex);
                String[] tokens = string.split(" ");
                int[] transactionArray = new int[tokens.length];
                inMemoryDB.add(transactionArray);
                i = 0;
                while (i < tokens.length) {
                    transactionArray[i] = item = Integer.parseInt(tokens[i]);
                    if (item == -1) {
                        ++bitIndex;
                    }
                    ++i;
                }
                if (!this.DEBUG) continue;
                System.out.println(" " + Arrays.toString(transactionArray));
            }
            this.lastBitIndex = bitIndex - 1;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsup = (int)Math.ceil(minsupRel * (double)this.sequencesSize.size());
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        try {
            String string;
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int sid = 0;
            int tid = 0;
            while ((string = reader.readLine()) != null) {
                if (string.isEmpty() || string.charAt(0) == '#' || string.charAt(0) == '%' || string.charAt(0) == '@') continue;
                String[] stringArray = string.split(" ");
                item = stringArray.length;
                i = 0;
                while (i < item) {
                    String token = stringArray[i];
                    if (token.equals("-1")) {
                        ++tid;
                    } else if (token.equals("-2")) {
                        ++sid;
                        tid = 0;
                    } else {
                        Integer item2 = Integer.parseInt(token);
                        Bitmap bitmapItem = this.verticalDB.get(item2);
                        if (bitmapItem == null) {
                            bitmapItem = new Bitmap(this.lastBitIndex);
                            this.verticalDB.put(item2, bitmapItem);
                        }
                        bitmapItem.registerBit(sid, tid, this.sequencesSize);
                    }
                    ++i;
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            if (entry.getValue().getSupport() < this.minsup) {
                iter.remove();
                continue;
            }
            frequentItems.add(entry.getKey());
        }
        if (this.DEBUG) {
            System.out.println(" == VERTICAL DATABASE ==");
            for (Map.Entry<Integer, Bitmap> entry : this.verticalDB.entrySet()) {
                System.out.print(" item " + entry.getKey());
                System.out.println(" bitmap " + entry.getValue().bitmap);
            }
            System.out.println(" =======================");
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return AlgoVMSP.this.verticalDB.get(arg0).getSupport() - AlgoVMSP.this.verticalDB.get(arg1).getSupport();
            }
        });
        if (this.DEBUG) {
            System.out.println(" == Order of items ==");
            System.out.println(frequentItems);
            System.out.println(" ====================");
        }
        this.coocMapEquals = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        this.coocMapAfter = new HashMap<Integer, Map<Integer, Integer>>(frequentItems.size());
        if (this.useLastPositionPruning) {
            this.lastItemPositionMap = new HashMap<Integer, Short>(frequentItems.size());
        }
        for (int[] nArray : inMemoryDB) {
            short itemsetCount = 0;
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            HashMap equalProcessed = new HashMap();
            int i2 = 0;
            while (i2 < nArray.length) {
                block49: {
                    Integer itemI = nArray[i2];
                    HashSet<Integer> equalSet = (HashSet<Integer>)equalProcessed.get(itemI);
                    if (equalSet == null) {
                        equalSet = new HashSet<Integer>();
                        equalProcessed.put(itemI, equalSet);
                    }
                    if (itemI < 0) {
                        itemsetCount = (short)(itemsetCount + 1);
                    } else {
                        Bitmap bitmapOfItem;
                        Short last;
                        if (this.useLastPositionPruning && ((last = this.lastItemPositionMap.get(itemI)) == null || last < itemsetCount)) {
                            this.lastItemPositionMap.put(itemI, itemsetCount);
                        }
                        if ((bitmapOfItem = this.verticalDB.get(itemI)) != null && bitmapOfItem.getSupport() >= this.minsup) {
                            HashSet<Integer> alreadyProcessedB = new HashSet<Integer>();
                            boolean sameItemset = true;
                            int j = i2 + 1;
                            while (j < nArray.length) {
                                Integer itemJ = nArray[j];
                                if (itemJ < 0) {
                                    sameItemset = false;
                                } else {
                                    Bitmap bitmapOfitemJ = this.verticalDB.get(itemJ);
                                    if (bitmapOfitemJ != null && bitmapOfitemJ.getSupport() >= this.minsup) {
                                        Integer support;
                                        Map<Integer, Integer> map = null;
                                        if (sameItemset) {
                                            if (!equalSet.contains(itemJ)) {
                                                map = this.coocMapEquals.get(itemI);
                                                if (map == null) {
                                                    map = new HashMap<Integer, Integer>();
                                                    this.coocMapEquals.put(itemI, map);
                                                }
                                                if ((support = map.get(itemJ)) == null) {
                                                    map.put(itemJ, 1);
                                                } else {
                                                    support = support + 1;
                                                    map.put(itemJ, support);
                                                }
                                                equalSet.add(itemJ);
                                            }
                                        } else if (!alreadyProcessedB.contains(itemJ)) {
                                            if (alreadyProcessed.contains(itemI)) break block49;
                                            map = this.coocMapAfter.get(itemI);
                                            if (map == null) {
                                                map = new HashMap<Integer, Integer>();
                                                this.coocMapAfter.put(itemI, map);
                                            }
                                            if ((support = map.get(itemJ)) == null) {
                                                map.put(itemJ, 1);
                                            } else {
                                                support = support + 1;
                                                map.put(itemJ, support);
                                            }
                                            alreadyProcessedB.add(itemJ);
                                        }
                                    }
                                }
                                ++j;
                            }
                            alreadyProcessed.add(itemI);
                        }
                    }
                }
                ++i2;
            }
        }
        for (Map.Entry entry : this.verticalDB.entrySet()) {
            boolean itemIsEven;
            PrefixVMSP prefix = new PrefixVMSP();
            prefix.addItemset(new Itemset((Integer)entry.getKey()));
            boolean bl = itemIsEven = (Integer)entry.getKey() % 2 == 0;
            if (itemIsEven) {
                prefix.sumOfEvenItems = (Integer)entry.getKey();
                prefix.sumOfOddItems = 0;
            } else {
                prefix.sumOfEvenItems = 0;
                prefix.sumOfOddItems = (Integer)entry.getKey();
            }
            boolean hasExtension = false;
            if (this.maximumPatternLength > 1) {
                hasExtension = this.dfsPruning(prefix, (Bitmap)entry.getValue(), frequentItems, frequentItems, (Integer)entry.getKey(), 2, (Integer)entry.getKey());
            }
            if (hasExtension) continue;
            this.savePatternSingleItem((Integer)entry.getKey(), (Bitmap)entry.getValue(), itemIsEven);
        }
    }

    boolean dfsPruning(PrefixVMSP prefix, Bitmap prefixBitmap, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, int m, Integer lastAppendedItem) throws IOException {
        boolean atLeastOneFrequentExtension = false;
        if (this.DEBUG) {
            System.out.println("PREFIX: " + prefix.toString() + "  sn=" + sn + " in=" + in);
        }
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        Map<Integer, Integer> mapSupportItemsAfter = this.coocMapAfter.get(lastAppendedItem);
        for (Integer i : sn) {
            Integer support;
            if (this.useCMAPPruning && (mapSupportItemsAfter == null || (support = mapSupportItemsAfter.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex, this.maxGap);
            if (newBitmap.getSupportWithoutGapTotal() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        int k = 0;
        while (k < sTemp.size()) {
            int item = (Integer)sTemp.get(k);
            PrefixVMSP prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            if (item % 2 == 0) {
                prefixSStep.sumOfEvenItems = item + prefix.sumOfEvenItems;
                prefixSStep.sumOfOddItems = prefix.sumOfOddItems;
            } else {
                prefixSStep.sumOfEvenItems = prefix.sumOfEvenItems;
                prefixSStep.sumOfOddItems = item + prefix.sumOfOddItems;
            }
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            if (newBitmap.getSupport() >= this.minsup) {
                boolean hasFrequentExtension = false;
                if (this.maximumPatternLength > m) {
                    hasFrequentExtension = this.dfsPruning(prefixSStep, newBitmap, sTemp, sTemp, item, m + 1, item);
                }
                if (!hasFrequentExtension) {
                    atLeastOneFrequentExtension = true;
                    this.savePatternMultipleItems(prefixSStep, newBitmap, m);
                }
            }
            ++k;
        }
        Map<Integer, Integer> mapSupportItemsEquals = this.coocMapEquals.get(lastAppendedItem);
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : in) {
            Integer support;
            if (i <= hasToBeGreaterThanForIStep || this.useCMAPPruning && (mapSupportItemsEquals == null || (support = mapSupportItemsEquals.get(i)) == null || support < this.minsup)) continue;
            ++Bitmap.INTERSECTION_COUNT;
            Bitmap newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        int k2 = 0;
        while (k2 < iTemp.size()) {
            int item = (Integer)iTemp.get(k2);
            PrefixVMSP prefixIStep = prefix.cloneSequence();
            ((Itemset)prefixIStep.getItemsets().get(prefixIStep.size() - 1)).addItem(item);
            if (item % 2 == 0) {
                prefixIStep.sumOfEvenItems = item + prefix.sumOfEvenItems;
                prefixIStep.sumOfOddItems = prefix.sumOfOddItems;
            } else {
                prefixIStep.sumOfEvenItems = prefix.sumOfEvenItems;
                prefixIStep.sumOfOddItems = item + prefix.sumOfOddItems;
            }
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k2);
            boolean hasFrequentExtension = false;
            if (this.maximumPatternLength > m) {
                hasFrequentExtension = this.dfsPruning(prefixIStep, newBitmap, sTemp, iTemp, item, m + 1, item);
            }
            if (!hasFrequentExtension) {
                atLeastOneFrequentExtension = true;
                this.savePatternMultipleItems(prefixIStep, newBitmap, m);
            }
            ++k2;
        }
        MemoryLogger.getInstance().checkMemory();
        return atLeastOneFrequentExtension || !this.useStrategyForwardExtensionChecking;
    }

    private boolean savePatternSingleItem(Integer item, Bitmap bitmap, boolean itemIsEven) throws IOException {
        int i;
        if (this.DEBUG) {
            System.out.println("Trying to save : " + item);
        }
        if (itemIsEven) {
            i = this.maxPatterns.size() - 1;
            while (i > 1) {
                for (PatternVMSP pPrime : this.maxPatterns.get(i)) {
                    if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems < item) break;
                    if (pPrime.prefix.sumOfEvenItems < item || bitmap.getSupport() < pPrime.support || !pPrime.prefix.containsItem(item)) continue;
                    return true;
                }
                --i;
            }
        } else {
            i = this.maxPatterns.size() - 1;
            while (i > 1) {
                for (PatternVMSP pPrime : this.maxPatterns.get(i)) {
                    if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems < item) break;
                    if (pPrime.prefix.sumOfOddItems <= item || bitmap.getSupport() < pPrime.support || !pPrime.prefix.containsItem(item)) continue;
                    return true;
                }
                --i;
            }
        }
        ++this.patternCount;
        PrefixVMSP prefix = new PrefixVMSP();
        prefix.addItemset(new Itemset(item));
        if (itemIsEven) {
            prefix.sumOfEvenItems = item;
            prefix.sumOfOddItems = 0;
        } else {
            prefix.sumOfEvenItems = 0;
            prefix.sumOfOddItems = item;
        }
        PatternVMSP pattern = new PatternVMSP(prefix, bitmap.getSupport());
        if (this.outputSequenceIdentifiers) {
            pattern.bitmap = bitmap;
        }
        this.maxPatterns.get(1).add(pattern);
        if (this.DEBUG) {
            System.out.println(" saved");
        }
        return false;
    }

    private boolean savePatternMultipleItems(PrefixVMSP prefix, Bitmap bitmap, int length) throws IOException {
        if (this.DEBUG) {
            System.out.println("*Trying to save : " + prefix);
        }
        int i = this.maxPatterns.size() - 1;
        while (i > length) {
            for (PatternVMSP pPrime : this.maxPatterns.get(i)) {
                if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems < prefix.sumOfOddItems + prefix.sumOfEvenItems) break;
                if (prefix.sumOfEvenItems > pPrime.prefix.sumOfEvenItems || prefix.sumOfOddItems > pPrime.prefix.sumOfOddItems || bitmap.getSupport() < pPrime.support || !this.strictlyContains(pPrime.prefix, prefix)) continue;
                return true;
            }
            --i;
        }
        i = 1;
        while (i < length && i < this.maxPatterns.size()) {
            Iterator<PatternVMSP> iter = this.maxPatterns.get(i).descendingIterator();
            while (iter.hasNext()) {
                PatternVMSP pPrime = iter.next();
                if (pPrime.prefix.sumOfOddItems + pPrime.prefix.sumOfEvenItems >= prefix.sumOfOddItems + prefix.sumOfEvenItems) break;
                if (prefix.sumOfEvenItems < pPrime.prefix.sumOfEvenItems || prefix.sumOfOddItems < pPrime.prefix.sumOfOddItems || bitmap.getSupport() > pPrime.support || !this.strictlyContains(prefix, pPrime.prefix)) continue;
                --this.patternCount;
                if (this.DEBUG) {
                    System.out.println("REMOVE : " + pPrime.prefix);
                }
                iter.remove();
            }
            ++i;
        }
        while (this.maxPatterns.size() - 1 < length) {
            this.maxPatterns.add(new TreeSet());
        }
        TreeSet<PatternVMSP> patternsOfSizeM = this.maxPatterns.get(length);
        ++this.patternCount;
        PatternVMSP pattern = new PatternVMSP(prefix, bitmap.getSupport());
        if (this.outputSequenceIdentifiers) {
            pattern.bitmap = bitmap;
        }
        patternsOfSizeM.add(pattern);
        if (this.DEBUG) {
            System.out.println(" saved");
        }
        return false;
    }

    boolean strictlyContains(PrefixVMSP pattern1, PrefixVMSP pattern2) {
        int i = 0;
        int j = 0;
        do {
            if (pattern1.get(j).containsAll(pattern2.get(i)) && ++i == pattern2.size()) {
                return true;
            }
            if (++j < pattern1.size()) continue;
            return false;
        } while (pattern1.size() - j >= pattern2.size() - i);
        return false;
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  VMSP v0.97 - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("minsup " + this.minsup);
        r.append('\n');
        r.append("Intersection count " + Bitmap.INTERSECTION_COUNT + " \n");
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void writeResultTofile(String path) throws IOException {
        for (TreeSet<PatternVMSP> tree : this.maxPatterns) {
            if (tree == null) continue;
            for (PatternVMSP pattern : tree) {
                StringBuilder r = new StringBuilder("");
                for (Itemset itemset2 : pattern.prefix.getItemsets()) {
                    for (Integer item : itemset2.getItems()) {
                        String string = item.toString();
                        r.append(string);
                        r.append(' ');
                    }
                    r.append("-1 ");
                }
                r.append("#SUP: ");
                r.append(pattern.support);
                if (this.outputSequenceIdentifiers) {
                    r.append(" #SID: ");
                    r.append(pattern.bitmap.getSIDs(this.sequencesSize));
                }
                this.writer.write(r.toString());
                this.writer.newLine();
            }
        }
    }

    public void setMaxGap(int maxGap) {
        this.maxGap = maxGap;
    }

    public void showSequenceIdentifiersInOutput(boolean showSequenceIdentifiers) {
        this.outputSequenceIdentifiers = showSequenceIdentifiers;
    }
}

