/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.autocorrelation;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoLagAutoCorrelation {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries, int maxlag) throws IOException {
        if (maxlag < 1 || maxlag > timeSeries.size()) {
            throw new IllegalArgumentException(" The maxlag parameter must be set as follows:  1 <= maxlag <= timeSeries.length");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] resultingTimeSeriesArray = this.calculateAutocorrelationTimeSeries(timeSeries.data, maxlag);
        TimeSeries resultingTimeSeries = new TimeSeries(resultingTimeSeriesArray, String.valueOf(timeSeries.getName()) + "_AUTOCOR");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return resultingTimeSeries;
    }

    private double[] calculateAutocorrelationTimeSeries(double[] timeSeries, int maxlag) {
        double[] autocorrelationResult = new double[maxlag + 1];
        autocorrelationResult[0] = 1.0;
        double mean = 0.0;
        int i = 0;
        while (i < timeSeries.length) {
            mean += timeSeries[i];
            ++i;
        }
        mean /= (double)timeSeries.length;
        double denominator = 0.0;
        int i2 = 0;
        while (i2 < timeSeries.length) {
            denominator += Math.pow(timeSeries[i2] - mean, 2.0);
            ++i2;
        }
        int k = 1;
        while (k <= maxlag) {
            double numerator = 0.0;
            int i3 = 0;
            while (i3 < timeSeries.length - k) {
                numerator += (timeSeries[i3] - mean) * (timeSeries[i3 + k] - mean);
                ++i3;
            }
            autocorrelationResult[k] = numerator / denominator;
            ++k;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Minlag = " + maxlag);
            System.out.println(" Exponential smoothing transformation: " + Arrays.toString(autocorrelationResult));
        }
        return autocorrelationResult;
    }

    public void printStats() {
        System.out.println("=============  Transform to lag k autocorrelation time series v2.21- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

