/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.mediansmoothing;

import ca.pfv.spmf.algorithms.sort.Select;
import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoMedianSmoothing {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries, int windowSize) throws IOException {
        if (windowSize >= timeSeries.data.length || windowSize < 2) {
            throw new IllegalArgumentException(" The window size must be greater than 1, and no larger than the number of points in the time series");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] movingMedianData = windowSize % 2 == 1 ? this.calculateMedianSmoothingOdd(timeSeries.data, windowSize) : this.calculateMedianSmoothingEven(timeSeries.data, windowSize);
        TimeSeries medianSmoothing = new TimeSeries(movingMedianData, String.valueOf(timeSeries.getName()) + "_CEMEDSMT");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return medianSmoothing;
    }

    private double[] calculateMedianSmoothingOdd(double[] timeSeries, int windowSize) {
        int alpha = (windowSize - 1) / 2;
        double[] medianSmoothing = new double[timeSeries.length - (windowSize - 1)];
        double[] window = new double[windowSize];
        int i = alpha;
        while (i < timeSeries.length - alpha) {
            int smoothingPosition = i - alpha;
            System.arraycopy(timeSeries, smoothingPosition, window, 0, windowSize);
            medianSmoothing[smoothingPosition] = Select.randomizedSelect(window, alpha);
            ++i;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Window size = " + windowSize);
            System.out.println(" Median smoothing transformation: " + Arrays.toString(medianSmoothing));
        }
        return medianSmoothing;
    }

    private double[] calculateMedianSmoothingEven(double[] timeSeries, int windowSize) {
        int alpha = (windowSize - 2) / 2;
        double[] medianSmoothing = new double[timeSeries.length - (windowSize - 2) - 1];
        double[] window = new double[windowSize];
        int i = alpha;
        while (i < timeSeries.length - alpha - 1) {
            int smoothingPosition = i - alpha;
            System.arraycopy(timeSeries, smoothingPosition, window, 0, windowSize);
            double leftMiddle = Select.randomizedSelect(window, alpha);
            double rightMiddle = Select.randomizedSelect(window, alpha + 1);
            medianSmoothing[smoothingPosition] = (leftMiddle + rightMiddle) / 2.0;
            ++i;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Window size = " + windowSize);
            System.out.println(" Median smoothing transformation: " + Arrays.toString(medianSmoothing));
        }
        return medianSmoothing;
    }

    public void printStats() {
        System.out.println("=============  Transform to Median Smoothing v2.25 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

