/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.paa;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoPiecewiseAggregateApproximation {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries, int numberOfSegments) throws IOException {
        if (timeSeries.data.length < numberOfSegments) {
            throw new IllegalArgumentException(" The number of segments should be less than or equal to the number of data points in the time series");
        }
        if (numberOfSegments < 2) {
            throw new IllegalArgumentException(" This implementation only support a number of segments > 1");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + timeSeries.toString());
        }
        double[] piecewiseTransformedData = this.transformTimeSeriesToPAARepresentation(timeSeries.data, numberOfSegments);
        TimeSeries paaSeries = new TimeSeries(piecewiseTransformedData, String.valueOf(timeSeries.getName()) + "_PAA");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return paaSeries;
    }

    private double[] transformTimeSeriesToPAARepresentation(double[] dataPoints, int numberOfSegments) {
        double[] piecewiseTransformedData = new double[numberOfSegments];
        double segmentSize = (double)dataPoints.length / (double)numberOfSegments;
        double wholePartSegmentSize = Math.floor(segmentSize);
        boolean isExactlyDivisible = segmentSize == (double)((int)segmentSize);
        double currentPoint = 0.0;
        while (currentPoint < wholePartSegmentSize) {
            piecewiseTransformedData[0] = piecewiseTransformedData[0] + dataPoints[(int)currentPoint];
            currentPoint += 1.0;
        }
        if (!isExactlyDivisible) {
            double weight = segmentSize - Math.floor(segmentSize);
            piecewiseTransformedData[0] = piecewiseTransformedData[0] + dataPoints[(int)currentPoint] * weight;
            currentPoint += weight;
        }
        piecewiseTransformedData[0] = piecewiseTransformedData[0] / segmentSize;
        int currentSegment = 1;
        while (currentSegment < numberOfSegments) {
            double weight;
            boolean currenPointIsExactlyDivisible;
            double remainingSegmentSize = segmentSize;
            boolean bl = currenPointIsExactlyDivisible = currentPoint == (double)((int)currentPoint);
            if (!currenPointIsExactlyDivisible) {
                weight = Math.ceil(currentPoint) - currentPoint;
                int n = currentSegment;
                piecewiseTransformedData[n] = piecewiseTransformedData[n] + dataPoints[(int)currentPoint] * weight;
                currentPoint += weight;
                remainingSegmentSize -= weight;
            }
            while (remainingSegmentSize >= 1.0) {
                int n = currentSegment;
                piecewiseTransformedData[n] = piecewiseTransformedData[n] + dataPoints[(int)currentPoint];
                remainingSegmentSize -= 1.0;
                currentPoint += 1.0;
            }
            if (remainingSegmentSize > 0.0 && currentPoint < (double)dataPoints.length) {
                weight = remainingSegmentSize;
                int n = currentSegment;
                piecewiseTransformedData[n] = piecewiseTransformedData[n] + dataPoints[(int)currentPoint] * weight;
                currentPoint += weight;
            }
            int n = currentSegment++;
            piecewiseTransformedData[n] = piecewiseTransformedData[n] / segmentSize;
        }
        if (this.DEBUG_MODE) {
            System.out.println(String.valueOf(System.lineSeparator()) + " --- Dividing time series into segments ---");
            System.out.println(" Number of data points = " + dataPoints.length);
            System.out.println(" Number of segments = " + numberOfSegments);
            System.out.println(" Segment size = " + segmentSize);
            System.out.println(" Is exactly divisible into segment? " + isExactlyDivisible);
            System.out.println(" Piecewise-Aggregate-transformation: " + Arrays.toString(piecewiseTransformedData));
        }
        return piecewiseTransformedData;
    }

    public void printStats() {
        System.out.println("=============  Transform To PAA  ALGORITHM v2.05- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

