/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.simplelinearregression;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesReader;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesWriter;
import ca.pfv.spmf.algorithms.timeseries.simplelinearregression.AlgoTimeSeriesLinearRegressionLeastSquare;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class MainTestLinearRegressionLeastSquaresFromFile {
    public static void main(String[] arg) throws IOException {
        String input = MainTestLinearRegressionLeastSquaresFromFile.fileToPath("contextSAX.txt");
        String output = "./output.txt";
        String separator = ",";
        AlgoTimeSeriesReader reader = new AlgoTimeSeriesReader();
        List<TimeSeries> multipleTimeSeries = reader.runAlgorithm(input, separator);
        ArrayList<TimeSeries> regressionLines = new ArrayList<TimeSeries>();
        for (TimeSeries timeSeries : multipleTimeSeries) {
            AlgoTimeSeriesLinearRegressionLeastSquare algorithm = new AlgoTimeSeriesLinearRegressionLeastSquare();
            algorithm.trainModel(timeSeries);
            TimeSeries regressionLine = algorithm.calculateRegressionLine(timeSeries);
            regressionLines.add(regressionLine);
            algorithm.printStats();
        }
        AlgoTimeSeriesWriter algorithm2 = new AlgoTimeSeriesWriter();
        algorithm2.runAlgorithm(output, regressionLines, separator);
        algorithm2.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestLinearRegressionLeastSquaresFromFile.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

