/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.datastructures.binarytree;

public class BinaryTree<T extends Comparable<T>> {
    private int size = 0;
    private Node root = null;
    boolean allowSameElementMultipleTimes = true;

    public BinaryTree(boolean allowSameElementMultipleTimes) {
        this.allowSameElementMultipleTimes = allowSameElementMultipleTimes;
    }

    public BinaryTree() {
    }

    public int size() {
        return this.size;
    }

    public void add(T element) {
        Node z = new Node();
        z.key = element;
        Node y = null;
        Node x = this.root;
        while (x != null) {
            y = x;
            int compare = z.key.compareTo(x.key);
            if (compare < 0) {
                x = x.left;
                continue;
            }
            if (compare == 0 && !this.allowSameElementMultipleTimes) {
                return;
            }
            x = x.right;
        }
        z.parent = y;
        if (y == null) {
            this.root = z;
        } else if (z.key.compareTo(y.key) < 0) {
            y.left = z;
        } else {
            y.right = z;
        }
        ++this.size;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public void remove(T element) {
        Node z = this.search(this.root, element);
        if (z == null) {
            return;
        }
        this.performDelete(z);
    }

    private void performDelete(Node z) {
        Node y = z.left == null || z.right == null ? z : this.successor(z);
        Node x = y.left != null ? y.left : y.right;
        if (x != null) {
            x.parent = y.parent;
        }
        if (y.parent == null) {
            this.root = x;
        } else if (y.equals(y.parent.left)) {
            y.parent.left = x;
        } else {
            y.parent.right = x;
        }
        if (y != z) {
            z.key = y.key;
        }
        --this.size;
    }

    private Node successor(Node x) {
        if (x.right != null) {
            return this.minimum(x.right);
        }
        Node y = x.parent;
        while (y != null && x.equals(y.right)) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    private Node predecessor(Node x) {
        if (x.left != null) {
            return this.maximum(x.left);
        }
        Node y = x.parent;
        while (y != null && x.equals(y.left)) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    public T popMinimum() {
        if (this.root == null) {
            return null;
        }
        Node x = this.root;
        while (x.left != null) {
            x = x.left;
        }
        Object value = x.key;
        this.performDelete(x);
        return value;
    }

    public T lower(T k) {
        Node result = this.lowerNode(k);
        if (result == null) {
            return null;
        }
        return result.key;
    }

    private Node lowerNode(T k) {
        Node x = this.root;
        while (x != null) {
            if (k.compareTo(x.key) > 0) {
                if (x.right != null) {
                    x = x.right;
                    continue;
                }
                return x;
            }
            if (x.left != null) {
                x = x.left;
                continue;
            }
            Node current = x;
            while (current.parent != null && current.parent.left == current) {
                current = current.parent;
            }
            return current.parent;
        }
        return null;
    }

    public T higher(T k) {
        Node result = this.higherNode(k);
        if (result == null) {
            return null;
        }
        return result.key;
    }

    private Node higherNode(T k) {
        Node x = this.root;
        while (x != null) {
            if (k.compareTo(x.key) < 0) {
                if (x.left != null) {
                    x = x.left;
                    continue;
                }
                return x;
            }
            if (x.right != null) {
                x = x.right;
                continue;
            }
            Node current = x;
            while (current.parent != null && current.parent.right == current) {
                current = current.parent;
            }
            return current.parent;
        }
        return null;
    }

    public T minimum() {
        if (this.root == null) {
            return null;
        }
        return this.minimum((Node)this.root).key;
    }

    private Node minimum(Node x) {
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    public T popMaximum() {
        if (this.root == null) {
            return null;
        }
        Node x = this.root;
        while (x.right != null) {
            x = x.right;
        }
        Object value = x.key;
        this.performDelete(x);
        return value;
    }

    public T maximum() {
        if (this.root == null) {
            return null;
        }
        return this.maximum((Node)this.root).key;
    }

    private Node maximum(Node x) {
        while (x.right != null) {
            x = x.right;
        }
        return x;
    }

    public boolean contains(T k) {
        return this.search(this.root, k) != null;
    }

    private Node search(Node x, T k) {
        while (x != null && !k.equals(x.key)) {
            x = k.compareTo(x.key) < 0 ? x.left : x.right;
        }
        return x;
    }

    public String toString() {
        if (this.root == null) {
            return "";
        }
        return this.print(this.root, new StringBuilder()).toString();
    }

    private StringBuilder print(Node x, StringBuilder buffer) {
        if (x != null && x.key != null) {
            this.print(x.left, buffer);
            buffer.append(x.key + " ");
            this.print(x.right, buffer);
        }
        return buffer;
    }

    public class Node {
        T key = null;
        Node left = null;
        Node right = null;
        Node parent = null;

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.key.toString());
            if (this.left != null) {
                buffer.append(" L= " + this.left.key);
            }
            if (this.right != null) {
                buffer.append(" R= " + this.right.key);
            }
            return buffer.toString();
        }
    }
}

