/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.experiments.oneparametervaried;

import ca.pfv.spmf.gui.PreferencesManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class ExperimenterForParameterChange {
    private String spmfJarPath = "spmf.jar";
    private String logFilePath = null;
    private String timeoutCodeString = "TIMEOUT";
    private final int timeoutCode = -999;
    DecimalFormat formatTwoDecimals = (DecimalFormat)NumberFormat.getNumberInstance();
    DecimalFormat formatAllDecimals;

    public ExperimenterForParameterChange() {
        this.formatTwoDecimals.applyPattern("#.##");
        this.formatAllDecimals = (DecimalFormat)NumberFormat.getNumberInstance();
    }

    public void runAnAlgorithmAndVaryParameter(String[] algorithmNames, String[] args, String[] varyingParameterValues, String inputFile, String outputDirectory, int timeoutInMilliseconds, boolean compareOutputSize, boolean showCommand, boolean generatePGFPLOTFigures, String variedParameterName) throws Exception {
        File directory = new File(outputDirectory);
        directory.mkdir();
        String logFile = String.valueOf(outputDirectory) + File.separatorChar + "EXPERIMENT_LOG.txt";
        File file = new File(logFile);
        if (file.exists()) {
            file.delete();
        }
        this.setRedirectOutputPath(logFile);
        int positionOfVariedParameter = -1;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("##")) {
                positionOfVariedParameter = i;
                break;
            }
            ++i;
        }
        if (positionOfVariedParameter == -1) {
            throw new Exception("ERROR: The parameter to be varied should be indicated with the value: ##");
        }
        ArrayList<String> commandWithParameters = new ArrayList<String>();
        commandWithParameters.add("java");
        commandWithParameters.add("-jar");
        commandWithParameters.add(this.spmfJarPath);
        commandWithParameters.add("run");
        commandWithParameters.add("PLACEHOLDER_ALGORITHM_NAME");
        if (inputFile != null) {
            commandWithParameters.add(inputFile);
        }
        commandWithParameters.add("PLACEHOLDER_OUTPUT_FILE");
        int positionVariedParameterInCommand = commandWithParameters.size() + positionOfVariedParameter;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            commandWithParameters.add(arg);
            ++n2;
        }
        double[][] runtimes = new double[algorithmNames.length][varyingParameterValues.length];
        double[][] memoryResults = new double[algorithmNames.length][varyingParameterValues.length];
        int[][] outputSizes = new int[algorithmNames.length][varyingParameterValues.length];
        System.out.println("********************************************");
        System.out.println("*****       RUNNING EXPERIMENTS        *****");
        System.out.println("********************************************");
        System.out.println(" INPUT: " + inputFile);
        System.out.println(" OUTPUT DIRECTORY: " + outputDirectory);
        System.out.println();
        int experimentCount = 1;
        int m = 0;
        while (m < algorithmNames.length) {
            String algorithmName = algorithmNames[m];
            commandWithParameters.set(4, algorithmName);
            int j = 0;
            while (j < varyingParameterValues.length) {
                String value = varyingParameterValues[j];
                commandWithParameters.set(positionVariedParameterInCommand, value);
                String outputFile = String.valueOf(outputDirectory) + File.separatorChar + algorithmName + "_" + value + ".txt";
                commandWithParameters.set(6, outputFile);
                System.out.println(" *****  EXPERIMENT " + experimentCount++);
                System.out.println("   ALGORITHM: " + algorithmName + " \t" + variedParameterName + "= " + this.convertDoubleStringToLocalizeString(value) + "  *****");
                if (showCommand) {
                    StringBuilder theCommandAsString = new StringBuilder("   COMMAND: ");
                    for (String str : commandWithParameters) {
                        theCommandAsString.append(str);
                        theCommandAsString.append(' ');
                    }
                    System.out.println(theCommandAsString);
                }
                ProcessBuilder pb = new ProcessBuilder(commandWithParameters);
                pb.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(this.logFilePath)));
                pb.redirectError(ProcessBuilder.Redirect.appendTo(new File(this.logFilePath)));
                long startTime = System.currentTimeMillis();
                Process process = pb.start();
                boolean exitValue = process.waitFor(timeoutInMilliseconds, TimeUnit.MILLISECONDS);
                long totalTime = System.currentTimeMillis() - startTime;
                if (!exitValue) {
                    System.out.println("   TIME: TIME-OUT");
                    process.destroyForcibly();
                    runtimes[m][j] = -999.0;
                    memoryResults[m][j] = -999.0;
                    if (compareOutputSize) {
                        outputSizes[m][j] = -999;
                    }
                } else {
                    runtimes[m][j] = (double)totalTime / 1000.0;
                    memoryResults[m][j] = PreferencesManager.getInstance().getLastMemoryUsage();
                    System.out.println("   TIME: " + this.formatTwoDecimals.format(runtimes[m][j]) + " s \t MEMORY: " + this.formatTwoDecimals.format(memoryResults[m][j]) + " MB");
                    System.out.print("   OUTPUT: " + new File(outputFile).getName());
                    if (compareOutputSize) {
                        outputSizes[m][j] = this.calculateSizeOfFile(outputFile);
                        System.out.print(" \t OUTPUT_SIZE: " + outputSizes[m][j] + " lines");
                    }
                    System.out.println();
                    System.out.println();
                }
                ++j;
            }
            ++m;
        }
        System.out.println();
        System.out.println("********************************************");
        System.out.println("*****             RESULTS              *****");
        System.out.println("********************************************");
        StringBuffer buffer = new StringBuffer();
        buffer.append("INPUT FILE: ");
        buffer.append(inputFile);
        buffer.append(System.lineSeparator());
        buffer.append("PARAMETERS: ");
        buffer.append(Arrays.toString(args));
        buffer.append(System.lineSeparator());
        buffer.append(System.lineSeparator());
        buffer.append("TIME (S)");
        buffer.append(System.lineSeparator());
        buffer.append(String.valueOf(variedParameterName) + "\t ");
        int k = 0;
        while (k < varyingParameterValues.length) {
            String parameterValue = varyingParameterValues[k];
            parameterValue = this.convertDoubleStringToLocalizeString(parameterValue);
            buffer.append(String.valueOf(parameterValue) + "\t");
            ++k;
        }
        buffer.append(System.lineSeparator());
        int m2 = 0;
        while (m2 < algorithmNames.length) {
            buffer.append(String.valueOf(algorithmNames[m2]) + "\t");
            int k2 = 0;
            while (k2 < varyingParameterValues.length) {
                double value = runtimes[m2][k2];
                if (value == -999.0) {
                    buffer.append(String.valueOf(this.timeoutCodeString) + "\t");
                } else {
                    buffer.append(String.valueOf(this.formatTwoDecimals.format(value)) + "\t");
                }
                ++k2;
            }
            buffer.append(System.lineSeparator());
            ++m2;
        }
        buffer.append(System.lineSeparator());
        buffer.append("MEMORY (MB)");
        buffer.append(System.lineSeparator());
        buffer.append(String.valueOf(variedParameterName) + "\t ");
        k = 0;
        while (k < varyingParameterValues.length) {
            String parameterValue = varyingParameterValues[k];
            parameterValue = this.convertDoubleStringToLocalizeString(parameterValue);
            buffer.append(String.valueOf(parameterValue) + "\t");
            ++k;
        }
        buffer.append(System.lineSeparator());
        m2 = 0;
        while (m2 < algorithmNames.length) {
            buffer.append(String.valueOf(algorithmNames[m2]) + "\t");
            int k3 = 0;
            while (k3 < varyingParameterValues.length) {
                double value = memoryResults[m2][k3];
                if (value == -999.0) {
                    buffer.append(String.valueOf(this.timeoutCodeString) + "\t");
                } else {
                    buffer.append(String.valueOf(this.formatTwoDecimals.format(value)) + "\t");
                }
                ++k3;
            }
            buffer.append(System.lineSeparator());
            ++m2;
        }
        buffer.append(System.lineSeparator());
        buffer.append("OUTPUT_SIZE (LINES)");
        buffer.append(System.lineSeparator());
        buffer.append(String.valueOf(variedParameterName) + "\t ");
        k = 0;
        while (k < varyingParameterValues.length) {
            String parameterValue = varyingParameterValues[k];
            parameterValue = this.convertDoubleStringToLocalizeString(parameterValue);
            buffer.append(String.valueOf(parameterValue) + "\t");
            ++k;
        }
        buffer.append(System.lineSeparator());
        m2 = 0;
        while (m2 < algorithmNames.length) {
            buffer.append(String.valueOf(algorithmNames[m2]) + "\t");
            int k4 = 0;
            while (k4 < varyingParameterValues.length) {
                int value = outputSizes[m2][k4];
                if (value == -999) {
                    buffer.append(String.valueOf(this.timeoutCodeString) + "\t");
                } else {
                    buffer.append(String.valueOf(value) + "\t");
                }
                ++k4;
            }
            buffer.append(System.lineSeparator());
            ++m2;
        }
        String bufferAsString = buffer.toString();
        System.out.println(bufferAsString);
        String summaryFilePath = String.valueOf(outputDirectory) + File.separatorChar + "EXPERIMENT_RESULT.txt";
        BufferedWriter writer = new BufferedWriter(new FileWriter(summaryFilePath));
        writer.write(bufferAsString);
        writer.close();
        if (generatePGFPLOTFigures) {
            String algorithmName;
            buffer = new StringBuffer();
            buffer.append("\\documentclass{article}");
            buffer.append(System.lineSeparator());
            buffer.append("\\usepackage{tikz}");
            buffer.append(System.lineSeparator());
            buffer.append("\\usepackage{pgfplots}");
            buffer.append(System.lineSeparator());
            buffer.append("\\begin{document}");
            buffer.append(System.lineSeparator());
            buffer.append(System.lineSeparator());
            buffer.append("\\begin{tikzpicture}");
            buffer.append(System.lineSeparator());
            buffer.append("\\begin{axis}[");
            buffer.append(System.lineSeparator());
            buffer.append("xlabel=$" + variedParameterName + "$,");
            buffer.append("ylabel=Time (s),cycle list name=color]");
            buffer.append(System.lineSeparator());
            int m3 = 0;
            while (m3 < algorithmNames.length) {
                algorithmName = algorithmNames[m3].replace('_', '-');
                buffer.append("\\addplot plot coordinates {");
                int j = 0;
                while (j < varyingParameterValues.length) {
                    if (runtimes[m3][j] >= 0.0) {
                        buffer.append("(");
                        buffer.append("" + Double.parseDouble(varyingParameterValues[j]));
                        buffer.append(",");
                        buffer.append("" + runtimes[m3][j]);
                        buffer.append(")");
                    }
                    ++j;
                }
                buffer.append("};\\addlegendentry{" + algorithmName + "}");
                ++m3;
            }
            buffer.append("\\end{axis}");
            buffer.append(System.lineSeparator());
            buffer.append("\\end{tikzpicture}");
            buffer.append(System.lineSeparator());
            buffer.append(System.lineSeparator());
            buffer.append("\\begin{tikzpicture}");
            buffer.append(System.lineSeparator());
            buffer.append("\\begin{axis}[");
            buffer.append(System.lineSeparator());
            buffer.append("xlabel=$" + variedParameterName + "$,");
            buffer.append("ylabel=Memory (MB),cycle list name=color]");
            buffer.append(System.lineSeparator());
            m3 = 0;
            while (m3 < algorithmNames.length) {
                algorithmName = algorithmNames[m3].replace('_', '-');
                buffer.append("\\addplot plot coordinates {");
                int j = 0;
                while (j < varyingParameterValues.length) {
                    if (runtimes[m3][j] >= 0.0) {
                        buffer.append("(");
                        buffer.append("" + Double.parseDouble(varyingParameterValues[j]));
                        buffer.append(",");
                        buffer.append("" + memoryResults[m3][j]);
                        buffer.append(")");
                    }
                    ++j;
                }
                buffer.append("};\\addlegendentry{" + algorithmName + "}");
                ++m3;
            }
            buffer.append("\\end{axis}");
            buffer.append(System.lineSeparator());
            buffer.append("\\end{tikzpicture}");
            buffer.append(System.lineSeparator());
            buffer.append(System.lineSeparator());
            if (compareOutputSize) {
                buffer.append("\\begin{tikzpicture}");
                buffer.append(System.lineSeparator());
                buffer.append("\\begin{axis}[");
                buffer.append(System.lineSeparator());
                buffer.append("xlabel=$" + variedParameterName + "$,");
                buffer.append("ylabel=Output size,cycle list name=color]");
                buffer.append(System.lineSeparator());
                m3 = 0;
                while (m3 < algorithmNames.length) {
                    algorithmName = algorithmNames[m3].replace('_', '-');
                    buffer.append("\\addplot plot coordinates {");
                    int j = 0;
                    while (j < varyingParameterValues.length) {
                        if (runtimes[m3][j] >= 0.0) {
                            buffer.append("(");
                            buffer.append("" + Double.parseDouble(varyingParameterValues[j]));
                            buffer.append(",");
                            buffer.append("" + outputSizes[m3][j]);
                            buffer.append(")");
                        }
                        ++j;
                    }
                    buffer.append("};\\addlegendentry{" + algorithmName + "}");
                    ++m3;
                }
                buffer.append("\\end{axis}");
                buffer.append(System.lineSeparator());
                buffer.append("\\end{tikzpicture}");
                buffer.append(System.lineSeparator());
                buffer.append(System.lineSeparator());
            }
            buffer.append("\\end{document}");
            buffer.append(System.lineSeparator());
            String latexpath = String.valueOf(outputDirectory) + File.separatorChar + "PGPLOT_FIGURES.tex";
            writer = new BufferedWriter(new FileWriter(latexpath));
            writer.write(buffer.toString());
            writer.close();
        }
    }

    private String convertDoubleStringToLocalizeString(String parameterValue) {
        if (parameterValue.contains(".")) {
            try {
                double doubleValue = Double.parseDouble(parameterValue);
                parameterValue = this.formatAllDecimals.format(doubleValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parameterValue;
    }

    private int calculateSizeOfFile(String file) {
        int size = 0;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@' || line.length() <= 0) continue;
                ++size;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return size;
    }

    public void setSPMFJarFilePath(String path) {
        this.spmfJarPath = path;
    }

    public String getRedirectOutputPath() {
        return this.logFilePath;
    }

    public void setRedirectOutputPath(String redirectOutputPath) {
        this.logFilePath = redirectOutputPath;
    }

    public String getTimeoutCode() {
        return this.timeoutCodeString;
    }

    public void setTimeoutCodeS(String timeoutCodeString) {
        this.timeoutCodeString = timeoutCodeString;
    }
}

