/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui;

import java.nio.charset.Charset;
import java.util.prefs.Preferences;

public class PreferencesManager {
    public static final String REGKEY_SPMF_INPUT_FILE = "ca.pfv.spmf.gui.input";
    public static final String REGKEY_SPMF_OUTPUT_FILE = "ca.pfv.spmf.gui.output";
    public static final String REGKEY_SPMF_PLUGIN_REPOSITORY_URL = "ca.pfv.spmf.plugin.repositoryurl";
    public static final String REGKEY_SPMF_PREFERED_CHARSET = "ca.pfv.spmf.gui.charset";
    public static final String REGKEY_SPMF_RUN_EXTERNAL = "ca.pfv.spmf.gui.runexternal";
    public static final String REGKEY_SPMF_JAR_FILE_PATH = "ca.pfv.spmf.jar_file_path";
    public static final String REGKEY_SPMF_EXPERIMENT_DIRECTORY_PATH = "ca.pfv.spmf.experiment_directory_path";
    public static final String REGKEY_LAST_MEMORY_USAGE = "ca.pfv.spmf.experiments.lastmemory";
    private static PreferencesManager instance;

    private PreferencesManager() {
    }

    public static PreferencesManager getInstance() {
        if (instance == null) {
            instance = new PreferencesManager();
        }
        return instance;
    }

    public String getInputFilePath() {
        Preferences p = Preferences.userRoot();
        return p.get(REGKEY_SPMF_INPUT_FILE, null);
    }

    public void setInputFilePath(String filepath) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_INPUT_FILE, filepath);
    }

    public String getOutputFilePath() {
        Preferences p = Preferences.userRoot();
        return p.get(REGKEY_SPMF_OUTPUT_FILE, null);
    }

    public void setOutputFilePath(String filepath) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_OUTPUT_FILE, filepath);
    }

    public String getExperimentDirectoryPath() {
        Preferences p = Preferences.userRoot();
        return p.get(REGKEY_SPMF_EXPERIMENT_DIRECTORY_PATH, null);
    }

    public void setExperimentDirectoryPath(String filepath) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_EXPERIMENT_DIRECTORY_PATH, filepath);
    }

    public void setSPMFJarFilePath(String path) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_JAR_FILE_PATH, path);
    }

    public String getSPMFJarFilePath() {
        Preferences p = Preferences.userRoot();
        return p.get(REGKEY_SPMF_JAR_FILE_PATH, null);
    }

    public void setRepositoryURL(String filepath) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_PLUGIN_REPOSITORY_URL, filepath);
    }

    public String getRepositoryURL() {
        Preferences p = Preferences.userRoot();
        String url = p.get(REGKEY_SPMF_PLUGIN_REPOSITORY_URL, null);
        return url == null ? "http://www.philippe-fournier-viger.com/spmf/plugins/" : url;
    }

    public Charset getPreferedCharset() {
        Preferences p = Preferences.userRoot();
        String charsetName = p.get(REGKEY_SPMF_PREFERED_CHARSET, null);
        return charsetName == null ? Charset.defaultCharset() : Charset.forName(charsetName);
    }

    public void setPreferedCharset(String charsetName) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_PREFERED_CHARSET, charsetName);
    }

    public boolean getRunAsExternalProgram() {
        Preferences p = Preferences.userRoot();
        String value = p.get(REGKEY_SPMF_RUN_EXTERNAL, null);
        return value == null ? false : Boolean.parseBoolean(value);
    }

    public void setRunAsExternalProgram(boolean value) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_SPMF_RUN_EXTERNAL, Boolean.toString(value));
    }

    public double getLastMemoryUsage() {
        Preferences p = Preferences.userRoot();
        String value = p.get(REGKEY_LAST_MEMORY_USAGE, null);
        return Double.parseDouble(value);
    }

    public void setLastMemoryUsage(double lastMemoryUsage) {
        Preferences p = Preferences.userRoot();
        p.put(REGKEY_LAST_MEMORY_USAGE, Double.toString(lastMemoryUsage));
    }
}

