/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.instanceviewer;

import ca.pfv.spmf.gui.instanceviewer.InstanceViewerPanelListener;
import ca.pfv.spmf.gui.instanceviewer.InstancesViewerPanel;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;

public class InstanceViewer
extends JFrame
implements InstanceViewerPanelListener {
    String title = "SPMF Instance Viewer 2.09";
    private static final long serialVersionUID = 1L;
    InstancesViewerPanel panelChart = null;
    private JLabel labelX;
    private JLabel labelY;
    String[] attributeNamesArray = null;
    private JComboBox comboBoxX;
    private JComboBox comboBoxY;

    public InstanceViewer(List<DoubleArray> instances, List<String> attributeNames) {
        if (instances.size() == 0) {
            JOptionPane.showMessageDialog(null, "The file is empty. The instance viewer has nothing to display", "Error", 0);
        }
        this.attributeNamesArray = attributeNames.toArray(new String[0]);
        if (attributeNames == null || attributeNames.size() == 0) {
            int dimensionCount = instances.get((int)0).data.length;
            this.attributeNamesArray = new String[dimensionCount];
            int i = 0;
            while (i < dimensionCount) {
                attributeNames.add("Attribute " + i);
                ++i;
            }
        }
        this.setTitle("SPMF Instance Viewer 2.09");
        this.setSize(900, 684);
        this.setMinimumSize(new Dimension(884, 648));
        this.panelChart = new InstancesViewerPanel(instances, 0, 1);
        this.panelChart.setForeground(Color.WHITE);
        this.panelChart.addListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JScrollPane scrollPane = new JScrollPane(this.panelChart);
        scrollPane.setAutoscrolls(true);
        this.getContentPane().add(scrollPane);
        JPanel panelTools = new JPanel();
        panelTools.setMinimumSize(new Dimension(900, 100));
        panelTools.setPreferredSize(new Dimension(900, 100));
        panelTools.setMaximumSize(new Dimension(900, 100));
        this.getContentPane().add(panelTools);
        panelTools.setLayout(null);
        JPanel panel = new JPanel();
        panel.setBounds(10, 11, 199, 40);
        panelTools.add(panel);
        panel.setBorder(new EtchedBorder(1, null, null));
        panel.setVisible(true);
        panel.setLayout(null);
        this.labelX = new JLabel("x = ");
        this.labelX.setBounds(15, 7, 61, 20);
        panel.add(this.labelX);
        this.labelY = new JLabel("y = ");
        this.labelY.setBounds(106, 7, 51, 20);
        panel.add(this.labelY);
        JButton buttonZoomIn = new JButton("");
        buttonZoomIn.setBounds(313, 11, 50, 29);
        panelTools.add(buttonZoomIn);
        buttonZoomIn.setIcon(new ImageIcon(InstanceViewer.class.getResource("/ca/pfv/spmf/gui/icons/zoomin.gif")));
        JButton buttonZoomOut = new JButton("");
        buttonZoomOut.setBounds(366, 11, 50, 29);
        panelTools.add(buttonZoomOut);
        buttonZoomOut.setIcon(new ImageIcon(InstanceViewer.class.getResource("/ca/pfv/spmf/gui/icons/zoomout.gif")));
        final JComboBox<String> comboBoxGrid = new JComboBox<String>(new String[]{"VISIBLE", "NONE"});
        comboBoxGrid.setBounds(592, 19, 87, 26);
        panelTools.add(comboBoxGrid);
        comboBoxGrid.setSelectedIndex(1);
        JLabel lblGrid = new JLabel("Grid:");
        lblGrid.setBounds(533, 25, 44, 20);
        panelTools.add(lblGrid);
        JLabel lblMarkers = new JLabel("Markers:");
        lblMarkers.setBounds(517, 59, 70, 20);
        panelTools.add(lblMarkers);
        final JComboBox<String> comboBoxMarkers = new JComboBox<String>(new String[]{"NONE", "1 pts", "2 pts", "3 pts", "4 pts", "5 pts", "6 pts", "7 pts", "8 pts", "9 pts", "10 pts"});
        comboBoxMarkers.setSelectedIndex(5);
        comboBoxMarkers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selection = comboBoxMarkers.getSelectedIndex();
                InstanceViewer.this.panelChart.setMarkersSize(selection);
            }
        });
        comboBoxMarkers.setBounds(592, 53, 87, 26);
        panelTools.add(comboBoxMarkers);
        JButton buttonSaveAsPng = new JButton("Save as PNG");
        buttonSaveAsPng.setBounds(694, 50, 163, 29);
        panelTools.add(buttonSaveAsPng);
        buttonSaveAsPng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceViewer.this.panelChart.export();
            }
        });
        buttonSaveAsPng.setIcon(new ImageIcon(InstanceViewer.class.getResource("/ca/pfv/spmf/gui/icons/save.gif")));
        JButton buttonPrint = new JButton("Print");
        buttonPrint.setBounds(694, 11, 163, 29);
        panelTools.add(buttonPrint);
        buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceViewer.this.panelChart.doPrint();
            }
        });
        buttonPrint.setIcon(new ImageIcon(InstanceViewer.class.getResource("/ca/pfv/spmf/gui/icons/print.gif")));
        JLabel lblXAttribute = new JLabel("X attribute:");
        lblXAttribute.setBounds(10, 75, 75, 14);
        panelTools.add(lblXAttribute);
        this.comboBoxX = new JComboBox<String>(this.attributeNamesArray);
        this.comboBoxX.setSelectedIndex(0);
        this.comboBoxX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int attributeSelectedX = InstanceViewer.this.comboBoxX.getSelectedIndex();
                int attributeSelectedY = InstanceViewer.this.comboBoxY.getSelectedIndex();
                InstanceViewer.this.panelChart.setAttributeSelection(attributeSelectedX, attributeSelectedY);
            }
        });
        this.comboBoxX.setBounds(77, 72, 121, 20);
        panelTools.add(this.comboBoxX);
        JLabel lblYAttribute = new JLabel("Y attribute:");
        lblYAttribute.setBounds(208, 75, 70, 14);
        panelTools.add(lblYAttribute);
        this.comboBoxY = new JComboBox<String>(this.attributeNamesArray);
        this.comboBoxY.setSelectedIndex(1);
        this.comboBoxY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int attributeSelectedX = InstanceViewer.this.comboBoxX.getSelectedIndex();
                int attributeSelectedY = InstanceViewer.this.comboBoxY.getSelectedIndex();
                InstanceViewer.this.panelChart.setAttributeSelection(attributeSelectedX, attributeSelectedY);
            }
        });
        this.comboBoxY.setBounds(284, 72, 121, 20);
        panelTools.add(this.comboBoxY);
        comboBoxGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = (String)comboBoxGrid.getSelectedItem();
                InstanceViewer.this.panelChart.setDrawGrid("VISIBLE".equals(selection));
            }
        });
        buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceViewer.this.panelChart.decreaseZoom();
            }
        });
        buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceViewer.this.panelChart.increaseZoom();
            }
        });
    }

    @Override
    public void notifyOfNewMousePosition(double x, double y) {
        DecimalFormat df = new DecimalFormat("0.00");
        df.setMaximumFractionDigits(2);
        String stringX = df.format(x);
        String stringY = df.format(y);
        this.labelX.setText("x = " + stringX);
        this.labelY.setText("y = " + stringY);
    }

    @Override
    public void notifyMouseOutOfChart() {
        this.labelX.setText("x = ");
        this.labelY.setText("y = ");
    }
}

