/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.patternvizualizer;

import ca.pfv.spmf.gui.patternvizualizer.PatternTableRowFilters;
import ca.pfv.spmf.gui.patternvizualizer.PatternVizualizer;
import ca.pfv.spmf.gui.patternvizualizer.filters.AbstractFilter;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterEqualBoolean;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterEqualDouble;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterEqualInteger;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterGreaterThanDouble;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterGreaterThanInteger;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterLessThanDouble;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterLessThanInteger;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterStringContains;
import ca.pfv.spmf.gui.patternvizualizer.filters.FilterStringNotContains;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterSelectionWindow
extends JDialog {
    private JTextField textField;
    Vector<String> columnNames = null;
    Vector<Class> columnClasses = null;
    PatternTableRowFilters rowfilters;
    List<Class> listComboBoxFilters = new ArrayList<Class>();
    private JComboBox comboBoxFilters;
    private JComboBox comboBoxColumns;
    private PatternVizualizer patternVisualizer;

    public FilterSelectionWindow(final Vector<String> columnNames, final Vector<Class> columnClasses, PatternTableRowFilters rowFilters, PatternVizualizer patternVisualizer) {
        super(patternVisualizer);
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        this.rowfilters = rowFilters;
        this.patternVisualizer = patternVisualizer;
        this.setVisible(true);
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Add a filter...");
        this.getContentPane().setLayout(null);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FilterSelectionWindow.this.setVisible(false);
                FilterSelectionWindow.this.dispose();
            }
        });
        btnCancel.setBounds(500, 143, 89, 23);
        this.getContentPane().add(btnCancel);
        final JButton btnAddFilter = new JButton("Add filter");
        btnAddFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterSelectionWindow.this.addFilter();
            }
        });
        btnAddFilter.setBounds(401, 143, 89, 23);
        this.getContentPane().add(btnAddFilter);
        btnAddFilter.setEnabled(false);
        JLabel lblSelectAColumn = new JLabel("Choose a column:");
        lblSelectAColumn.setBounds(10, 22, 258, 14);
        this.getContentPane().add(lblSelectAColumn);
        JLabel lblSelectAConstraint = new JLabel("Choose a constraint:");
        lblSelectAConstraint.setBounds(10, 74, 149, 14);
        this.getContentPane().add(lblSelectAConstraint);
        this.comboBoxFilters = new JComboBox();
        this.comboBoxFilters.setBounds(68, 99, 323, 23);
        this.getContentPane().add(this.comboBoxFilters);
        this.comboBoxColumns = new JComboBox<String>(columnNames);
        this.comboBoxColumns.setBounds(68, 42, 200, 23);
        this.getContentPane().add(this.comboBoxColumns);
        this.comboBoxColumns.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    FilterSelectionWindow.this.refreshComboBoxFilters(columnNames, columnClasses, FilterSelectionWindow.this.comboBoxFilters, FilterSelectionWindow.this.comboBoxColumns);
                }
            }
        });
        this.refreshComboBoxFilters(columnNames, columnClasses, this.comboBoxFilters, this.comboBoxColumns);
        this.textField = new JTextField();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.printIt(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.printIt(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.printIt(documentEvent);
            }

            private void printIt(DocumentEvent documentEvent) {
                if (!FilterSelectionWindow.this.textField.getText().isEmpty()) {
                    btnAddFilter.setEnabled(true);
                } else {
                    btnAddFilter.setEnabled(false);
                }
            }
        };
        this.textField.getDocument().addDocumentListener(documentListener);
        this.textField.setBounds(401, 100, 200, 20);
        this.getContentPane().add(this.textField);
        this.textField.setColumns(10);
        this.textField.setEnabled(true);
        this.setSize(632, 228);
    }

    private void addFilter() {
        Class selectedFilterClass = this.listComboBoxFilters.get(this.comboBoxFilters.getSelectedIndex());
        String valueString = this.textField.getText();
        int columnID = this.comboBoxColumns.getSelectedIndex();
        String columnName = (String)this.comboBoxColumns.getSelectedItem();
        try {
            AbstractFilter filter = null;
            if (selectedFilterClass.equals(FilterEqualBoolean.class)) {
                boolean value = Boolean.parseBoolean(valueString);
                filter = new FilterEqualBoolean(value, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterEqualDouble.class)) {
                double value = Double.parseDouble(valueString);
                filter = new FilterEqualDouble(value, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterEqualInteger.class)) {
                int value = Integer.parseInt(valueString);
                filter = new FilterEqualInteger(value, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterGreaterThanDouble.class)) {
                double value = Double.parseDouble(valueString);
                filter = new FilterGreaterThanDouble(value, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterGreaterThanInteger.class)) {
                int value = Integer.parseInt(valueString);
                filter = new FilterGreaterThanInteger(value, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterLessThanDouble.class)) {
                double value = Double.parseDouble(valueString);
                filter = new FilterLessThanDouble(value, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterLessThanInteger.class)) {
                int value = Integer.parseInt(valueString);
                filter = new FilterLessThanInteger(value, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterStringContains.class)) {
                filter = new FilterStringContains(valueString, columnName, columnID);
            } else if (selectedFilterClass.equals(FilterStringNotContains.class)) {
                filter = new FilterStringNotContains(valueString, columnName, columnID);
            }
            this.rowfilters.filters.add(filter);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid value in text field. ERROR MESSAGE = " + e.toString(), "Error", 0);
            return;
        }
        this.setVisible(false);
        this.patternVisualizer.filtersHaveBeenUpdated();
    }

    private void refreshComboBoxFilters(Vector<String> columnNames, Vector<Class> columnClasses, JComboBox comboBoxFilters, JComboBox comboBoxColumns) {
        String selectedColumnName = (String)comboBoxColumns.getSelectedItem();
        comboBoxFilters.removeAllItems();
        this.listComboBoxFilters.clear();
        Object selectedColumnClass = null;
        int i = 0;
        while (i < columnNames.size()) {
            if (columnNames.get(i).equals(selectedColumnName)) {
                selectedColumnClass = columnClasses.get(i);
                break;
            }
            ++i;
        }
        if (selectedColumnClass.equals(Integer.class)) {
            this.listComboBoxFilters.add(FilterEqualInteger.class);
            comboBoxFilters.addItem(FilterEqualInteger.getFilterGenericName());
            this.listComboBoxFilters.add(FilterGreaterThanInteger.class);
            comboBoxFilters.addItem(FilterGreaterThanInteger.getFilterGenericName());
            this.listComboBoxFilters.add(FilterLessThanInteger.class);
            comboBoxFilters.addItem(FilterLessThanInteger.getFilterGenericName());
        } else if (selectedColumnClass.equals(Double.class)) {
            this.listComboBoxFilters.add(FilterEqualDouble.class);
            comboBoxFilters.addItem(FilterEqualDouble.getFilterGenericName());
            this.listComboBoxFilters.add(FilterGreaterThanDouble.class);
            comboBoxFilters.addItem(FilterGreaterThanDouble.getFilterGenericName());
            this.listComboBoxFilters.add(FilterLessThanDouble.class);
            comboBoxFilters.addItem(FilterLessThanDouble.getFilterGenericName());
        } else if (selectedColumnClass.equals(String.class)) {
            this.listComboBoxFilters.add(FilterStringContains.class);
            comboBoxFilters.addItem(FilterStringContains.getFilterGenericName());
            this.listComboBoxFilters.add(FilterStringNotContains.class);
            comboBoxFilters.addItem(FilterStringNotContains.getFilterGenericName());
        } else if (selectedColumnClass.equals(Boolean.class)) {
            this.listComboBoxFilters.add(FilterEqualBoolean.class);
            comboBoxFilters.addItem(FilterEqualBoolean.getFilterGenericName());
        }
    }
}

