/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.gui.timeseriesviewer;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.gui.plot.Plot;
import ca.pfv.spmf.gui.timeseriesviewer.TimeSeriesViewerPanel;
import ca.pfv.spmf.gui.timeseriesviewer.TimeSeriesViewerPanelListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;

public class TimeSeriesViewer
extends JFrame
implements TimeSeriesViewerPanelListener {
    String title = "SPMF Time Series Viewer 2.08";
    private static final long serialVersionUID = 1L;
    TimeSeriesViewerPanel panelChart = null;
    private JLabel labelX;
    private JLabel labelY;
    private JLabel labelName;

    public TimeSeriesViewer(List<TimeSeries> timeSeries) {
        this.setTitle(this.title);
        this.setSize(900, 600);
        this.setMinimumSize(new Dimension(884, 648));
        this.panelChart = new TimeSeriesViewerPanel(timeSeries);
        this.panelChart.setForeground(Color.WHITE);
        this.panelChart.addListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JScrollPane scrollPane = new JScrollPane(this.panelChart);
        scrollPane.setAutoscrolls(true);
        this.getContentPane().add(scrollPane);
        JPanel panelTools = new JPanel();
        panelTools.setMinimumSize(new Dimension(900, 100));
        panelTools.setPreferredSize(new Dimension(900, 100));
        panelTools.setMaximumSize(new Dimension(900, 100));
        this.getContentPane().add(panelTools);
        panelTools.setLayout(null);
        JPanel panel = new JPanel();
        panel.setBounds(15, 16, 199, 63);
        panelTools.add(panel);
        panel.setBorder(new EtchedBorder(1, null, null));
        panel.setVisible(true);
        panel.setLayout(null);
        this.labelX = new JLabel("x = ");
        this.labelX.setBounds(15, 7, 61, 20);
        panel.add(this.labelX);
        this.labelY = new JLabel("y = ");
        this.labelY.setBounds(104, 7, 51, 20);
        panel.add(this.labelY);
        this.labelName = new JLabel("name = ");
        this.labelName.setBounds(15, 27, 169, 20);
        panel.add(this.labelName);
        JButton buttonZoomIn = new JButton("");
        buttonZoomIn.setBounds(218, 16, 50, 29);
        panelTools.add(buttonZoomIn);
        buttonZoomIn.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/gui/icons/zoomin.gif")));
        JButton buttonZoomOut = new JButton("");
        buttonZoomOut.setBounds(270, 16, 50, 29);
        panelTools.add(buttonZoomOut);
        buttonZoomOut.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/gui/icons/zoomout.gif")));
        JLabel lblLegend = new JLabel("Legend:");
        lblLegend.setBounds(353, 25, 59, 20);
        panelTools.add(lblLegend);
        JLabel lblLines = new JLabel("Series lines:");
        lblLines.setBounds(325, 59, 87, 20);
        panelTools.add(lblLines);
        final JComboBox<Plot.LegendFormat> comboBoxLegend = new JComboBox<Plot.LegendFormat>(Plot.LegendFormat.values());
        comboBoxLegend.setBounds(416, 19, 87, 26);
        panelTools.add(comboBoxLegend);
        comboBoxLegend.setSelectedIndex(3);
        final JComboBox<String> comboBoxSeriesLine = new JComboBox<String>(new String[]{"NONE", "1 pts", "2 pts", "3 pts", "4 pts", "5 pts", "6 pts", "7 pts", "8 pts", "9 pts", "10 pts"});
        comboBoxSeriesLine.setBounds(416, 56, 87, 26);
        comboBoxSeriesLine.setSelectedIndex(1);
        panelTools.add(comboBoxSeriesLine);
        comboBoxSeriesLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selection = comboBoxSeriesLine.getSelectedIndex();
                TimeSeriesViewer.this.panelChart.setSeriesLineWidth(selection);
            }
        });
        final JComboBox<String> comboBoxGrid = new JComboBox<String>(new String[]{"VISIBLE", "NONE"});
        comboBoxGrid.setBounds(592, 19, 87, 26);
        panelTools.add(comboBoxGrid);
        JLabel lblGrid = new JLabel("Grid:");
        lblGrid.setBounds(533, 25, 44, 20);
        panelTools.add(lblGrid);
        JLabel lblMarkers = new JLabel("Markers:");
        lblMarkers.setBounds(517, 59, 70, 20);
        panelTools.add(lblMarkers);
        final JComboBox<String> comboBoxMarkers = new JComboBox<String>(new String[]{"NONE", "1 pts", "2 pts", "3 pts", "4 pts", "5 pts", "6 pts", "7 pts", "8 pts", "9 pts", "10 pts"});
        comboBoxMarkers.setSelectedIndex(5);
        comboBoxMarkers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selection = comboBoxMarkers.getSelectedIndex();
                TimeSeriesViewer.this.panelChart.setMarkersSize(selection);
            }
        });
        comboBoxMarkers.setBounds(592, 53, 87, 26);
        panelTools.add(comboBoxMarkers);
        JButton buttonSaveAsPng = new JButton("Save as PNG");
        buttonSaveAsPng.setBounds(694, 50, 163, 29);
        panelTools.add(buttonSaveAsPng);
        buttonSaveAsPng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesViewer.this.panelChart.export();
            }
        });
        buttonSaveAsPng.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/gui/icons/save.gif")));
        JButton buttonPrint = new JButton("Print");
        buttonPrint.setBounds(694, 16, 163, 29);
        panelTools.add(buttonPrint);
        buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesViewer.this.panelChart.doPrint();
            }
        });
        buttonPrint.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/gui/icons/print.gif")));
        comboBoxGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selection = (String)comboBoxGrid.getSelectedItem();
                TimeSeriesViewer.this.panelChart.setDrawGrid("VISIBLE".equals(selection));
            }
        });
        comboBoxLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.LegendFormat selection = (Plot.LegendFormat)((Object)comboBoxLegend.getSelectedItem());
                TimeSeriesViewer.this.panelChart.setDrawLegend(selection);
            }
        });
        buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesViewer.this.panelChart.decreaseZoom();
            }
        });
        buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSeriesViewer.this.panelChart.increaseZoom();
            }
        });
    }

    @Override
    public void notifyOfNewMousePosition(double x, double y, Color colorUnderMouse, String timeSeriesUnderMouse) {
        DecimalFormat df = new DecimalFormat("0.00");
        df.setMaximumFractionDigits(2);
        String stringX = df.format(x);
        String stringY = df.format(y);
        this.labelX.setText("x = " + stringX);
        this.labelY.setText("y = " + stringY);
        this.labelName.setText("Name = " + timeSeriesUnderMouse);
        if (!"".equals(timeSeriesUnderMouse)) {
            this.labelName.setForeground(colorUnderMouse);
        } else {
            this.labelName.setForeground(Color.black);
        }
    }

    @Override
    public void notifyMouseOutOfChart() {
        this.labelX.setText("x = ");
        this.labelY.setText("y = ");
    }
}

