/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.input.sequence_database_list_integers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sequence {
    private final List<List<Integer>> itemsets = new ArrayList<List<Integer>>();
    private int id;

    public Sequence(int id) {
        this.id = id;
    }

    public void addItemset(List<Integer> itemset2) {
        this.itemsets.add(itemset2);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder("");
        for (List<Integer> itemset2 : this.itemsets) {
            r.append('(');
            for (Integer item : itemset2) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append(')');
        }
        return r.append("    ").toString();
    }

    public int getId() {
        return this.id;
    }

    public List<List<Integer>> getItemsets() {
        return this.itemsets;
    }

    public List<Integer> get(int index) {
        return this.itemsets.get(index);
    }

    public int size() {
        return this.itemsets.size();
    }

    public Sequence cloneSequenceMinusItems(Map<Integer, Set<Integer>> mapSequenceID, double relativeMinSup) {
        Sequence sequence = new Sequence(this.getId());
        for (List<Integer> itemset2 : this.itemsets) {
            List<Integer> newItemset = this.cloneItemsetMinusItems(itemset2, mapSequenceID, relativeMinSup);
            if (newItemset.size() == 0) continue;
            sequence.addItemset(newItemset);
        }
        return sequence;
    }

    public Sequence cloneSequenceMinusItems(double relativeMinSup, Map<Integer, Set<Sequence>> mapSequenceID) {
        Sequence sequence = new Sequence(this.getId());
        for (List<Integer> itemset2 : this.itemsets) {
            List<Integer> newItemset = this.cloneItemsetMinusItems(relativeMinSup, itemset2, mapSequenceID);
            if (newItemset.size() == 0) continue;
            sequence.addItemset(newItemset);
        }
        return sequence;
    }

    public List<Integer> cloneItemsetMinusItems(double relativeMinsup, List<Integer> itemset2, Map<Integer, Set<Sequence>> mapSequenceID) {
        ArrayList<Integer> newItemset = new ArrayList<Integer>();
        for (Integer item : itemset2) {
            if (!((double)mapSequenceID.get(item).size() >= relativeMinsup)) continue;
            newItemset.add(item);
        }
        return newItemset;
    }

    public List<Integer> cloneItemsetMinusItems(List<Integer> itemset2, Map<Integer, Set<Integer>> mapSequenceID, double minSupportAbsolute) {
        ArrayList<Integer> newItemset = new ArrayList<Integer>();
        for (Integer item : itemset2) {
            Set<Integer> sidSet = mapSequenceID.get(item);
            if (sidSet == null || !((double)sidSet.size() >= minSupportAbsolute)) continue;
            newItemset.add(item);
        }
        return newItemset;
    }
}

