/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.classifiers.acn.AlgoACN;
import ca.pfv.spmf.algorithms.classifiers.data.StringDataset;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Evaluator;
import ca.pfv.spmf.algorithms.classifiers.general.OverallResults;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestACN_batch_holdout {
    public static void main(String[] args) throws Exception {
        System.out.println("========= Step 1: Read the dataset ==========");
        String targetClassName = "play";
        String datasetPath = MainTestACN_batch_holdout.fileToPath("tennisExtended.txt");
        StringDataset dataset = new StringDataset(datasetPath, targetClassName);
        dataset.printStats();
        System.out.println("==== Step 2: Training:  Apply the algorithm to build a model (a set of rules) ===");
        double minSup = 0.1;
        double minConf = 0.8;
        double minAcc = 0.3;
        double minCorr = 0.3;
        AlgoACN algorithmACN = new AlgoACN(minSup, minConf, minAcc, minCorr);
        Evaluator experiment1 = new Evaluator();
        double percentage = 0.5;
        ClassificationAlgorithm[] algorithms = new ClassificationAlgorithm[]{algorithmACN};
        OverallResults allResults = experiment1.trainAndRunClassifiersHoldout(algorithms, dataset, percentage);
        String forTrainingPath = "outputReportForTraining.txt";
        String onTrainingPath = "outputReportOnTraining.txt";
        String onTrestingPath = "outputReportOnTesting.txt";
        allResults.saveMetricsResultsToFile(forTrainingPath, onTrainingPath, onTrestingPath);
        allResults.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestACN_batch_holdout.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

