/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.data.StringDataset;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.AlgoID3;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.ClassifierID3;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestID3_single_prediction {
    public static void main(String[] args) throws Exception {
        System.out.println("========= Step 1: Read the dataset in memory ==========");
        String targetClassName = "play";
        String datasetPath = MainTestID3_single_prediction.fileToPath("tennisExtended.txt");
        StringDataset dataset = new StringDataset(datasetPath, targetClassName);
        dataset.printStats();
        System.out.println();
        System.out.println("==== Step 2: Train the model and run automated classification experiments on the dataset===");
        System.out.println();
        ClassifierID3 classifier = (ClassifierID3)new AlgoID3().trainAndCalculateStats(dataset);
        classifier.print();
        System.out.println(" Making a prediction for the record: {rainy, mild, high, strong, monday, small}");
        Instance instance = dataset.stringToInstance(new String[]{"rainy", "mild", "high", "strong", "monday", "small"});
        short result = classifier.predict(instance);
        System.out.println("    The predicted value is: " + dataset.getStringCorrespondingToItem(result));
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestID3_single_prediction.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

