/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.classifiers.data.StringDataset;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Evaluator;
import ca.pfv.spmf.algorithms.classifiers.general.OverallResults;
import ca.pfv.spmf.algorithms.classifiers.l3.AlgoL3;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestL3_batch_kfold {
    public static void main(String[] args) throws Exception {
        System.out.println("========= Step 1: Read the dataset ==========");
        String targetClassName = "play";
        String datasetPath = MainTestL3_batch_kfold.fileToPath("tennisExtended.txt");
        StringDataset dataset = new StringDataset(datasetPath, targetClassName);
        dataset.printStats();
        System.out.println("==== Step 2: Training:  Apply the algorithm to build a model (a set of rules) ===");
        double minSup = 0.1;
        double minConf = 0.5;
        AlgoL3 algorithmL3 = new AlgoL3(minSup, minConf);
        ClassificationAlgorithm[] algorithms = new ClassificationAlgorithm[]{algorithmL3};
        Evaluator experiment1 = new Evaluator();
        int kFoldCount = 3;
        OverallResults allResults = experiment1.trainAndRunClassifiersKFold(algorithms, dataset, kFoldCount);
        String forTrainingPath = "outputReportForTraining.txt";
        String onTrainingPath = "outputReportOnTraining.txt";
        String onTrestingPath = "outputReportOnTesting.txt";
        allResults.saveMetricsResultsToFile(forTrainingPath, onTrainingPath, onTrestingPath);
        allResults.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestL3_batch_kfold.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

