/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceStatsGenerator;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Markov.MarkovFirstOrderPredictor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestPPM {
    public static void main(String[] arg) throws IOException, ClassNotFoundException {
        String inputPath = MainTestPPM.fileToPath("contextCPT.txt");
        SequenceDatabase trainingSet = new SequenceDatabase();
        trainingSet.loadFileSPMFFormat(inputPath, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        System.out.println("--- Training sequences ---");
        for (Sequence sequence : trainingSet.getSequences()) {
            System.out.println(sequence.toString());
        }
        System.out.println();
        SequenceStatsGenerator.prinStats(trainingSet, " training sequences ");
        MarkovFirstOrderPredictor predictionModel = new MarkovFirstOrderPredictor("PPM");
        predictionModel.Train(trainingSet.getSequences());
        Sequence sequence = new Sequence(0);
        sequence.addItem(new Item(1));
        sequence.addItem(new Item(4));
        Sequence thePrediction = predictionModel.Predict(sequence);
        System.out.println("For the sequence <(1),(4)>, the prediction for the next symbol is: +" + thePrediction);
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestPPM.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

