/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.episodes.emma.AlgoTKE;
import ca.pfv.spmf.algorithms.episodes.emma.EpisodeEMMA;
import ca.pfv.spmf.algorithms.episodes.standardepisoderules.AlgoGenerateEpisodeRules;
import ca.pfv.spmf.algorithms.episodes.standardepisoderules.EpisodeRule;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.PriorityQueue;

public class MainTestTKE_Rules {
    public static void main(String[] args) throws IOException {
        String inputFile = MainTestTKE_Rules.fileToPath("contextEmma.txt");
        int k = 6;
        int maxWindow = 2;
        boolean selfIncrement = false;
        boolean useDynamicSearch = true;
        AlgoTKE algo = new AlgoTKE();
        algo.setUseDynamicSearch(useDynamicSearch);
        PriorityQueue<EpisodeEMMA> frequentEpisodes = algo.runAlgorithm(inputFile, null, k, maxWindow, selfIncrement);
        algo.printStats();
        int minSup = 2;
        double minConfidence = 0.2;
        int maxConsequentSize = 1;
        String outputFileRules = "Output.txt";
        AlgoGenerateEpisodeRules ruleMiner = new AlgoGenerateEpisodeRules();
        List<EpisodeRule> ruleList = ruleMiner.runAlgorithm(frequentEpisodes, minSup, minConfidence, maxConsequentSize);
        ruleMiner.printStats();
        ruleMiner.writeRulesToFileSPMFFormat(outputFileRules);
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestTKE_Rules.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

