/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_stats;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;

public class TransactionDBUtilityStatsGenerator {
    public void runAlgorithm(String inputPath) throws IOException {
        long totalUtility = 0L;
        int databaseSize = 0;
        int maxID = 0;
        int sumAllLength = 0;
        double avgLength = 0.0;
        int maxLength = 0;
        HashSet<Integer> allItem = new HashSet<Integer>();
        String line = "";
        BufferedReader br = new BufferedReader(new FileReader(inputPath));
        while ((line = br.readLine()) != null) {
            ++databaseSize;
            String[] tokens1 = line.split(":");
            String[] tokens2 = tokens1[0].split(" ");
            totalUtility += Long.parseLong(tokens1[1]);
            sumAllLength += tokens2.length;
            if (maxLength < tokens2.length) {
                maxLength = tokens2.length;
            }
            int i = 0;
            while (i < tokens2.length) {
                int num = Integer.parseInt(tokens2[i]);
                if (num > maxID) {
                    maxID = num;
                }
                allItem.add(num);
                ++i;
            }
        }
        br.close();
        avgLength = (double)((int)((double)sumAllLength / (double)databaseSize * 100.0)) / 100.0;
        System.out.println("----------Database Information----------");
        System.out.println("Number of transations : " + String.valueOf(databaseSize));
        System.out.println("Total utility : " + String.valueOf(totalUtility));
        System.out.println("Number of distinct items : " + String.valueOf(allItem.size()));
        System.out.println("Maximum Id of item : " + String.valueOf(maxID));
        System.out.println("Average length of transaction : " + String.valueOf(avgLength));
        System.out.println("Maximum length of transaction : " + String.valueOf(maxLength));
    }
}

