/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.other_dataset_tools.fix_tdb_utility_time;

import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class AlgoFixTDBTimeUtility {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;

    public void runAlgorithm(String input, String output) throws IOException {
        BufferedWriter writer;
        block18: {
            MemoryLogger.getInstance().reset();
            this.startTimestamp = System.currentTimeMillis();
            writer = new BufferedWriter(new FileWriter(output));
            BufferedReader myInput = null;
            try {
                try {
                    String thisLine;
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty()) continue;
                        if (thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') {
                            writer.write(String.valueOf(thisLine) + " ");
                            writer.newLine();
                            continue;
                        }
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        long totalUtility = 0L;
                        HashMap<Integer, Pair> mapItemToPairAlreadySeen = new HashMap<Integer, Pair>();
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            int item = Integer.parseInt(items[i]);
                            int utility = Integer.parseInt(utilityValues[i]);
                            Pair pair = (Pair)mapItemToPairAlreadySeen.get(item);
                            if (pair == null) {
                                pair = new Pair();
                                pair.item = item;
                                pair.utility = utility;
                                revisedTransaction.add(pair);
                                mapItemToPairAlreadySeen.put(item, pair);
                            } else {
                                pair.utility += (long)utility;
                            }
                            totalUtility += (long)utility;
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return o1.item - o2.item;
                            }
                        });
                        ++tid;
                        i = 0;
                        while (i < revisedTransaction.size()) {
                            Pair pair = (Pair)revisedTransaction.get(i);
                            writer.write(String.valueOf(pair.item));
                            if (i != revisedTransaction.size() - 1) {
                                writer.write(" ");
                            }
                            ++i;
                        }
                        writer.write(":" + totalUtility + ":");
                        i = 0;
                        while (i < revisedTransaction.size()) {
                            Pair pair = (Pair)revisedTransaction.get(i);
                            writer.write(String.valueOf(pair.utility));
                            if (i != revisedTransaction.size() - 1) {
                                writer.write(" ");
                            }
                            ++i;
                        }
                        if (split.length == 4) {
                            long time = Long.parseLong(split[3]);
                            writer.write(":" + time);
                        }
                        writer.newLine();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStats() {
        System.out.println("========  FIX TransactionDB tool (with Utility/time) - STATS =======");
        System.out.println(" Runtime ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================================================");
    }

    class Pair {
        int item = 0;
        long utility = 0L;

        Pair() {
        }
    }
}

