"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-client-explicit-props');
const userpool = new lib_1.UserPool(stack, 'myuserpool');
userpool.addClient('myuserpoolclient', {
    userPoolClientName: 'myuserpoolclient',
    authFlows: {
        adminUserPassword: true,
        custom: true,
        refreshToken: true,
        userPassword: true,
        userSrp: true,
    },
    generateSecret: true,
    oAuth: {
        flows: {
            implicitCodeGrant: true,
            authorizationCodeGrant: true,
        },
        scopes: [
            lib_1.OAuthScope.PHONE,
            lib_1.OAuthScope.EMAIL,
            lib_1.OAuthScope.OPENID,
            lib_1.OAuthScope.PROFILE,
            lib_1.OAuthScope.COGNITO_ADMIN,
            lib_1.OAuthScope.custom('my-resource-server/my-scope'),
        ],
        callbackUrls: ['https://redirect-here.myapp.com'],
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudXNlci1wb29sLWNsaWVudC1leHBsY2l0LXByb3BzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcudXNlci1wb29sLWNsaWVudC1leHBsY2l0LXByb3BzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQTJDO0FBQzNDLGdDQUE4QztBQUU5QyxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSx1Q0FBdUMsQ0FBQyxDQUFDO0FBRXRFLE1BQU0sUUFBUSxHQUFHLElBQUksY0FBUSxDQUFDLEtBQUssRUFBRSxZQUFZLENBQUMsQ0FBQztBQUVuRCxRQUFRLENBQUMsU0FBUyxDQUFDLGtCQUFrQixFQUFFO0lBQ3JDLGtCQUFrQixFQUFFLGtCQUFrQjtJQUN0QyxTQUFTLEVBQUU7UUFDVCxpQkFBaUIsRUFBRSxJQUFJO1FBQ3ZCLE1BQU0sRUFBRSxJQUFJO1FBQ1osWUFBWSxFQUFFLElBQUk7UUFDbEIsWUFBWSxFQUFFLElBQUk7UUFDbEIsT0FBTyxFQUFFLElBQUk7S0FDZDtJQUNELGNBQWMsRUFBRSxJQUFJO0lBQ3BCLEtBQUssRUFBRTtRQUNMLEtBQUssRUFBRTtZQUNMLGlCQUFpQixFQUFFLElBQUk7WUFDdkIsc0JBQXNCLEVBQUUsSUFBSTtTQUM3QjtRQUNELE1BQU0sRUFBRTtZQUNOLGdCQUFVLENBQUMsS0FBSztZQUNoQixnQkFBVSxDQUFDLEtBQUs7WUFDaEIsZ0JBQVUsQ0FBQyxNQUFNO1lBQ2pCLGdCQUFVLENBQUMsT0FBTztZQUNsQixnQkFBVSxDQUFDLGFBQWE7WUFDeEIsZ0JBQVUsQ0FBQyxNQUFNLENBQUMsNkJBQTZCLENBQUM7U0FDakQ7UUFDRCxZQUFZLEVBQUUsQ0FBRSxpQ0FBaUMsQ0FBRTtLQUNwRDtDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IE9BdXRoU2NvcGUsIFVzZXJQb29sIH0gZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAnaW50ZWctdXNlci1wb29sLWNsaWVudC1leHBsaWNpdC1wcm9wcycpO1xuXG5jb25zdCB1c2VycG9vbCA9IG5ldyBVc2VyUG9vbChzdGFjaywgJ215dXNlcnBvb2wnKTtcblxudXNlcnBvb2wuYWRkQ2xpZW50KCdteXVzZXJwb29sY2xpZW50Jywge1xuICB1c2VyUG9vbENsaWVudE5hbWU6ICdteXVzZXJwb29sY2xpZW50JyxcbiAgYXV0aEZsb3dzOiB7XG4gICAgYWRtaW5Vc2VyUGFzc3dvcmQ6IHRydWUsXG4gICAgY3VzdG9tOiB0cnVlLFxuICAgIHJlZnJlc2hUb2tlbjogdHJ1ZSxcbiAgICB1c2VyUGFzc3dvcmQ6IHRydWUsXG4gICAgdXNlclNycDogdHJ1ZSxcbiAgfSxcbiAgZ2VuZXJhdGVTZWNyZXQ6IHRydWUsXG4gIG9BdXRoOiB7XG4gICAgZmxvd3M6IHtcbiAgICAgIGltcGxpY2l0Q29kZUdyYW50OiB0cnVlLFxuICAgICAgYXV0aG9yaXphdGlvbkNvZGVHcmFudDogdHJ1ZSxcbiAgICB9LFxuICAgIHNjb3BlczogW1xuICAgICAgT0F1dGhTY29wZS5QSE9ORSxcbiAgICAgIE9BdXRoU2NvcGUuRU1BSUwsXG4gICAgICBPQXV0aFNjb3BlLk9QRU5JRCxcbiAgICAgIE9BdXRoU2NvcGUuUFJPRklMRSxcbiAgICAgIE9BdXRoU2NvcGUuQ09HTklUT19BRE1JTixcbiAgICAgIE9BdXRoU2NvcGUuY3VzdG9tKCdteS1yZXNvdXJjZS1zZXJ2ZXIvbXktc2NvcGUnKSxcbiAgICBdLFxuICAgIGNhbGxiYWNrVXJsczogWyAnaHR0cHM6Ly9yZWRpcmVjdC1oZXJlLm15YXBwLmNvbScgXSxcbiAgfSxcbn0pOyJdfQ==